/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.pool;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;

public class ClockPool
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)ClockPool.class);
    private String poolName;
    protected ClockDaemon clockDaemon;
    private static final GBeanInfo GBEAN_INFO;

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public ClockDaemon getClockDaemon() {
        return this.clockDaemon;
    }

    public void doStart() throws WaitingException, Exception {
        this.clockDaemon = new ClockDaemon();
        this.clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, ClockPool.this.poolName + " ");
                t.setDaemon(true);
                return t;
            }
        });
        log.info((Object)("Clock pool " + this.poolName + " started"));
    }

    public void doStop() throws WaitingException, Exception {
        this.clockDaemon.shutDown();
        log.info((Object)("Clock pool " + this.poolName + " stopped"));
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(ClockPool.class);
        infoFactory.addAttribute("poolName", String.class, true);
        infoFactory.addOperation("getClockDaemon");
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

