/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.lock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.lock.InstanceLock;
import org.apache.geronimo.lock.LockContext;
import org.apache.geronimo.lock.LockDomain;
import org.apache.geronimo.lock.LockReentranceException;

public class TxLockContext
extends LockContext {
    private static final Log log = LogFactory.getLog((Class)LockContext.class);
    private boolean isTrace = log.isTraceEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sharedLock(LockDomain domain, Object key) throws LockReentranceException, InterruptedException {
        if (this.isTrace) {
            log.trace((Object)("Tx Shared Lock domain=" + domain + ", id=" + key));
        }
        InstanceLock lock = domain.getLock(key);
        TxLockContext txLockContext = this;
        synchronized (txLockContext) {
            if (!this.locks.contains(lock)) {
                this.sharedLock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveLock(LockDomain domain, Object key) throws LockReentranceException, InterruptedException {
        if (this.isTrace) {
            log.trace((Object)("Tx Exclusive Lock domain=" + domain + ", id=" + key));
        }
        InstanceLock lock = domain.getLock(key);
        TxLockContext txLockContext = this;
        synchronized (txLockContext) {
            if (!this.locks.contains(lock)) {
                this.exclusiveLock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(LockDomain domain, Object key) {
        if (this.isTrace) {
            log.trace((Object)("Tx Release Lock domain=" + domain + ", id=" + key));
        }
        InstanceLock lock = domain.getLock(key);
        TxLockContext txLockContext = this;
        synchronized (txLockContext) {
            this.releaseLock(lock);
        }
    }
}

