/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.lock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.lock.InstanceLock;
import org.apache.geronimo.lock.LockContext;
import org.apache.geronimo.lock.LockDomain;
import org.apache.geronimo.lock.LockReentranceException;

public class NoTxLockContext
extends LockContext {
    private static final Log log = LogFactory.getLog((Class)LockContext.class);
    private boolean isTrace = log.isTraceEnabled();

    public void sharedLock(LockDomain domain, Object key) throws LockReentranceException, InterruptedException {
        if (this.isTrace) {
            log.trace((Object)("NoTx Shared Lock domain=" + domain + ", id=" + key));
        }
        InstanceLock lock = domain.getLock(key);
        this.sharedLock(lock);
    }

    public void exclusiveLock(LockDomain domain, Object key) throws LockReentranceException, InterruptedException {
        if (this.isTrace) {
            log.trace((Object)("NoTx Exclusive Lock domain=" + domain + ", id=" + key));
        }
        InstanceLock lock = domain.getLock(key);
        this.exclusiveLock(lock);
    }

    public void release(LockDomain domain, Object key) {
        if (this.isTrace) {
            log.trace((Object)("NoTx Release Lock domain=" + domain + ", id=" + key));
        }
        InstanceLock lock = domain.getLock(key);
        this.releaseLock(lock);
    }
}

