/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.enterprise.deploy.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.enterprise.deploy.tool.AbstractDeployableObject;
import org.apache.geronimo.enterprise.deploy.tool.DDBeanRootImpl;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WebDeployableObject
extends AbstractDeployableObject {
    private static final Log log = LogFactory.getLog((Class)WebDeployableObject.class);
    private static final String WAR_DD = "WEB-INF/web.xml";

    public WebDeployableObject(JarFile jar, ClassLoader loader) {
        super(jar, ModuleType.WAR, WebDeployableObject.createWebAppRoot(jar), loader);
    }

    public DDBeanRoot getDDBeanRoot(String filename) throws FileNotFoundException, DDBeanCreateException {
        if (filename.equals(WAR_DD)) {
            if (super.getDDBeanRoot() == null) {
                throw new FileNotFoundException("No DD " + filename + " available");
            }
            return super.getDDBeanRoot();
        }
        throw new FileNotFoundException("Unrecognized file: " + filename);
    }

    private static DDBeanRootImpl createWebAppRoot(JarFile jar) {
        DDBeanRootImpl beanRoot = WebDeployableObject.createDDBeanRoot(jar, WAR_DD);
        if (beanRoot == null) {
            return null;
        }
        Element root = beanRoot.getDocument().getRootElement();
        if (!root.getName().equals("web-app") || root.attributeValue("version") == null || !root.attributeValue("version").equals("2.4")) {
            log.error((Object)"Not a Web App 2.4 deployment descriptor");
            return null;
        }
        return beanRoot;
    }

    private static DDBeanRootImpl createDDBeanRoot(JarFile jar, String fileName) {
        try {
            InputStream in = jar.getInputStream(jar.getEntry(fileName));
            if (in == null) {
                return null;
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(in);
            return new DDBeanRootImpl(document);
        }
        catch (IOException e) {
            log.error((Object)("Unable to locate DD " + fileName + " in WAR"), (Throwable)e);
            return null;
        }
        catch (DocumentException e) {
            log.error((Object)("Unable to parse DD " + fileName + " in WAR"), (Throwable)e);
            return null;
        }
    }
}

