/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.enterprise.deploy.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.enterprise.deploy.tool.AbstractDeployableObject;
import org.apache.geronimo.enterprise.deploy.tool.DDBeanRootImpl;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EjbDeployableObject
extends AbstractDeployableObject {
    private static final Log log = LogFactory.getLog((Class)EjbDeployableObject.class);
    private static final String EJB_JAR_DD = "META-INF/ejb-jar.xml";

    public EjbDeployableObject(JarFile jar, ClassLoader loader) {
        super(jar, ModuleType.EJB, EjbDeployableObject.createEjbJarRoot(jar), loader);
    }

    public DDBeanRoot getDDBeanRoot(String filename) throws FileNotFoundException, DDBeanCreateException {
        if (filename.equals(EJB_JAR_DD)) {
            return super.getDDBeanRoot();
        }
        return null;
    }

    private static DDBeanRootImpl createEjbJarRoot(JarFile jar) {
        DDBeanRootImpl beanRoot = EjbDeployableObject.createDDBeanRoot(jar, EJB_JAR_DD);
        Element root = beanRoot.getDocument().getRootElement();
        if (!root.getName().equals("ejb-jar") || !root.attribute("version").getValue().equals("2.1")) {
            log.error((Object)"Not an EJB 2.1 deployment descriptor");
            return null;
        }
        return beanRoot;
    }

    private static DDBeanRootImpl createDDBeanRoot(JarFile jar, String fileName) {
        try {
            InputStream in = jar.getInputStream(jar.getEntry(fileName));
            SAXReader reader = new SAXReader();
            Document document = reader.read(in);
            return new DDBeanRootImpl(document);
        }
        catch (IOException e) {
            log.error((Object)("Unable to locate DD " + fileName + " in EJB JAR"), (Throwable)e);
            return null;
        }
        catch (DocumentException e) {
            log.error((Object)("Unable to parse DD " + fileName + " in EJB JAR"), (Throwable)e);
            return null;
        }
    }
}

