/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;
import org.apache.geronimo.console.cli.controller.ConnectDeploymentManager;
import org.apache.geronimo.console.cli.controller.ControlDeployments;
import org.apache.geronimo.console.cli.controller.DistributeModule;
import org.apache.geronimo.console.cli.controller.SelectServer;

public class TopLevel
extends TextController {
    private static final Log log = LogFactory.getLog((Class)TopLevel.class);

    public TopLevel(DeploymentContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        block5: while (true) {
            this.println("  " + (this.context.connected ? "--" : "1)") + " Connect to the deployment server");
            this.println("  " + (this.context.connected ? "--" : "--") + " Configure a module");
            this.println("  " + (this.context.connected ? "3)" : "--") + " Control working targets");
            this.println("  " + (this.context.connected ? "4)" : "--") + " Distribute plan or module");
            this.println("  " + (this.context.connected ? "5)" : "--") + " Control existing plans or modules");
            this.println("  " + (this.context.connected ? "6)" : "--") + " Disconnect from the deployment server");
            while (true) {
                String choice;
                this.print("Action ([1-6] or [Q]uit): ");
                this.context.out.flush();
                try {
                    choice = this.context.in.readLine().trim().toLowerCase();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to read user input", (Throwable)e);
                    return;
                }
                if (choice.equals("1")) {
                    if (this.context.connected) {
                        this.println("To re-connect, please disconnect first.");
                        continue;
                    }
                    new ConnectDeploymentManager(this.context).execute();
                    continue block5;
                }
                if (choice.equals("2")) {
                    this.println("Not yet available");
                    continue;
                }
                if (choice.equals("3")) {
                    if (!this.ensureConnected()) continue;
                    new SelectServer(this.context).execute();
                    continue block5;
                }
                if (choice.equals("4")) {
                    if (!this.ensureConnected()) continue;
                    new DistributeModule(this.context).execute();
                    continue block5;
                }
                if (choice.equals("5")) {
                    if (!this.ensureConnected()) continue;
                    new ControlDeployments(this.context).execute();
                    continue block5;
                }
                if (choice.equals("6")) {
                    if (!this.ensureConnected()) continue;
                    this.println("Disconnecting from deployment server...");
                    try {
                        this.context.deployer.release();
                        continue block5;
                    }
                    finally {
                        this.println("Disconnected.");
                        this.context.connected = false;
                        continue block5;
                    }
                }
                if (choice.equals("q")) break block5;
            }
            break;
        }
    }
}

