/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;

public class LoadServerSpecificDD
extends TextController {
    private static final Log log = LogFactory.getLog((Class)LoadServerSpecificDD.class);

    public LoadServerSpecificDD(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        File file;
        this.context.out.println("\nCurrent directory is " + this.context.saveDir);
        this.context.out.println("Select a file name.  The server-specific deployment information for the ");
        this.context.out.println(this.context.moduleInfo.getFileName() + " will be loaded from the file you specify.");
        while (true) {
            String choice;
            this.context.out.print("File Name: ");
            this.context.out.flush();
            try {
                choice = this.context.in.readLine().trim();
            }
            catch (IOException e) {
                log.error((Object)"Unable to read user input", (Throwable)e);
                return;
            }
            file = new File(this.context.saveDir, choice);
            if (file.canRead() && !file.isDirectory()) break;
            this.context.out.println("ERROR: cannot read from this file.  Please try again.");
        }
        this.context.saveDir = file.getParentFile();
        try {
            this.context.moduleInfo.loadDConfigBean(file);
            this.context.out.println("Deployment information loaded from " + file.getName());
            return;
        }
        catch (IOException e) {
            log.error((Object)"Unable to read from file", (Throwable)e);
            return;
        }
        catch (ConfigurationException e) {
            this.context.out.println("ERROR: " + e.getMessage());
            if (e.getCause() != null) {
                e.printStackTrace(this.context.out);
            }
            return;
        }
    }
}

