/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;
import org.apache.geronimo.console.cli.module.WARInfo;
import org.apache.geronimo.enterprise.deploy.tool.WebDeployableObject;

public class InitializeWAR
extends TextController {
    private static final Log log = LogFactory.getLog((Class)InitializeWAR.class);

    public InitializeWAR(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        if (!(this.context.moduleInfo instanceof WARInfo)) {
            throw new IllegalStateException("Tried to load a WAR but the current module is " + this.context.moduleInfo.getClass().getName());
        }
        WARInfo warInfo = (WARInfo)this.context.moduleInfo;
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{warInfo.file.toURL()}, ClassLoader.getSystemClassLoader());
            this.context.standardModule = new WebDeployableObject(warInfo.jarFile, loader);
        }
        catch (MalformedURLException e) {
            this.context.out.println("ERROR: " + warInfo.file + " is not a valid JAR file!");
            this.context.moduleInfo = null;
            return;
        }
        try {
            this.context.serverModule = this.context.deployer.createConfiguration(this.context.standardModule);
        }
        catch (InvalidModuleException e) {
            this.context.out.println("ERROR: Unable to initialize a Geronimo DD for WAR " + warInfo.file);
            this.context.moduleInfo = null;
            return;
        }
        warInfo.war = this.context.standardModule.getDDBeanRoot();
        try {
            warInfo.warConfig = this.context.serverModule.getDConfigBeanRoot(warInfo.war);
            this.initializeDConfigBean((DConfigBean)warInfo.warConfig);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Unable to initialize server-specific deployment information", (Throwable)e);
            this.context.moduleInfo = null;
            return;
        }
    }
}

