/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;
import org.apache.geronimo.console.cli.module.EJBJARInfo;
import org.apache.geronimo.enterprise.deploy.tool.EjbDeployableObject;

public class InitializeEJBJAR
extends TextController {
    private static final Log log = LogFactory.getLog((Class)InitializeEJBJAR.class);

    public InitializeEJBJAR(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        if (!(this.context.moduleInfo instanceof EJBJARInfo)) {
            throw new IllegalStateException("Tried to load an EJB JAR but the current module is " + this.context.moduleInfo.getClass().getName());
        }
        EJBJARInfo jarInfo = (EJBJARInfo)this.context.moduleInfo;
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{jarInfo.file.toURL()}, ClassLoader.getSystemClassLoader());
            this.context.standardModule = new EjbDeployableObject(jarInfo.jarFile, loader);
        }
        catch (MalformedURLException e) {
            this.context.out.println("ERROR: " + jarInfo.file + " is not a valid JAR file!");
            this.context.moduleInfo = null;
            return;
        }
        try {
            this.context.serverModule = this.context.deployer.createConfiguration(this.context.standardModule);
        }
        catch (InvalidModuleException e) {
            this.context.out.println("ERROR: Unable to initialize a Geronimo DD for EJB JAR " + jarInfo.file);
            this.context.moduleInfo = null;
            return;
        }
        jarInfo.ejbJar = this.context.standardModule.getDDBeanRoot();
        jarInfo.editingEjbJar = true;
        try {
            jarInfo.ejbJarConfig = this.context.serverModule.getDConfigBeanRoot(jarInfo.ejbJar);
            this.initializeDConfigBean((DConfigBean)jarInfo.ejbJarConfig);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Unable to initialize server-specific deployment information", (Throwable)e);
            this.context.moduleInfo = null;
            return;
        }
    }
}

