/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;
import org.apache.geronimo.console.cli.controller.ProgressMonitor;
import org.apache.geronimo.console.cli.controller.SelectDistributedModules;
import org.apache.geronimo.console.cli.controller.SelectServer;

public class DeploymentOptions
extends TextController {
    private static final Log log = LogFactory.getLog((Class)DeploymentOptions.class);

    public DeploymentOptions(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        block5: while (true) {
            this.newScreen("Deploy Module");
            if (!this.context.connected) {
                this.println("ERROR: cannot deploy in disconnected mode.");
                return;
            }
            this.context.out.println((this.context.targets.length == 0 ? "No" : String.valueOf(this.context.targets.length)) + " target" + (this.context.targets.length != 1 ? "s" : "") + " currently selected.");
            this.context.out.println("  1) Select targets (usually servers or clusters) to work with");
            this.context.out.println("  " + (this.context.targets.length > 0 ? "2)" : "--") + " Distribute " + this.context.moduleInfo.file.getName() + " to selected targets");
            this.context.out.println("  " + (this.context.targets.length > 0 ? "3)" : "--") + " Deploy " + this.context.moduleInfo.file.getName() + " to selected targets");
            this.context.out.println("  " + (this.context.targets.length > 0 && this.context.deployer.isRedeploySupported() ? "4)" : "--") + " Redeploy " + this.context.moduleInfo.file.getName() + " to selected targets");
            while (true) {
                String choice;
                this.context.out.print("Action ([1" + (this.context.targets.length > 0 ? "-4" : "") + "] or [B]ack): ");
                this.context.out.flush();
                try {
                    choice = this.context.in.readLine().trim().toLowerCase();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to read user input", (Throwable)e);
                    return;
                }
                try {
                    ProgressObject po;
                    if (choice.equals("1")) {
                        new SelectServer(this.context).execute();
                        continue block5;
                    }
                    if (choice.equals("2")) {
                        this.distribute();
                        continue block5;
                    }
                    if (choice.equals("3")) {
                        po = this.distribute();
                        if (po != null) {
                            TargetModuleID[] ids = po.getResultTargetModuleIDs();
                            this.println("Successfully distributed " + ids.length + " modules." + (ids.length > 0 ? "Now starting them..." : ""));
                            if (ids.length <= 0 || (po = this.context.deployer.start(ids)) == null) continue block5;
                            new ProgressMonitor(this.context, po).execute();
                            continue block5;
                        }
                        this.println("ERROR: Modules have been distributed but must be manually started.");
                        continue block5;
                    }
                    if (choice.equals("4")) {
                        new SelectDistributedModules(this.context, new SelectDistributedModules.NonRunningModules("redeploy")).execute();
                        if (this.context.modules.length <= 0) continue block5;
                        this.println("Prepared to update " + this.context.modules.length + " deployments with new " + this.context.moduleInfo.file.getName());
                        if (!this.confirmModuleAction("Redeploy") || (po = this.context.deployer.redeploy(this.context.modules, this.context.moduleInfo.file, this.spool())) == null) continue block5;
                        new ProgressMonitor(this.context, po).execute();
                        continue block5;
                    }
                    if (!choice.equals("b")) continue;
                    return;
                }
                catch (ConfigurationException e) {
                    log.error((Object)"Server action failed", (Throwable)e);
                    continue;
                }
                catch (IOException e) {
                    log.error((Object)"Server action failed", (Throwable)e);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private ProgressObject distribute() throws ConfigurationException, IOException {
        File dd = this.spool();
        ProgressObject po = this.context.deployer.distribute(this.context.targets, this.context.moduleInfo.file, dd);
        if (po != null) {
            new ProgressMonitor(this.context, po).execute();
        }
        return po;
    }

    private File spool() throws IOException, ConfigurationException {
        File temp = File.createTempFile("gerdd", "xml");
        temp.deleteOnExit();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(temp));
        this.context.serverModule.save((OutputStream)out);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        return temp;
    }
}

