/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.controller.TopLevel;

public class Deployer {
    private static final Log log = LogFactory.getLog((Class)Deployer.class);
    private final DeploymentContext context = new DeploymentContext();

    public static void main(String[] args) {
        if (0 == args.length) {
            System.err.println("DeploymentFactory archives not specified.");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            if (!file.isFile()) {
                System.err.println(args[i] + " does not exist.");
                System.exit(2);
            }
            Deployer.registerDeploymentFactory(file);
        }
        Deployer deployer = new Deployer();
        deployer.run();
    }

    private static void registerDeploymentFactory(File anArchive) {
        String clazzName = null;
        try {
            JarFile jarFile = new JarFile(anArchive);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            clazzName = attributes.getValue("J2EE-DeploymentFactory-Implementation-Class");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Can not retrieve DeploymentManagerFactory");
            System.exit(3);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.err.println("No J2EE-DeploymentFactory-Implementation-Class.");
            System.exit(4);
        }
        try {
            URLClassLoader cl = new URLClassLoader(new URL[]{anArchive.toURL()});
            Class<?> clazz = cl.loadClass(clazzName);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)clazz.newInstance());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println("Can not load " + clazzName);
            System.exit(5);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.err.println("Can not create " + clazzName);
            System.exit(5);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.err.println("Can not create " + clazzName);
            System.exit(5);
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    public Deployer() throws IllegalStateException, IllegalArgumentException {
        this(new PrintWriter((Writer)new OutputStreamWriter(System.out), true), new BufferedReader(new InputStreamReader(System.in)));
    }

    public Deployer(PrintWriter out, Reader in) throws IllegalStateException, IllegalArgumentException {
        this.context.out = out;
        this.context.in = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
    }

    public void run() {
        new TopLevel(this.context).execute();
        this.context.deployer.release();
    }
}

