/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;

public class DConfigBeanConfigurator {
    private static final Log log = LogFactory.getLog((Class)DConfigBeanConfigurator.class);
    private PrintWriter out;
    private BufferedReader in;
    private Stack beans = new Stack();

    public DConfigBeanConfigurator(DConfigBeanRoot bean, PrintWriter out, BufferedReader in) {
        this.out = out;
        this.in = in;
        this.beans.push(bean);
    }

    public boolean configure() {
        try {
            this.initialize();
            return true;
        }
        catch (IntrospectionException e) {
            log.error((Object)"Unable to introspect a JavaBean", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Unable to gather input from user", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Unable to read or write a JavaBean property", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Unable to read or write a JavaBean property", (Throwable)e);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Unable to generate a child DConfigBean", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Unable to generate a child bean", (Throwable)e);
        }
        return false;
    }

    private void initialize() throws IntrospectionException, IOException, InvocationTargetException, IllegalAccessException, ConfigurationException, InstantiationException {
        boolean forward = true;
        PropertyDescriptor[] properties = new PropertyDescriptor[]{};
        PropertyDescriptor[] readOnly = new PropertyDescriptor[]{};
        PropertyDescriptor[] childProps = new PropertyDescriptor[]{};
        HashMap<String, DConfigBean[]> childTypes = new HashMap<String, DConfigBean[]>();
        while (true) {
            int value;
            PropertyDescriptor property;
            int i;
            this.out.println("\n\n");
            Object bean = this.beans.peek();
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            String indent = this.printLocation();
            childTypes.clear();
            if (bean instanceof DConfigBean) {
                DConfigBean dcb = (DConfigBean)bean;
                String[] xpaths = dcb.getXpaths();
                for (int i2 = 0; i2 < xpaths.length; ++i2) {
                    DDBean[] ddbs = dcb.getDDBean().getChildBean(xpaths[i2]);
                    if (ddbs.length == 0) continue;
                    DConfigBean[] list = new DConfigBean[ddbs.length];
                    for (int j = 0; j < ddbs.length; ++j) {
                        list[j] = dcb.getDConfigBean(ddbs[j]);
                    }
                    childTypes.put(Introspector.getBeanInfo(list[0].getClass()).getBeanDescriptor().getDisplayName(), list);
                }
                Iterator iterator = childTypes.keySet().iterator();
                while (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    int number = ((DConfigBean[])childTypes.get(s)).length;
                    this.out.println(indent + "+ " + s + " (" + number + " entr" + (number == 1 ? "y" : "ies") + ")");
                }
            }
            childProps = this.getChildProperties(info.getPropertyDescriptors());
            for (i = 0; i < childProps.length; ++i) {
                PropertyDescriptor prop = childProps[i];
                if (prop instanceof IndexedPropertyDescriptor) {
                    int number = ((Object[])prop.getReadMethod().invoke(bean, new Object[0])).length;
                    this.out.println(indent + "+ " + prop.getDisplayName() + " (" + number + " entr" + (number == 1 ? "y" : "ies") + ")");
                    continue;
                }
                this.out.println(indent + "+ " + prop.getDisplayName() + " (child property)");
            }
            this.out.println();
            int count = 0;
            properties = this.getNormalProperties(info.getPropertyDescriptors());
            readOnly = this.getReadOnly(info.getPropertyDescriptors());
            for (i = 0; i < readOnly.length; ++i) {
                property = readOnly[i];
                this.out.println(property.getDisplayName() + ": " + property.getReadMethod().invoke(bean, new Object[0]));
            }
            if (properties.length > 0) {
                this.out.println("Properties for " + this.getFullName(bean) + ":");
            }
            for (i = 0; i < properties.length; ++i) {
                property = properties[i];
                this.out.println("  " + ++count + ": " + property.getDisplayName() + " (" + property.getReadMethod().invoke(bean, new Object[0]) + ")");
            }
            this.out.flush();
            if (properties.length == 0 && childTypes.size() == 1 && childProps.length == 0) {
                DConfigBean[] children = (DConfigBean[])childTypes.values().iterator().next();
                if (children.length == 1) {
                    if (forward) {
                        this.out.println("Nothing interesting to do here.  Moving on.");
                        this.beans.push(children[0]);
                        continue;
                    }
                    if (this.beans.size() > 1) {
                        this.out.println("Nothing interesting to do here.  Moving on.");
                        this.beans.pop();
                        continue;
                    }
                }
            } else if (properties.length == 0 && childTypes.size() == 0 && childProps.length == 1 && !(childProps[0] instanceof IndexedPropertyDescriptor)) {
                if (forward) {
                    this.out.println("Nothing interesting to do here.  Moving on.");
                    this.beans.push(childProps[0].getReadMethod().invoke(bean, new Object[0]));
                    continue;
                }
                if (this.beans.size() > 1) {
                    this.out.println("Nothing interesting to do here.  Moving on.");
                    this.beans.pop();
                    continue;
                }
            }
            if (properties.length > 0) {
                this.out.println();
            }
            this.out.print("Action (");
            boolean first = true;
            if (properties.length > 0) {
                if (!first) {
                    this.out.print(" / ");
                }
                this.out.print("Edit [P]roperty");
                first = false;
            }
            if (childTypes.size() > 0 || childProps.length > 0) {
                if (!first) {
                    this.out.print(" / ");
                }
                this.out.print("Move [D]own");
                first = false;
            }
            if (this.beans.size() > 1) {
                if (!first) {
                    this.out.print(" / ");
                }
                this.out.print("Move [U]p");
                first = false;
            }
            if (!first) {
                this.out.print(" / ");
            }
            this.out.print("[Q]uit");
            first = false;
            this.out.print("): ");
            this.out.flush();
            String choice = this.in.readLine().trim().toLowerCase();
            if (choice.equals("u")) {
                forward = false;
                this.beans.pop();
                continue;
            }
            if (choice.equals("d")) {
                forward = true;
                if (childTypes.size() == 0 && childProps.length == 0) {
                    log.warn((Object)"No children available here.");
                    continue;
                }
                this.selectChildBean(childTypes, bean, childProps);
                continue;
            }
            if (choice.equals("q")) {
                return;
            }
            if (choice.equals("p")) {
                if (properties.length == 0) {
                    log.warn((Object)"No editable properties available here.");
                    continue;
                }
                this.editProperty(bean, properties);
                continue;
            }
            if (this.isNumber(choice) && (value = Integer.parseInt(choice)) > 0 && value <= properties.length) {
                this.editProperty(bean, properties[value - 1]);
                continue;
            }
            log.error((Object)"I don't know how to do that (yet)");
        }
    }

    private void editProperty(Object bean, PropertyDescriptor[] properties) throws IOException, InvocationTargetException, IllegalAccessException {
        if (properties.length == 1) {
            this.editProperty(bean, properties[0]);
            return;
        }
        String choice = null;
        while (true) {
            this.out.print("Edit which property (1-" + properties.length + ")? ");
            this.out.flush();
            choice = this.in.readLine();
            try {
                int value = Integer.parseInt(choice);
                if (value <= 0 || value > properties.length) continue;
                this.editProperty(bean, properties[value - 1]);
                return;
            }
            catch (NumberFormatException e) {
                continue;
            }
            break;
        }
    }

    private void editProperty(final Object bean, final PropertyDescriptor property) throws InvocationTargetException, IllegalAccessException, IOException {
        final PropertyEditor pe = PropertyEditors.findEditor(property.getPropertyType());
        pe.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    property.getWriteMethod().invoke(bean, pe.getValue());
                    pe.removePropertyChangeListener(this);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"Not allowed to set property", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"Invalid value for property", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)"Exception occured while setting property", e.getTargetException());
                }
            }
        });
        this.out.println("\nEditing Property " + property.getDisplayName());
        Object value = property.getReadMethod().invoke(bean, new Object[0]);
        if (value == null) {
            value = pe.getJavaInitializationString();
        }
        this.out.println("  Old value is: '" + value + "'");
        this.out.println("  Specify a new value.  Enter nothing to keep the current value.\n  Type (empty) for an empty string or (null) for a null.");
        this.out.print("New Value: ");
        this.out.flush();
        String choice = this.in.readLine();
        if (choice.equals("")) {
            return;
        }
        if (choice.equals("(null)")) {
            choice = null;
        } else if (choice.equals("(empty)")) {
            choice = "";
        }
        pe.setAsText(choice);
    }

    private void selectChildBean(Map types, Object bean, PropertyDescriptor[] props) throws IOException, InvocationTargetException, IllegalAccessException, InstantiationException {
        PropertyDescriptor prop;
        DConfigBean[] cbs;
        block16: {
            cbs = null;
            prop = null;
            if (types.size() + props.length > 1) {
                int count = 0;
                this.out.println("\nAvailable Children:");
                Iterator iterator = types.keySet().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    this.out.println("  [" + ++count + "] " + name);
                }
                for (int i = 0; i < props.length; ++i) {
                    this.out.println("  [" + ++count + "] " + props[i].getDisplayName());
                }
                while (true) {
                    this.out.print("Select child type (1-" + (types.size() + props.length) + "): ");
                    this.out.flush();
                    String choice = this.in.readLine();
                    try {
                        int value = Integer.parseInt(choice);
                        if (value > 0 && value <= types.size()) {
                            count = 0;
                            String key = null;
                            Iterator iterator2 = types.keySet().iterator();
                            while (iterator2.hasNext() && count++ < value) {
                                key = (String)iterator2.next();
                            }
                            cbs = (DConfigBean[])types.get(key);
                            if (cbs == null) continue;
                        } else {
                            if (value <= types.size() || value > types.size() + props.length) continue;
                            prop = props[value - types.size() - 1];
                        }
                        break block16;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    break;
                }
            }
            if (types.size() == 1) {
                cbs = (DConfigBean[])types.values().iterator().next();
            } else if (props.length == 1) {
                prop = props[0];
            } else {
                log.error((Object)"You've confused me.  Please try again.");
            }
        }
        if (cbs != null) {
            this.selectChildDConfigBean(cbs);
        } else if (prop != null) {
            this.selectChildProperty(bean, prop);
        }
    }

    private void selectChildProperty(Object bean, PropertyDescriptor prop) throws InvocationTargetException, IllegalAccessException, IOException, InstantiationException {
        if (!(prop instanceof IndexedPropertyDescriptor)) {
            this.beans.push(prop.getReadMethod().invoke(bean, new Object[0]));
            return;
        }
        while (true) {
            this.out.println("\nEditing list of " + prop.getDisplayName());
            Object[] values = (Object[])prop.getReadMethod().invoke(bean, new Object[0]);
            if (values.length == 0) {
                this.out.println("  (list is currently empty)");
            }
            for (int i = 0; i < values.length; ++i) {
                this.out.println("  " + (i + 1) + ": " + values[i]);
            }
            this.out.print("Action ([C]reate entry");
            if (values.length > 0) {
                this.out.print(" / [D]elete entry / edit entry [1" + (values.length > 1 ? "-" + values.length : "") + "]");
            }
            this.out.print(" / [B]ack): ");
            this.out.flush();
            String choice = this.in.readLine().trim().toLowerCase();
            if (choice.equals("c")) {
                Object[] newv = (Object[])Array.newInstance(values.getClass().getComponentType(), values.length + 1);
                System.arraycopy(values, 0, newv, 0, values.length);
                newv[values.length] = values.getClass().getComponentType().newInstance();
                prop.getWriteMethod().invoke(bean, new Object[]{newv});
                continue;
            }
            if (choice.equals("b")) {
                return;
            }
            if (this.isNumber(choice)) {
                int number = Integer.parseInt(choice);
                if (number <= 0 || number > values.length) continue;
                this.beans.push(values[number - 1]);
                return;
            }
            log.warn((Object)"I didn't understand that");
        }
    }

    private boolean isNumber(String choice) {
        for (int i = 0; i < choice.length(); ++i) {
            if (Character.isDigit(choice.charAt(i))) continue;
            return false;
        }
        return choice.length() > 0;
    }

    private void selectChildDConfigBean(DConfigBean[] cbs) throws IOException {
        if (cbs.length == 1) {
            this.beans.push(cbs[0]);
            return;
        }
        this.out.println("\nAvailable Children:");
        for (int i = 0; i < cbs.length; ++i) {
            this.out.println("  [" + (i + 1) + "] " + cbs[i]);
        }
        while (true) {
            this.out.print("Select child (1-" + cbs.length + "): ");
            this.out.flush();
            String choice = this.in.readLine();
            try {
                int value = Integer.parseInt(choice);
                if (value <= 0 || value > cbs.length) continue;
                this.beans.push(cbs[value - 1]);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    private String printLocation() throws IntrospectionException {
        this.out.println("          ---------- Editing Server-Specific DD ----------          ");
        String here = "";
        int count = 0;
        Iterator iterator = this.beans.iterator();
        while (iterator.hasNext()) {
            ++count;
            Object temp = iterator.next();
            if (!here.equals("")) {
                this.out.print(here);
                this.out.print("+ ");
            }
            if (count == this.beans.size()) {
                this.out.print("[[[ ");
            }
            this.out.print(this.getFullName(temp));
            if (count == this.beans.size()) {
                this.out.print(" ]]]");
            }
            here = here + "  ";
            this.out.println();
        }
        return here;
    }

    private String getFullName(Object bean) throws IntrospectionException {
        String name = bean.toString();
        name = name.length() > 40 || name.indexOf("@") > 0 ? "" : " (" + name + ")";
        return Introspector.getBeanInfo(bean.getClass()).getBeanDescriptor().getDisplayName() + name;
    }

    private PropertyDescriptor[] getNormalProperties(PropertyDescriptor[] descriptors) {
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            if (this.isInvisible(descriptor) || descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null || PropertyEditors.findEditor(descriptor.getPropertyType()) == null) continue;
            list.add(descriptors[i]);
        }
        return list.toArray(new PropertyDescriptor[list.size()]);
    }

    private PropertyDescriptor[] getReadOnly(PropertyDescriptor[] descriptors) {
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            if (this.isInvisible(descriptor) || descriptor.getWriteMethod() != null || descriptor.getReadMethod() == null) continue;
            list.add(descriptors[i]);
        }
        return list.toArray(new PropertyDescriptor[list.size()]);
    }

    private PropertyDescriptor[] getChildProperties(PropertyDescriptor[] descriptors) {
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            if (this.isInvisible(descriptor) || descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null || PropertyEditors.findEditor(descriptor.getPropertyType()) != null) continue;
            list.add(descriptors[i]);
        }
        return list.toArray(new PropertyDescriptor[list.size()]);
    }

    private boolean isInvisible(PropertyDescriptor descriptor) {
        return descriptor.getName().equals("class") || descriptor.getName().equals("DDBean") || descriptor.getName().equals("xpaths");
    }
}

