/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cache;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;
import java.util.LinkedList;
import java.util.List;
import org.apache.geronimo.cache.InstanceFactory;
import org.apache.geronimo.cache.InstancePool;

public final class SimpleInstancePool
implements InstancePool {
    private LinkedList pool;
    private int allocated;
    private Semaphore semaphore;
    private InstanceFactory factory;
    private int maxSize;
    private boolean hardLimit;

    public SimpleInstancePool(InstanceFactory factory, int maxSize, boolean hardLimit) {
        this.factory = factory;
        this.maxSize = maxSize;
        this.hardLimit = hardLimit;
        this.pool = new LinkedList();
        if (hardLimit) {
            this.semaphore = new WaiterPreferenceSemaphore((long)maxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill() throws Exception {
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            while (this.pool != null && this.allocated + this.pool.size() < this.maxSize) {
                Object instance = this.factory.createInstance();
                this.pool.addFirst(instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire() throws Exception {
        if (this.hardLimit) {
            this.semaphore.acquire();
        }
        Object instance = null;
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            ++this.allocated;
            if (this.pool != null && !this.pool.isEmpty()) {
                instance = this.pool.removeFirst();
            }
        }
        if (instance == null) {
            instance = this.factory.createInstance();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Object instance) {
        boolean reinserted = false;
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            if (this.pool != null && this.allocated + this.pool.size() < this.maxSize) {
                this.pool.addFirst(instance);
                reinserted = true;
            }
            --this.allocated;
        }
        if (this.hardLimit) {
            this.semaphore.release();
        }
        return reinserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object instance) {
        instance = null;
        try {
            instance = this.factory.createInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            if (this.pool != null) {
                this.pool.addFirst(instance);
            }
            --this.allocated;
        }
        if (this.hardLimit) {
            this.semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List stopPooling() {
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            LinkedList temp = this.pool;
            this.pool = null;
            return temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPooling() {
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            if (this.pool == null) {
                this.pool = new LinkedList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            return this.allocated + this.pool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllocatedSize() {
        SimpleInstancePool simpleInstancePool = this;
        synchronized (simpleInstancePool) {
            return this.allocated;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isHardLimit() {
        return this.hardLimit;
    }
}

