/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.core.system.serverinfo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ServerConstants {
    private static final String PROPERTIES_FILE = "org/apache/geronimo/console/core/system/serverinfo/geronimo-version.properties";
    private static final String VERSION;
    private static final String BUILD_DATE;
    private static final String BUILD_TIME;
    private static final String COPYRIGHT;
    private static final String GERONIMO_BUILD_VERSION;
    private static final String GERONIMO_SPEC_VERSION;
    private static final String PORTAL_CORE_VERSION;

    public static String getVersion() {
        return VERSION;
    }

    public static String getGeronimoBuildVersion() {
        return GERONIMO_BUILD_VERSION;
    }

    public static String getGeronimoSpecVersion() {
        return GERONIMO_SPEC_VERSION;
    }

    public static String getPortalCoreVersion() {
        return PORTAL_CORE_VERSION;
    }

    public static String getBuildDate() {
        return BUILD_DATE;
    }

    public static String getBuildTime() {
        return BUILD_TIME;
    }

    public static String getCopyright() {
        return COPYRIGHT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Properties versionInfo;
        block14: {
            versionInfo = new Properties();
            InputStream in = ServerConstants.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            if (in == null) {
                throw new ExceptionInInitializerError(new Exception("Unable to locate geronimo-version.properties"));
            }
            try {
                try {
                    versionInfo.load(in);
                }
                catch (IOException e) {
                    throw new ExceptionInInitializerError(new Exception("Could not load geronimo-version.properties", e));
                }
                Object var4_2 = null;
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            in.close();
        }
        if ((VERSION = versionInfo.getProperty("version")) == null) throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'version' property");
        if (VERSION.length() == 0) {
            throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'version' property");
        }
        BUILD_DATE = versionInfo.getProperty("build.date");
        if (BUILD_DATE == null) throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'build.date' property");
        if (BUILD_DATE.length() == 0) {
            throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'build.date' property");
        }
        BUILD_TIME = versionInfo.getProperty("build.time");
        if (BUILD_TIME == null) throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'build.time' property");
        if (BUILD_TIME.length() == 0) {
            throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'build.time' property");
        }
        COPYRIGHT = versionInfo.getProperty("copyright");
        if (COPYRIGHT == null) throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'copyright' property");
        if (COPYRIGHT.length() == 0) {
            throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'copyright' property");
        }
        GERONIMO_BUILD_VERSION = versionInfo.getProperty("geronimo.build.version");
        if (GERONIMO_BUILD_VERSION == null) throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'copyright' property");
        if (COPYRIGHT.length() == 0) {
            throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'copyright' property");
        }
        GERONIMO_SPEC_VERSION = versionInfo.getProperty("geronimo.spec.version");
        if (GERONIMO_SPEC_VERSION == null) throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'copyright' property");
        if (COPYRIGHT.length() == 0) {
            throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'copyright' property");
        }
        PORTAL_CORE_VERSION = versionInfo.getProperty("portal.core.version");
        if (PORTAL_CORE_VERSION == null) throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'copyright' property");
        if (COPYRIGHT.length() != 0) return;
        throw new ExceptionInInitializerError("geronimo-version.properties does not contain a 'copyright' property");
    }
}

