/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.util.ManagementHelper;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.KernelDelegate;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.management.AppClientModule;
import org.apache.geronimo.management.EJB;
import org.apache.geronimo.management.EJBModule;
import org.apache.geronimo.management.J2EEDeployedObject;
import org.apache.geronimo.management.J2EEDomain;
import org.apache.geronimo.management.J2EEModule;
import org.apache.geronimo.management.J2EEResource;
import org.apache.geronimo.management.JCAConnectionFactory;
import org.apache.geronimo.management.JCAManagedConnectionFactory;
import org.apache.geronimo.management.JCAResource;
import org.apache.geronimo.management.JDBCDataSource;
import org.apache.geronimo.management.JDBCDriver;
import org.apache.geronimo.management.JDBCResource;
import org.apache.geronimo.management.JMSResource;
import org.apache.geronimo.management.ResourceAdapter;
import org.apache.geronimo.management.ResourceAdapterModule;
import org.apache.geronimo.management.Servlet;
import org.apache.geronimo.management.WebModule;
import org.apache.geronimo.management.geronimo.EJBConnector;
import org.apache.geronimo.management.geronimo.EJBManager;
import org.apache.geronimo.management.geronimo.J2EEApplication;
import org.apache.geronimo.management.geronimo.J2EEServer;
import org.apache.geronimo.management.geronimo.JMSBroker;
import org.apache.geronimo.management.geronimo.JMSConnector;
import org.apache.geronimo.management.geronimo.JMSManager;
import org.apache.geronimo.management.geronimo.JVM;
import org.apache.geronimo.management.geronimo.WebAccessLog;
import org.apache.geronimo.management.geronimo.WebConnector;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.pool.GeronimoExecutor;
import org.apache.geronimo.system.logging.SystemLog;

public class KernelManagementHelper
implements ManagementHelper {
    private static final Log log = LogFactory.getLog((Class)KernelManagementHelper.class);
    private Kernel kernel;
    private ProxyManager pm;
    static /* synthetic */ Class class$org$apache$geronimo$management$J2EEDomain;

    public KernelManagementHelper(Kernel kernel) {
        this.kernel = kernel;
        this.pm = kernel.getProxyManager();
    }

    public J2EEDomain[] getDomains() {
        String[] names = Util.getObjectNames((Kernel)this.kernel, (Object)"*:", (String[])new String[]{"J2EEDomain"});
        J2EEDomain[] domains = new J2EEDomain[names.length];
        for (int i = 0; i < domains.length; ++i) {
            try {
                domains[i] = (J2EEDomain)this.kernel.getProxyManager().createProxy(ObjectName.getInstance(names[i]), class$org$apache$geronimo$management$J2EEDomain == null ? KernelManagementHelper.class$("org.apache.geronimo.management.J2EEDomain") : class$org$apache$geronimo$management$J2EEDomain);
                continue;
            }
            catch (MalformedObjectNameException e) {
                log.error((Object)"Unable to look up related GBean", (Throwable)e);
            }
        }
        return domains;
    }

    public J2EEServer[] getServers(J2EEDomain domain) {
        J2EEServer[] servers = new J2EEServer[]{};
        try {
            String[] names = domain.getServers();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            servers = new J2EEServer[temp.length];
            System.arraycopy(temp, 0, servers, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return servers;
    }

    public J2EEDeployedObject[] getDeployedObjects(J2EEServer server) {
        J2EEDeployedObject[] result = new J2EEDeployedObject[]{};
        try {
            String[] names = server.getDeployedObjects();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new J2EEDeployedObject[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public J2EEApplication[] getApplications(J2EEServer server) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = server.getDeployedObjects();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("J2EEApplication")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new J2EEApplication[list.size()]);
    }

    public AppClientModule[] getAppClients(J2EEServer server) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = server.getDeployedObjects();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("AppClientModule")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new AppClientModule[list.size()]);
    }

    public WebModule[] getWebModules(J2EEServer server) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = server.getDeployedObjects();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("WebModule")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new WebModule[list.size()]);
    }

    public EJBModule[] getEJBModules(J2EEServer server) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = server.getDeployedObjects();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("EJBModule")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new EJBModule[list.size()]);
    }

    public ResourceAdapterModule[] getRAModules(J2EEServer server) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = server.getDeployedObjects();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("ResourceAdapterModule")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new ResourceAdapterModule[list.size()]);
    }

    public J2EEResource[] getResources(J2EEServer server) {
        J2EEResource[] result = new J2EEResource[]{};
        try {
            String[] names = server.getResources();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new J2EEResource[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public JCAResource[] getJCAResources(J2EEServer server) {
        ArrayList<J2EEResource> list = new ArrayList<J2EEResource>();
        try {
            J2EEResource[] all = this.getResources(server);
            for (int i = 0; i < all.length; ++i) {
                if (!(all[i] instanceof JCAResource)) continue;
                list.add(all[i]);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new JCAResource[list.size()]);
    }

    public JDBCResource[] getJDBCResources(J2EEServer server) {
        return new JDBCResource[0];
    }

    public JMSResource[] getJMSResources(J2EEServer server) {
        return new JMSResource[0];
    }

    public JVM[] getJavaVMs(J2EEServer server) {
        JVM[] result = new JVM[]{};
        try {
            String[] names = server.getJavaVMs();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new JVM[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public WebManager[] getWebManagers(J2EEServer server) {
        WebManager[] result = new WebManager[]{};
        try {
            String[] names = server.getWebManagers();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new WebManager[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public WebAccessLog getWebAccessLog(WebManager manager, WebContainer container) {
        return this.getWebAccessLog(manager, this.kernel.getObjectNameFor((Object)container).getCanonicalName());
    }

    public WebAccessLog getWebAccessLog(WebManager manager, String container) {
        WebAccessLog result = null;
        try {
            log.warn((Object)("Checking access log for " + this.kernel.getObjectNameFor((Object)manager) + " / " + container));
            String name = manager.getAccessLog(container);
            Object temp = this.pm.createProxy(ObjectName.getInstance(name), KernelManagementHelper.class.getClassLoader());
            result = (WebAccessLog)temp;
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public WebContainer[] getWebContainers(WebManager manager) {
        WebContainer[] result = new WebContainer[]{};
        try {
            String[] names = manager.getContainers();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new WebContainer[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public WebConnector[] getWebConnectorsForContainer(WebManager manager, WebContainer container, String protocol) {
        return this.getWebConnectorsForContainer(manager, this.kernel.getObjectNameFor((Object)container).getCanonicalName(), protocol);
    }

    public WebConnector[] getWebConnectorsForContainer(WebManager manager, WebContainer container) {
        return this.getWebConnectorsForContainer(manager, this.kernel.getObjectNameFor((Object)container).getCanonicalName());
    }

    public WebConnector[] getWebConnectorsForContainer(WebManager manager, String containerObjectName, String protocol) {
        WebConnector[] result = new WebConnector[]{};
        try {
            String[] names = manager.getConnectorsForContainer(containerObjectName, protocol);
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new WebConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public WebConnector[] getWebConnectorsForContainer(WebManager manager, String containerObjectName) {
        WebConnector[] result = new WebConnector[]{};
        try {
            String[] names = manager.getConnectorsForContainer(containerObjectName);
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new WebConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public WebConnector[] getWebConnectors(WebManager manager, String protocol) {
        WebConnector[] result = new WebConnector[]{};
        try {
            String[] names = manager.getConnectors(protocol);
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new WebConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public WebConnector[] getWebConnectors(WebManager manager) {
        WebConnector[] result = new WebConnector[]{};
        try {
            String[] names = manager.getConnectors();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new WebConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public EJBManager[] getEJBManagers(J2EEServer server) {
        EJBManager[] result = null;
        try {
            String[] names = server.getEJBManagers();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new EJBManager[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public EJBConnector[] getEJBConnectors(EJBManager container, String protocol) {
        EJBConnector[] result = new EJBConnector[]{};
        try {
            String[] names = container.getConnectors(protocol);
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new EJBConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public EJBConnector[] getEJBConnectors(EJBManager container) {
        EJBConnector[] result = new EJBConnector[]{};
        try {
            String[] names = container.getConnectors();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new EJBConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public JMSManager[] getJMSManagers(J2EEServer server) {
        JMSManager[] result = null;
        try {
            String[] names = server.getJMSManagers();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new JMSManager[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public JMSBroker[] getJMSBrokers(JMSManager manager) {
        JMSBroker[] result = null;
        try {
            String[] names = manager.getContainers();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new JMSBroker[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public JMSConnector[] getJMSConnectors(JMSManager manager, String protocol) {
        JMSConnector[] result = null;
        try {
            String[] names = manager.getConnectors(protocol);
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new JMSConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public JMSConnector[] getJMSConnectors(JMSManager manager) {
        JMSConnector[] result = null;
        try {
            String[] names = manager.getConnectors();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new JMSConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public JMSConnector[] getJMSConnectorsForContainer(JMSManager manager, JMSBroker broker, String protocol) {
        return this.getJMSConnectorsForContainer(manager, this.kernel.getObjectNameFor((Object)broker).getCanonicalName(), protocol);
    }

    public JMSConnector[] getJMSConnectorsForContainer(JMSManager manager, JMSBroker broker) {
        return this.getJMSConnectorsForContainer(manager, this.kernel.getObjectNameFor((Object)broker).getCanonicalName());
    }

    public JMSConnector[] getJMSConnectorsForContainer(JMSManager manager, String brokerObjectName, String protocol) {
        JMSConnector[] result = null;
        try {
            String[] names = manager.getConnectorsForContainer(brokerObjectName, protocol);
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new JMSConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public JMSConnector[] getJMSConnectorsForContainer(JMSManager manager, String brokerObjectName) {
        JMSConnector[] result = null;
        try {
            String[] names = manager.getConnectorsForContainer(brokerObjectName);
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new JMSConnector[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public GeronimoExecutor[] getThreadPools(J2EEServer server) {
        GeronimoExecutor[] result = new GeronimoExecutor[]{};
        try {
            String[] names = server.getThreadPools();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new GeronimoExecutor[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public SystemLog getSystemLog(JVM jvm) {
        SystemLog result = null;
        try {
            String name = jvm.getSystemLog();
            Object temp = this.pm.createProxy(ObjectName.getInstance(name), KernelManagementHelper.class.getClassLoader());
            result = (SystemLog)temp;
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public J2EEModule[] getModules(J2EEApplication application) {
        J2EEModule[] result = new J2EEModule[]{};
        try {
            String[] names = application.getModules();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new J2EEModule[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public AppClientModule[] getAppClients(J2EEApplication application) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = application.getModules();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("AppClientModule")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new AppClientModule[list.size()]);
    }

    public WebModule[] getWebModules(J2EEApplication application) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = application.getModules();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("WebModule")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new WebModule[list.size()]);
    }

    public EJBModule[] getEJBModules(J2EEApplication application) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = application.getModules();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("EJBModule")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new EJBModule[list.size()]);
    }

    public ResourceAdapterModule[] getRAModules(J2EEApplication application) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            String[] names = application.getModules();
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = ObjectName.getInstance(names[i]);
                String type = name.getKeyProperty("j2eeType");
                if (!type.equals("ResourceAdapterModule")) continue;
                list.add(this.pm.createProxy(name, (class$org$apache$geronimo$console$util$KernelManagementHelper == null ? KernelManagementHelper.class$("org.apache.geronimo.console.util.KernelManagementHelper") : class$org$apache$geronimo$console$util$KernelManagementHelper).getClassLoader()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new ResourceAdapterModule[list.size()]);
    }

    public J2EEResource[] getResources(J2EEApplication application) {
        J2EEResource[] result = new J2EEResource[]{};
        try {
            String[] names = application.getResources();
            Object[] temp = this.pm.createProxies(names, KernelManagementHelper.class.getClassLoader());
            result = new J2EEResource[temp.length];
            System.arraycopy(temp, 0, result, 0, temp.length);
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return result;
    }

    public JCAResource[] getJCAResources(J2EEApplication application) {
        ArrayList<J2EEResource> list = new ArrayList<J2EEResource>();
        try {
            J2EEResource[] all = this.getResources(application);
            for (int i = 0; i < all.length; ++i) {
                if (!(all[i] instanceof JCAResource)) continue;
                list.add(all[i]);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
        }
        return list.toArray(new JCAResource[list.size()]);
    }

    public JDBCResource[] getJDBCResources(J2EEApplication application) {
        return new JDBCResource[0];
    }

    public JMSResource[] getJMSResources(J2EEApplication application) {
        return new JMSResource[0];
    }

    public EJB[] getEJBs(EJBModule module) {
        return new EJB[0];
    }

    public Servlet[] getServlets(WebModule module) {
        return new Servlet[0];
    }

    public ResourceAdapter getResourceAdapters(ResourceAdapterModule module) {
        return null;
    }

    public JCAResource[] getRAResources(ResourceAdapter adapter) {
        return new JCAResource[0];
    }

    public JDBCDataSource[] getDataSource(JDBCResource resource) {
        return new JDBCDataSource[0];
    }

    public JDBCDriver[] getDriver(JDBCDataSource dataSource) {
        return new JDBCDriver[0];
    }

    public JCAConnectionFactory[] getConnectionFactories(JCAResource resource) {
        return new JCAConnectionFactory[0];
    }

    public JCAManagedConnectionFactory getManagedConnectionFactory(JCAConnectionFactory factory) {
        return null;
    }

    public Object getObject(String objectName) {
        try {
            return this.kernel.getProxyManager().createProxy(ObjectName.getInstance(objectName), KernelManagementHelper.class.getClassLoader());
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"Unable to look up related GBean", (Throwable)e);
            return null;
        }
    }

    public String getGBeanDescription(String objectName) {
        try {
            return this.kernel.getGBeanInfo(ObjectName.getInstance(objectName)).getName();
        }
        catch (GBeanNotFoundException e) {
            return null;
        }
        catch (MalformedObjectNameException e) {
            return "Invalid object name";
        }
    }

    public static KernelManagementHelper getRemoteKernelManager(String host, String user, String password) throws IOException {
        String uri = "jmx:rmi://" + host + "/jndi/rmi:/JMXConnector";
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        String[] credentials = new String[]{user, password};
        environment.put("jmx.remote.credentials", credentials);
        JMXServiceURL address = new JMXServiceURL("service:" + uri);
        JMXConnector jmxConnector = JMXConnectorFactory.connect(address, environment);
        MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
        KernelDelegate kernel = new KernelDelegate(mbServerConnection);
        return new KernelManagementHelper((Kernel)kernel);
    }

    public static void main(String[] args) {
        try {
            KernelManagementHelper mgr = KernelManagementHelper.getRemoteKernelManager("localhost", "system", "manager");
            J2EEDomain domain = mgr.getDomains()[0];
            System.out.println("Found domain " + domain.getObjectName() + " with " + domain.getServers().length + " servers");
            J2EEServer server = mgr.getServers(domain)[0];
            System.out.println("Found server " + server.getObjectName() + " with " + server.getDeployedObjects().length + " deployments");
            System.out.println("  " + mgr.getApplications(server).length + " applications");
            System.out.println("  " + mgr.getAppClients(server).length + " app clients");
            System.out.println("  " + mgr.getEJBModules(server).length + " EJB JARs");
            System.out.println("  " + mgr.getWebModules(server).length + " web apps");
            System.out.println("  " + mgr.getRAModules(server).length + " RA modules");
            J2EEDeployedObject[] deployments = mgr.getDeployedObjects(server);
            for (int i = 0; i < deployments.length; ++i) {
                J2EEDeployedObject deployment = deployments[i];
                System.out.println("Deployment " + i + ": " + deployment.getObjectName());
            }
            J2EEApplication[] applications = mgr.getApplications(server);
            for (int i = 0; i < applications.length; ++i) {
                J2EEApplication app = applications[i];
                System.out.println("Application " + i + ": " + app.getObjectName());
                J2EEModule[] modules = mgr.getModules(app);
                for (int j = 0; j < modules.length; ++j) {
                    J2EEModule deployment = modules[j];
                    System.out.println("  Module " + j + ": " + deployment.getObjectName());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

