/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.core.jms;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.AdminObjectWrapper;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;

public class TopicBrowserGBean
implements GBeanLifecycle,
Runnable {
    private static Log log = LogFactory.getLog((Class)TopicBrowserGBean.class);
    private static Kernel kernel = KernelRegistry.getSingleKernel();
    private static ObjectName ACTIVEMQ_CONTAINER_OBJNAME;
    private static ObjectName ACTIVEMQ_CONNECTOR_OBJNAME;
    String subscriberName;
    TopicConnectionFactory tConFactory;
    TopicConnection tConnection;
    AdminObjectWrapper connectionFactoryWrapper;
    AdminObjectWrapper topicWrapper;
    TopicSession tSession;
    TopicSubscriber tSubscriber;
    Topic topic;
    Thread t;
    boolean stop;
    public static final GBeanInfo GBEAN_INFO;

    public void run() {
        try {
            this.tConFactory = (TopicConnectionFactory)this.connectionFactoryWrapper.$getResource();
            this.topic = (Topic)this.topicWrapper.$getResource();
            this.tConnection = this.tConFactory.createTopicConnection();
            this.tConnection.setClientID(this.subscriberName);
            this.tSession = this.tConnection.createTopicSession(false, 1);
            this.tSubscriber = this.tSession.createDurableSubscriber(this.topic, this.subscriberName);
            this.tConnection.start();
            while (!this.stop) {
                Thread.yield();
            }
            if (this.tSession != null) {
                this.tSession.close();
            }
            if (this.tConnection != null && (Integer)kernel.getAttribute(ACTIVEMQ_CONTAINER_OBJNAME, "state") == 1 && (Integer)kernel.getAttribute(ACTIVEMQ_CONNECTOR_OBJNAME, "state") == 1) {
                this.tConnection.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.t = null;
        log.debug((Object)"Worker thread stopped.");
    }

    public TopicBrowserGBean(String subscriberName, AdminObjectWrapper connectionFactoryWrapper, AdminObjectWrapper topicWrapper) {
        this.subscriberName = subscriberName + "@" + this.getClass().getName();
        this.connectionFactoryWrapper = connectionFactoryWrapper;
        this.topicWrapper = topicWrapper;
    }

    public void doStart() throws WaitingException, Exception {
        this.t = new Thread(this);
        this.t.start();
        log.info((Object)"Subscribed to topic.");
    }

    public void doStop() throws WaitingException, Exception {
        this.stop = true;
        log.info((Object)"Unsubscribed to topic.");
    }

    public void doFail() {
        this.stop = true;
        log.warn((Object)"GBean failed.");
    }

    public List getMessages() throws Exception {
        ArrayList<Message> ret = new ArrayList<Message>();
        Message m = null;
        do {
            if ((m = this.tSubscriber.receiveNoWait()) == null) continue;
            ret.add(m);
        } while (m != null);
        return ret;
    }

    public void unsubscribe() throws Exception {
        if (this.tSubscriber != null) {
            this.tSubscriber.close();
            if (this.tSession != null) {
                this.tSession.unsubscribe(this.subscriberName);
                log.info((Object)(this.subscriberName + " unsubscribed from Topic " + this.topic.getTopicName() + "."));
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        try {
            ACTIVEMQ_CONTAINER_OBJNAME = ObjectName.getInstance("geronimo.server:J2EEApplication=null,J2EEModule=org/apache/geronimo/ActiveMQServer,J2EEServer=geronimo,j2eeType=JMSServer,name=ActiveMQl");
            ACTIVEMQ_CONNECTOR_OBJNAME = ObjectName.getInstance("geronimo.server:J2EEApplication=null,J2EEServer=geronimo,JCAResource=org/apache/geronimo/SystemJMS,j2eeType=JCAManagedConnectionFactory,name=DefaultActiveMQConnectionFactory");
        }
        catch (MalformedObjectNameException moe) {
            log.warn((Object)"Could not initialize ObjectName", (Throwable)moe);
        }
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("Topic Browser GBean", TopicBrowserGBean.class);
        infoFactory.addAttribute("subscriberName", String.class, true);
        infoFactory.addReference("ConnectionFactoryWrapper", AdminObjectWrapper.class);
        infoFactory.addReference("TopicWrapper", AdminObjectWrapper.class);
        infoFactory.addOperation("getMessages");
        infoFactory.addOperation("unsubscribe");
        infoFactory.setConstructor(new String[]{"subscriberName", "ConnectionFactoryWrapper", "TopicWrapper"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

