/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.connector.ActivationSpecInfo;
import org.apache.geronimo.connector.ResourceAdapterModuleImpl;
import org.apache.geronimo.connector.deployment.RARGBeanAdapter;
import org.apache.geronimo.connector.outbound.JCAConnectionFactoryImpl;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionLog;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.outbound.security.PasswordCredentialRealm;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.deployment.service.GBeanAdapter;
import org.apache.geronimo.deployment.service.GBeanHelper;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.DynamicGAttributeInfo;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.reference.GBeanGetResourceRefAddr;
import org.apache.geronimo.naming.reference.RefAddrContentObjectFactory;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.GerAdminobjectInstanceType;
import org.apache.geronimo.xbeans.geronimo.GerAdminobjectType;
import org.apache.geronimo.xbeans.geronimo.GerConfigPropertySettingType;
import org.apache.geronimo.xbeans.geronimo.GerConnectionDefinitionType;
import org.apache.geronimo.xbeans.geronimo.GerConnectiondefinitionInstanceType;
import org.apache.geronimo.xbeans.geronimo.GerConnectionmanagerType;
import org.apache.geronimo.xbeans.geronimo.GerConnectorDocument;
import org.apache.geronimo.xbeans.geronimo.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.GerDependencyType;
import org.apache.geronimo.xbeans.geronimo.GerGbeanType;
import org.apache.geronimo.xbeans.geronimo.GerResourceadapterType;
import org.apache.geronimo.xbeans.geronimo.GerSinglepoolType;
import org.apache.geronimo.xbeans.j2ee.ActivationspecType;
import org.apache.geronimo.xbeans.j2ee.AdminobjectType;
import org.apache.geronimo.xbeans.j2ee.ConfigPropertyType;
import org.apache.geronimo.xbeans.j2ee.ConnectionDefinitionType;
import org.apache.geronimo.xbeans.j2ee.ConnectorDocument;
import org.apache.geronimo.xbeans.j2ee.ConnectorType;
import org.apache.geronimo.xbeans.j2ee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.j2ee.MessagelistenerType;
import org.apache.geronimo.xbeans.j2ee.ResourceadapterType;
import org.apache.geronimo.xbeans.j2ee.connector_1_0.ConfigPropertyType10;
import org.apache.geronimo.xbeans.j2ee.connector_1_0.ConnectorDocument10;
import org.apache.geronimo.xbeans.j2ee.connector_1_0.ConnectorType10;
import org.apache.geronimo.xbeans.j2ee.connector_1_0.ResourceadapterType10;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class ConnectorModuleBuilder
implements ModuleBuilder,
ResourceReferenceBuilder {
    private static final String BASE_REALM_BRIDGE_NAME = "geronimo.security:service=RealmBridge,name=";
    private static final String BASE_PASSWORD_CREDENTIAL_LOGIN_MODULE_NAME = "geronimo.security:service=Realm,type=PasswordCredential,name=";
    private final int defaultMaxSize;
    private final int defaultMinSize;
    private final int defaultBlockingTimeoutMilliseconds;
    private final int defaultIdleTimeoutMinutes;
    private final boolean defaultXATransactionCaching;
    private final boolean defaultXAThreadCaching;
    private final Kernel kernel;
    private final URI defaultParentId;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConnectorModuleBuilder(URI defaultParentId, int defaultMaxSize, int defaultMinSize, int defaultBlockingTimeoutMilliseconds, int defaultIdleTimeoutMinutes, boolean defaultXATransactionCaching, boolean defaultXAThreadCaching, Kernel kernel) {
        this.defaultParentId = defaultParentId;
        this.defaultMaxSize = defaultMaxSize;
        this.defaultMinSize = defaultMinSize;
        this.defaultBlockingTimeoutMilliseconds = defaultBlockingTimeoutMilliseconds;
        this.defaultIdleTimeoutMinutes = defaultIdleTimeoutMinutes;
        this.defaultXATransactionCaching = defaultXATransactionCaching;
        this.defaultXAThreadCaching = defaultXAThreadCaching;
        this.kernel = kernel;
    }

    public Module createModule(File plan, JarFile moduleFile) throws DeploymentException {
        return this.createModule((Object)plan, moduleFile, "rar", null, true);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, URI earConfigId) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, false);
    }

    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, boolean standAlone) throws DeploymentException {
        ConnectorType10 connector;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/ra.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
            try {
                ConnectorDocument10 connectorDoc = ConnectorDocument10.Factory.parse((String)specDD);
                SchemaConversionUtils.validateDD((XmlObject)connectorDoc);
                connector = connectorDoc.getConnector();
            }
            catch (Exception ignore) {
                ConnectorDocument connectorDoc = ConnectorDocument.Factory.parse((String)specDD);
                SchemaConversionUtils.validateDD((XmlObject)connectorDoc);
                connector = connectorDoc.getConnector();
            }
        }
        catch (Exception e) {
            return null;
        }
        GerConnectorType gerConnector = null;
        try {
            try {
                if (plan instanceof XmlObject) {
                    gerConnector = (GerConnectorType)SchemaConversionUtils.getNestedObjectAsType((XmlObject)((XmlObject)plan), (String)"connector", (SchemaType)GerConnectorType.type);
                } else {
                    GerConnectorDocument gerConnectorDoc = null;
                    if (plan != null) {
                        gerConnectorDoc = GerConnectorDocument.Factory.parse((File)plan);
                    } else {
                        URL path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/geronimo-ra.xml");
                        gerConnectorDoc = GerConnectorDocument.Factory.parse(path);
                    }
                    if (gerConnectorDoc != null) {
                        gerConnector = gerConnectorDoc.getConnector();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (gerConnector == null) {
                throw new DeploymentException("A connector module must be deployed using a plan");
            }
            SchemaConversionUtils.validateDD(gerConnector);
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        URI configId = null;
        try {
            configId = new URI(gerConnector.getConfigId());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid configId " + gerConnector.getConfigId(), (Throwable)e);
        }
        URI parentId = null;
        if (gerConnector.isSetParentId()) {
            try {
                parentId = new URI(gerConnector.getParentId());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid parentId " + gerConnector.getParentId(), (Throwable)e);
            }
        } else {
            parentId = this.defaultParentId;
        }
        return new ConnectorModule(standAlone, configId, parentId, moduleFile, targetPath, (XmlObject)connector, (XmlObject)gerConnector, specDD);
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module) throws DeploymentException {
        try {
            JarFile moduleFile = module.getModuleFile();
            earContext.addManifestClassPath(moduleFile, URI.create(module.getTargetPath()));
            URI targetURI = URI.create(module.getTargetPath() + "/");
            Enumeration<JarEntry> entries = moduleFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI target = targetURI.resolve(entry.getName());
                if (entry.getName().endsWith(".jar")) {
                    earContext.addInclude(target, (ZipFile)moduleFile, entry);
                    continue;
                }
                earContext.addFile(target, (ZipFile)moduleFile, entry);
            }
            GerConnectorType vendorConnector = (GerConnectorType)module.getVendorDD();
            GerDependencyType[] dependencies = vendorConnector.getDependencyArray();
            for (int i = 0; i < dependencies.length; ++i) {
                earContext.addDependency(ConnectorModuleBuilder.getDependencyURI(dependencies[i]));
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Problem deploying connector", (Throwable)e);
        }
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        J2eeContext earJ2eeContext = earContext.getJ2eeContext();
        J2eeContextImpl moduleJ2eeContext = new J2eeContextImpl(earJ2eeContext.getJ2eeDomainName(), earJ2eeContext.getJ2eeServerName(), earJ2eeContext.getJ2eeApplicationName(), module.getName(), null, null);
        XmlObject specDD = module.getSpecDD();
        GerConnectorType geronimoConnector = (GerConnectorType)module.getVendorDD();
        GerResourceadapterType[] geronimoResourceAdapters = geronimoConnector.getResourceadapterArray();
        for (int k = 0; k < geronimoResourceAdapters.length; ++k) {
            ResourceadapterType resourceadapter;
            GerResourceadapterType geronimoResourceAdapter = geronimoResourceAdapters[k];
            if (specDD instanceof ConnectorType && (resourceadapter = ((ConnectorType)specDD).getResourceadapter()).isSetResourceadapterClass()) {
                try {
                    if (resourceadapter.isSetInboundResourceadapter() && resourceadapter.getInboundResourceadapter().isSetMessageadapter()) {
                        String resourceAdapterName = geronimoResourceAdapter.getResourceadapterInstance().getResourceadapterName();
                        ObjectName resourceAdapterObjectName = NameFactory.getResourceComponentName(null, null, null, null, (String)resourceAdapterName, (String)"JCAResourceAdapter", (J2eeContext)moduleJ2eeContext);
                        Map activationSpecInfoMap = this.getActivationSpecInfoMap(resourceadapter.getInboundResourceadapter().getMessageadapter().getMessagelistenerArray(), cl);
                        String containerId = resourceAdapterObjectName.getCanonicalName();
                        earContext.getRefContext().addResourceAdapterId(module.getModuleURI(), resourceAdapterName, containerId);
                        earContext.getRefContext().addActivationSpecInfos(resourceAdapterObjectName, activationSpecInfoMap);
                    }
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not set ResourceAdapterClass", (Throwable)e);
                }
            }
            if (!geronimoResourceAdapter.isSetOutboundResourceadapter()) continue;
            GerConnectionDefinitionType[] connectionDefinitions = geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray();
            for (int i = 0; i < connectionDefinitions.length; ++i) {
                GerConnectionDefinitionType connectionDefinition = connectionDefinitions[i];
                GerConnectiondefinitionInstanceType[] connectionDefinitionInstances = connectionDefinition.getConnectiondefinitionInstanceArray();
                for (int j = 0; j < connectionDefinitionInstances.length; ++j) {
                    GerConnectiondefinitionInstanceType connectionDefinitionInstance = connectionDefinitionInstances[j];
                    String containerId = null;
                    try {
                        containerId = NameFactory.getResourceComponentNameString(null, null, null, null, (String)connectionDefinitionInstance.getName(), (String)NameFactory.JCA_MANAGED_CONNECTION_FACTORY, (J2eeContext)moduleJ2eeContext);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("Could not construct resource object name", (Throwable)e);
                    }
                    earContext.getRefContext().addConnectionFactoryId(module.getModuleURI(), connectionDefinitionInstance.getName(), containerId);
                }
            }
        }
        for (int i = 0; i < geronimoConnector.getAdminobjectArray().length; ++i) {
            GerAdminobjectType gerAdminObject = geronimoConnector.getAdminobjectArray()[i];
            for (int j = 0; j < gerAdminObject.getAdminobjectInstanceArray().length; ++j) {
                GerAdminobjectInstanceType gerAdminObjectInstance = gerAdminObject.getAdminobjectInstanceArray()[j];
                String adminObjectObjectName = null;
                try {
                    adminObjectObjectName = NameFactory.getResourceComponentNameString(null, null, null, null, (String)gerAdminObjectInstance.getMessageDestinationName(), (String)"JCAAdminObject", (J2eeContext)moduleJ2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct resource object name", (Throwable)e);
                }
                earContext.getRefContext().addAdminObjectId(module.getModuleURI(), gerAdminObjectInstance.getMessageDestinationName(), adminObjectObjectName);
            }
        }
    }

    public String addGBeans(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        J2eeContext earJ2eeContext = earContext.getJ2eeContext();
        J2eeContextImpl moduleJ2eeContext = new J2eeContextImpl(earJ2eeContext.getJ2eeDomainName(), earJ2eeContext.getJ2eeServerName(), earJ2eeContext.getJ2eeApplicationName(), module.getName(), null, null);
        this.addResourceAdapterModuleGBean(earContext, (J2eeContext)moduleJ2eeContext, module.getOriginalSpecDD(), cl);
        GerConnectorType geronimoConnector = (GerConnectorType)module.getVendorDD();
        GerGbeanType[] gbeans = geronimoConnector.getGbeanArray();
        for (int i = 0; i < gbeans.length; ++i) {
            GBeanHelper.addGbean((GBeanAdapter)new RARGBeanAdapter(gbeans[i]), (ClassLoader)cl, (DeploymentContext)earContext);
        }
        XmlObject specDD = module.getSpecDD();
        if (specDD instanceof ConnectorType10) {
            this.addConnectorGBeans(earContext, (J2eeContext)moduleJ2eeContext, (ConnectorType10)specDD, geronimoConnector, cl);
        } else {
            this.addConnectorGBeans(earContext, (J2eeContext)moduleJ2eeContext, (ConnectorType)specDD, geronimoConnector, cl);
        }
        return null;
    }

    private ObjectName addResourceAdapterModuleGBean(EARContext earContext, J2eeContext moduleJ2eeContext, String originalSpecDD, ClassLoader cl) throws DeploymentException {
        ObjectName resourceAdapterModuleName = null;
        try {
            resourceAdapterModuleName = NameFactory.getModuleName(null, null, null, null, (String)NameFactory.RESOURCE_ADAPTER_MODULE, (J2eeContext)moduleJ2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct module name", (Throwable)e);
        }
        GBeanMBean resourceAdapterModule = new GBeanMBean(ResourceAdapterModuleImpl.GBEAN_INFO, cl);
        resourceAdapterModule.setReferencePattern(NameFactory.J2EE_SERVER, earContext.getServerObjectName());
        if (!earContext.getJ2EEApplicationName().equals(NameFactory.NULL)) {
            resourceAdapterModule.setReferencePattern(NameFactory.J2EE_APPLICATION, earContext.getApplicationObjectName());
        }
        try {
            resourceAdapterModule.setAttribute("deploymentDescriptor", (Object)originalSpecDD);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize EJBModule GBean", (Throwable)e);
        }
        earContext.addGBean(resourceAdapterModuleName, resourceAdapterModule);
        return resourceAdapterModuleName;
    }

    private void addConnectorGBeans(EARContext earContext, J2eeContext j2eeContext, ConnectorType10 connector, GerConnectorType geronimoConnector, ClassLoader cl) throws DeploymentException {
        ResourceadapterType10 resourceAdapter = connector.getResourceadapter();
        String managedConnectionFactoryClass = resourceAdapter.getManagedconnectionfactoryClass().getStringValue().trim();
        String connectionFactoryInterface = resourceAdapter.getConnectionfactoryInterface().getStringValue().trim();
        String connectionFactoryImplClass = resourceAdapter.getConnectionfactoryImplClass().getStringValue().trim();
        String connectionInterface = resourceAdapter.getConnectionInterface().getStringValue().trim();
        String connectionImplClass = resourceAdapter.getConnectionImplClass().getStringValue().trim();
        String transactionSupport = resourceAdapter.getTransactionSupport().getStringValue().trim();
        GerResourceadapterType[] geronimoResourceAdapters = geronimoConnector.getResourceadapterArray();
        for (int k = 0; k < geronimoResourceAdapters.length; ++k) {
            GerResourceadapterType geronimoResourceAdapter = geronimoResourceAdapters[k];
            for (int i = 0; i < geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray().length; ++i) {
                GerConnectionDefinitionType geronimoConnectionDefinition = geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray(i);
                if (!$assertionsDisabled && geronimoConnectionDefinition == null) {
                    throw new AssertionError((Object)"Null GeronimoConnectionDefinition");
                }
                for (int j = 0; j < geronimoConnectionDefinition.getConnectiondefinitionInstanceArray().length; ++j) {
                    GerConnectiondefinitionInstanceType connectionfactoryInstance = geronimoConnectionDefinition.getConnectiondefinitionInstanceArray()[j];
                    ConfigProperty[] configProperties = this.getConfigProperties(resourceAdapter.getConfigPropertyArray(), connectionfactoryInstance.getConfigPropertySettingArray());
                    this.addOutboundGBeans(earContext, j2eeContext, null, connectionfactoryInstance, configProperties, managedConnectionFactoryClass, connectionFactoryInterface, connectionFactoryImplClass, connectionInterface, connectionImplClass, transactionSupport, cl);
                }
            }
        }
    }

    private void addConnectorGBeans(EARContext earContext, J2eeContext moduleJ2eeContext, ConnectorType connector, GerConnectorType geronimoConnector, ClassLoader cl) throws DeploymentException {
        int i;
        ResourceadapterType resourceadapter = connector.getResourceadapter();
        String transactionSupport = resourceadapter.getOutboundResourceadapter().getTransactionSupport().getStringValue().trim();
        GerResourceadapterType[] geronimoResourceAdapters = geronimoConnector.getResourceadapterArray();
        for (int k = 0; k < geronimoResourceAdapters.length; ++k) {
            GerResourceadapterType geronimoResourceAdapter = geronimoResourceAdapters[k];
            ObjectName resourceAdapterObjectName = null;
            if (resourceadapter.isSetResourceadapterClass()) {
                String resourceAdapterName = geronimoResourceAdapter.getResourceadapterInstance().getResourceadapterName();
                GBeanInfoBuilder resourceAdapterInfoFactory = new GBeanInfoBuilder("org.apache.geronimo.connector.ResourceAdapterWrapper", cl);
                ConfigProperty[] configProperties = this.getConfigProperties(resourceadapter.getConfigPropertyArray(), geronimoResourceAdapter.getResourceadapterInstance().getConfigPropertySettingArray());
                GBeanMBean resourceAdapterGBean = this.setUpDynamicGBean(resourceAdapterInfoFactory, configProperties, cl);
                try {
                    resourceAdapterGBean.setAttribute("resourceAdapterClass", cl.loadClass(resourceadapter.getResourceadapterClass().getStringValue()));
                    if (resourceadapter.isSetInboundResourceadapter() && resourceadapter.getInboundResourceadapter().isSetMessageadapter()) {
                        Map activationSpecInfoMap = this.getActivationSpecInfoMap(resourceadapter.getInboundResourceadapter().getMessageadapter().getMessagelistenerArray(), cl);
                        resourceAdapterGBean.setAttribute("activationSpecInfoMap", (Object)activationSpecInfoMap);
                    }
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not set ResourceAdapterClass", (Throwable)e);
                }
                ObjectName workManagerName = null;
                try {
                    workManagerName = NameFactory.getComponentName(null, null, (String)geronimoResourceAdapter.getResourceadapterInstance().getWorkmanagerName().trim(), (String)"JCAWorkManager", (J2eeContext)moduleJ2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct work manager object name", (Throwable)e);
                }
                resourceAdapterGBean.setReferencePattern("WorkManager", workManagerName);
                try {
                    resourceAdapterObjectName = NameFactory.getResourceComponentName(null, null, null, null, (String)resourceAdapterName, (String)"JCAResourceAdapter", (J2eeContext)moduleJ2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct resource adapter object name", (Throwable)e);
                }
                earContext.addGBean(resourceAdapterObjectName, resourceAdapterGBean);
            }
            HashMap<String, ConnectionDefinitionType> connectionDefinitions = new HashMap<String, ConnectionDefinitionType>();
            if (!resourceadapter.isSetOutboundResourceadapter()) continue;
            for (int j = 0; j < resourceadapter.getOutboundResourceadapter().getConnectionDefinitionArray().length; ++j) {
                ConnectionDefinitionType connectionDefinition = resourceadapter.getOutboundResourceadapter().getConnectionDefinitionArray(j);
                connectionDefinitions.put(connectionDefinition.getConnectionfactoryInterface().getStringValue(), connectionDefinition);
            }
            if (!geronimoResourceAdapter.isSetOutboundResourceadapter()) continue;
            for (int i2 = 0; i2 < geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray().length; ++i2) {
                GerConnectionDefinitionType geronimoConnectionDefinition = geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray(i2);
                if (!$assertionsDisabled && geronimoConnectionDefinition == null) {
                    throw new AssertionError((Object)"Null GeronimoConnectionDefinition");
                }
                String connectionFactoryInterfaceName = geronimoConnectionDefinition.getConnectionfactoryInterface().getStringValue();
                ConnectionDefinitionType connectionDefinition = (ConnectionDefinitionType)connectionDefinitions.get(connectionFactoryInterfaceName);
                if (connectionDefinition == null) {
                    throw new DeploymentException("No connection definition for ConnectionFactory class: " + connectionFactoryInterfaceName);
                }
                String managedConnectionFactoryClass = connectionDefinition.getManagedconnectionfactoryClass().getStringValue().trim();
                String connectionFactoryInterface = connectionDefinition.getConnectionfactoryInterface().getStringValue().trim();
                String connectionFactoryImplClass = connectionDefinition.getConnectionfactoryImplClass().getStringValue().trim();
                String connectionInterface = connectionDefinition.getConnectionInterface().getStringValue().trim();
                String connectionImplClass = connectionDefinition.getConnectionImplClass().getStringValue().trim();
                for (int j = 0; j < geronimoConnectionDefinition.getConnectiondefinitionInstanceArray().length; ++j) {
                    GerConnectiondefinitionInstanceType connectionfactoryInstance = geronimoConnectionDefinition.getConnectiondefinitionInstanceArray()[j];
                    ConfigProperty[] configProperties = this.getConfigProperties(connectionDefinition.getConfigPropertyArray(), connectionfactoryInstance.getConfigPropertySettingArray());
                    this.addOutboundGBeans(earContext, moduleJ2eeContext, resourceAdapterObjectName, connectionfactoryInstance, configProperties, managedConnectionFactoryClass, connectionFactoryInterface, connectionFactoryImplClass, connectionInterface, connectionImplClass, transactionSupport, cl);
                }
            }
        }
        HashMap<String, AdminobjectType> adminObjectInterfaceMap = new HashMap<String, AdminobjectType>();
        for (i = 0; i < resourceadapter.getAdminobjectArray().length; ++i) {
            AdminobjectType adminobject = resourceadapter.getAdminobjectArray()[i];
            adminObjectInterfaceMap.put(adminobject.getAdminobjectInterface().getStringValue(), adminobject);
        }
        for (i = 0; i < geronimoConnector.getAdminobjectArray().length; ++i) {
            GerAdminobjectType gerAdminObject = geronimoConnector.getAdminobjectArray()[i];
            String adminObjectInterface = gerAdminObject.getAdminobjectInterface().getStringValue();
            AdminobjectType adminObject = (AdminobjectType)adminObjectInterfaceMap.get(adminObjectInterface);
            if (adminObject == null) {
                throw new DeploymentException("No admin object declared for interface: " + adminObjectInterface);
            }
            for (int j = 0; j < gerAdminObject.getAdminobjectInstanceArray().length; ++j) {
                GerAdminobjectInstanceType gerAdminObjectInstance = gerAdminObject.getAdminobjectInstanceArray()[j];
                GBeanInfoBuilder adminObjectInfoFactory = new GBeanInfoBuilder("org.apache.geronimo.connector.AdminObjectWrapper", cl);
                ConfigProperty[] configProperties = this.getConfigProperties(adminObject.getConfigPropertyArray(), gerAdminObjectInstance.getConfigPropertySettingArray());
                GBeanMBean adminObjectGBean = this.setUpDynamicGBean(adminObjectInfoFactory, configProperties, cl);
                try {
                    adminObjectGBean.setAttribute("adminObjectInterface", cl.loadClass(adminObjectInterface));
                    adminObjectGBean.setAttribute("adminObjectClass", cl.loadClass(adminObject.getAdminobjectClass().getStringValue()));
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not initialize AdminObject", (Throwable)e);
                }
                ObjectName adminObjectObjectName = null;
                try {
                    adminObjectObjectName = NameFactory.getResourceComponentName(null, null, null, null, (String)gerAdminObjectInstance.getMessageDestinationName(), (String)"JCAAdminObject", (J2eeContext)moduleJ2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct admin object object name", (Throwable)e);
                }
                earContext.addGBean(adminObjectObjectName, adminObjectGBean);
            }
        }
    }

    private Map getActivationSpecInfoMap(MessagelistenerType[] messagelistenerArray, ClassLoader cl) throws DeploymentException {
        HashMap<String, ActivationSpecInfo> activationSpecInfos = new HashMap<String, ActivationSpecInfo>();
        for (int i = 0; i < messagelistenerArray.length; ++i) {
            MessagelistenerType messagelistenerType = messagelistenerArray[i];
            String messageListenerInterface = messagelistenerType.getMessagelistenerType().getStringValue().trim();
            ActivationspecType activationspec = messagelistenerType.getActivationspec();
            String activationSpecClassName = activationspec.getActivationspecClass().getStringValue();
            GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder("org.apache.geronimo.connector.ActivationSpecWrapper", cl);
            HashMap<String, String> getters = new HashMap<String, String>();
            HashSet<String> setters = new HashSet<String>();
            Method[] methods = null;
            try {
                Class<?> activationSpecClass = cl.loadClass(activationSpecClassName);
                methods = activationSpecClass.getMethods();
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Can not load activation spec class", (Throwable)e);
            }
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                String methodName = method.getName();
                if ((methodName.startsWith("get") || methodName.startsWith("is")) && method.getParameterTypes().length == 0) {
                    String attributeName = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
                    getters.put(Introspector.decapitalize(attributeName), method.getReturnType().getName());
                    continue;
                }
                if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
                setters.add(Introspector.decapitalize(methodName.substring(3)));
            }
            getters.keySet().retainAll(setters);
            getters.remove("resourceAdapter");
            Iterator iterator = getters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                infoBuilder.addAttribute((GAttributeInfo)new DynamicGAttributeInfo((String)entry.getKey(), (String)entry.getValue(), true, true, true));
            }
            GBeanInfo gbeanInfo = infoBuilder.getBeanInfo();
            try {
                cl.loadClass(activationSpecClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load ActivationSpec class", (Throwable)e);
            }
            ActivationSpecInfo activationSpecInfo = new ActivationSpecInfo(activationSpecClassName, gbeanInfo);
            activationSpecInfos.put(messageListenerInterface, activationSpecInfo);
        }
        return activationSpecInfos;
    }

    private GBeanMBean setUpDynamicGBean(GBeanInfoBuilder infoFactory, ConfigProperty[] configProperties, ClassLoader cl) throws DeploymentException {
        GBeanMBean gbean;
        for (int i = 0; i < configProperties.length; ++i) {
            infoFactory.addAttribute((GAttributeInfo)new DynamicGAttributeInfo(configProperties[i].getName(), configProperties[i].getType(), true, true, true));
        }
        GBeanInfo gbeanInfo = infoFactory.getBeanInfo();
        try {
            gbean = new GBeanMBean(gbeanInfo, cl);
        }
        catch (InvalidConfigurationException e) {
            throw new DeploymentException("Unable to create GMBean", (Throwable)e);
        }
        try {
            for (int i = 0; i < configProperties.length; ++i) {
                ConfigProperty configProperty = configProperties[i];
                ConnectorModuleBuilder.setAttributeValue(gbean, configProperty.getName(), configProperty.getType(), configProperty.getExplicitValue(), configProperty.getDefaultValue());
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        return gbean;
    }

    private ConfigProperty[] getConfigProperties(ConfigPropertyType10[] configPropertyTypes, GerConfigPropertySettingType[] configPropertySettings) {
        Map explicitValues = this.getExplicitValuesMap(configPropertySettings);
        ConfigProperty[] configProperties = new ConfigProperty[configPropertyTypes.length];
        for (int i = 0; i < configPropertyTypes.length; ++i) {
            ConfigPropertyType10 configPropertyType = configPropertyTypes[i];
            String name = configPropertyType.getConfigPropertyName().getStringValue();
            String type = configPropertyType.getConfigPropertyType().getStringValue();
            String explicitValue = (String)explicitValues.get(name);
            String defaultValue = configPropertyType.getConfigPropertyValue() != null ? configPropertyType.getConfigPropertyValue().getStringValue() : null;
            configProperties[i] = new ConfigProperty(name, type, explicitValue, defaultValue);
        }
        return configProperties;
    }

    private ConfigProperty[] getConfigProperties(ConfigPropertyType[] configPropertyTypes, GerConfigPropertySettingType[] configPropertySettings) {
        Map explicitValues = this.getExplicitValuesMap(configPropertySettings);
        ConfigProperty[] configProperties = new ConfigProperty[configPropertyTypes.length];
        for (int i = 0; i < configPropertyTypes.length; ++i) {
            ConfigPropertyType configPropertyType = configPropertyTypes[i];
            String name = configPropertyType.getConfigPropertyName().getStringValue();
            String type = configPropertyType.getConfigPropertyType().getStringValue();
            String explicitValue = (String)explicitValues.get(name);
            String defaultValue = null;
            if (configPropertyType.isSetConfigPropertyValue()) {
                defaultValue = configPropertyType.getConfigPropertyValue().getStringValue();
            }
            configProperties[i] = new ConfigProperty(name, type, explicitValue, defaultValue);
        }
        return configProperties;
    }

    private Map getExplicitValuesMap(GerConfigPropertySettingType[] configPropertySettings) {
        HashMap<String, String> explicitValues = new HashMap<String, String>();
        for (int j = 0; j < configPropertySettings.length; ++j) {
            GerConfigPropertySettingType configPropertySetting = configPropertySettings[j];
            String name = configPropertySetting.getName();
            String value = configPropertySetting.getStringValue();
            explicitValues.put(name, value);
        }
        return explicitValues;
    }

    private static void setAttributeValue(GBeanMBean gbean, String name, String type, String explicitValue, String defaultValue) throws DeploymentException, ReflectionException, AttributeNotFoundException {
        Class<?> clazz;
        if (explicitValue == null && defaultValue == null) {
            return;
        }
        try {
            clazz = gbean.getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load attribute class: attribute: " + name + ", type: " + type, (Throwable)e);
        }
        PropertyEditor editor = PropertyEditors.getEditor(clazz);
        if (explicitValue != null) {
            editor.setAsText(explicitValue);
        } else {
            editor.setAsText(defaultValue);
        }
        Object value = editor.getValue();
        gbean.setAttribute(name, value);
    }

    private ObjectName configureConnectionManager(EARContext earContext, J2eeContext j2eeContext, String ddTransactionSupport, GerConnectiondefinitionInstanceType connectionfactoryInstance, ClassLoader cl) throws DeploymentException {
        GerSinglepoolType pool;
        GBeanMBean connectionManagerGBean;
        if (connectionfactoryInstance.getConnectionmanagerRef() != null) {
            try {
                return ObjectName.getInstance(connectionfactoryInstance.getConnectionmanagerRef());
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Invalid ObjectName string supplied for ConnectionManager reference", (Throwable)e);
            }
        }
        GerConnectionmanagerType connectionManager = connectionfactoryInstance.getConnectionmanager();
        try {
            connectionManagerGBean = new GBeanMBean(GBeanInfo.getGBeanInfo((String)"org.apache.geronimo.connector.outbound.GenericConnectionManager", (ClassLoader)cl), cl);
        }
        catch (InvalidConfigurationException e) {
            throw new DeploymentException("Unable to create GMBean", (Throwable)e);
        }
        TransactionSupport transactionSupport = null;
        if (connectionManager.isSetNoTransaction()) {
            transactionSupport = NoTransactions.INSTANCE;
        } else if (connectionManager.isSetLocalTransaction()) {
            transactionSupport = LocalTransactions.INSTANCE;
        } else if (connectionManager.isSetTransactionLog()) {
            transactionSupport = TransactionLog.INSTANCE;
        } else if (connectionManager.isSetXaTransaction()) {
            transactionSupport = new XATransactions(connectionManager.getXaTransaction().isSetTransactionCaching(), connectionManager.getXaTransaction().isSetThreadCaching());
        } else if ("NoTransaction".equals(ddTransactionSupport)) {
            transactionSupport = NoTransactions.INSTANCE;
        } else if ("LocalTransaction".equals(ddTransactionSupport)) {
            transactionSupport = LocalTransactions.INSTANCE;
        } else if ("XATransaction".equals(ddTransactionSupport)) {
            transactionSupport = new XATransactions(this.defaultXATransactionCaching, this.defaultXAThreadCaching);
        } else {
            throw new DeploymentException("Unexpected transaction support element");
        }
        NoPool pooling = null;
        if (connectionManager.getSinglePool() != null) {
            pool = connectionManager.getSinglePool();
            pooling = new SinglePool(pool.isSetMaxSize() ? pool.getMaxSize() : this.defaultMaxSize, pool.isSetMinSize() ? pool.getMinSize() : this.defaultMinSize, pool.isSetBlockingTimeoutMilliseconds() ? pool.getBlockingTimeoutMilliseconds() : this.defaultBlockingTimeoutMilliseconds, pool.isSetIdleTimeoutMinutes() ? pool.getIdleTimeoutMinutes() : this.defaultIdleTimeoutMinutes, pool.getMatchOne() != null, pool.getMatchAll() != null, pool.getSelectOneAssumeMatch() != null);
        } else if (connectionManager.getPartitionedPool() != null) {
            pool = connectionManager.getPartitionedPool();
            pooling = new PartitionedPool(pool.isSetMaxSize() ? pool.getMaxSize() : this.defaultMaxSize, pool.isSetMinSize() ? pool.getMinSize() : this.defaultMinSize, pool.isSetBlockingTimeoutMilliseconds() ? pool.getBlockingTimeoutMilliseconds() : this.defaultBlockingTimeoutMilliseconds, pool.isSetIdleTimeoutMinutes() ? pool.getIdleTimeoutMinutes() : this.defaultIdleTimeoutMinutes, pool.getMatchOne() != null, pool.getMatchAll() != null, pool.getSelectOneAssumeMatch() != null, pool.isSetPartitionByConnectionrequestinfo(), pool.isSetPartitionBySubject());
        } else if (connectionManager.getNoPool() != null) {
            pooling = new NoPool();
        } else {
            throw new DeploymentException("Unexpected pooling support element");
        }
        try {
            connectionManagerGBean.setAttribute("name", (Object)connectionfactoryInstance.getName());
            connectionManagerGBean.setAttribute("transactionSupport", (Object)transactionSupport);
            connectionManagerGBean.setAttribute("pooling", (Object)pooling);
            connectionManagerGBean.setReferencePattern("ConnectionTracker", earContext.getConnectionTrackerObjectName());
            if (connectionManager.getRealmBridge() != null) {
                connectionManagerGBean.setReferencePattern("RealmBridge", ObjectName.getInstance(BASE_REALM_BRIDGE_NAME + connectionManager.getRealmBridge()));
            }
            connectionManagerGBean.setReferencePattern("TransactionContextManager", earContext.getTransactionContextManagerObjectName());
        }
        catch (Exception e) {
            throw new DeploymentException("Problem setting up ConnectionManager", (Throwable)e);
        }
        ObjectName connectionManagerObjectName = null;
        try {
            connectionManagerObjectName = NameFactory.getResourceComponentName(null, null, null, null, (String)connectionfactoryInstance.getName(), (String)"JCAConnectionManager", (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct connection manager object name", (Throwable)e);
        }
        earContext.addGBean(connectionManagerObjectName, connectionManagerGBean);
        return connectionManagerObjectName;
    }

    private void addOutboundGBeans(EARContext earContext, J2eeContext j2eeContext, ObjectName resourceAdapterObjectName, GerConnectiondefinitionInstanceType connectiondefinitionInstance, ConfigProperty[] configProperties, String managedConnectionFactoryClass, String connectionFactoryInterface, String connectionFactoryImplClass, String connectionInterface, String connectionImplClass, String transactionSupport, ClassLoader cl) throws DeploymentException {
        ObjectName connectionManagerObjectName = this.configureConnectionManager(earContext, j2eeContext, transactionSupport, connectiondefinitionInstance, cl);
        GBeanInfoBuilder managedConnectionFactoryInfoFactory = new GBeanInfoBuilder("org.apache.geronimo.connector.outbound.ManagedConnectionFactoryWrapper", cl);
        GBeanMBean managedConnectionFactoryGBean = this.setUpDynamicGBean(managedConnectionFactoryInfoFactory, configProperties, cl);
        try {
            FullyQualifiedClassType[] implementedInterfaceElements;
            managedConnectionFactoryGBean.setAttribute("managedConnectionFactoryClass", cl.loadClass(managedConnectionFactoryClass));
            managedConnectionFactoryGBean.setAttribute("connectionFactoryInterface", cl.loadClass(connectionFactoryInterface));
            managedConnectionFactoryGBean.setAttribute("connectionFactoryImplClass", cl.loadClass(connectionFactoryImplClass));
            managedConnectionFactoryGBean.setAttribute("connectionInterface", cl.loadClass(connectionInterface));
            managedConnectionFactoryGBean.setAttribute("connectionImplClass", cl.loadClass(connectionImplClass));
            managedConnectionFactoryGBean.setAttribute("globalJNDIName", (Object)connectiondefinitionInstance.getGlobalJndiName());
            if (resourceAdapterObjectName != null) {
                managedConnectionFactoryGBean.setReferencePattern("ResourceAdapterWrapper", resourceAdapterObjectName);
            }
            managedConnectionFactoryGBean.setReferencePattern("ConnectionManagerFactory", connectionManagerObjectName);
            if (connectiondefinitionInstance.getCredentialInterface() != null && "javax.resource.spi.security.PasswordCredential".equals(connectiondefinitionInstance.getCredentialInterface().getStringValue())) {
                GBeanMBean realmGBean = new GBeanMBean(PasswordCredentialRealm.getGBeanInfo(), cl);
                realmGBean.setAttribute("realmName", (Object)(BASE_PASSWORD_CREDENTIAL_LOGIN_MODULE_NAME + connectiondefinitionInstance.getName()));
                ObjectName realmObjectNam = ObjectName.getInstance(BASE_PASSWORD_CREDENTIAL_LOGIN_MODULE_NAME + connectiondefinitionInstance.getName());
                earContext.addGBean(realmObjectNam, realmGBean);
                managedConnectionFactoryGBean.setReferencePattern("ManagedConnectionFactoryListener", realmObjectNam);
            }
            Class[] implementedInterfaces = new Class[(implementedInterfaceElements = connectiondefinitionInstance.getImplementedInterfaceArray()) == null ? 0 : implementedInterfaceElements.length];
            for (int i = 0; i < implementedInterfaceElements.length; ++i) {
                FullyQualifiedClassType additionalInterfaceType = implementedInterfaceElements[i];
                implementedInterfaces[i] = cl.loadClass(additionalInterfaceType.getStringValue());
            }
            managedConnectionFactoryGBean.setAttribute("implementedInterfaces", (Object)implementedInterfaces);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        ObjectName managedConnectionFactoryObjectName = null;
        try {
            managedConnectionFactoryObjectName = NameFactory.getResourceComponentName(null, null, null, null, (String)connectiondefinitionInstance.getName(), (String)NameFactory.JCA_MANAGED_CONNECTION_FACTORY, (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct managed connection factory object name", (Throwable)e);
        }
        earContext.addGBean(managedConnectionFactoryObjectName, managedConnectionFactoryGBean);
        GBeanMBean connectionFactory = new GBeanMBean(JCAConnectionFactoryImpl.GBEAN_INFO, cl);
        connectionFactory.setReferencePattern("J2EEServer", earContext.getServerObjectName());
        try {
            connectionFactory.setAttribute("managedConnectionFactory", (Object)managedConnectionFactoryObjectName.getCanonicalName());
        }
        catch (Exception e) {
            throw new DeploymentException("Could not initialize JCAConnectionFactory", (Throwable)e);
        }
        ObjectName connectionFactoryObjectName = null;
        try {
            connectionFactoryObjectName = NameFactory.getResourceComponentName(null, null, null, null, (String)connectiondefinitionInstance.getName(), (String)NameFactory.JCA_CONNECTION_FACTORY, (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct connection factory object name", (Throwable)e);
        }
        earContext.addGBean(connectionFactoryObjectName, connectionFactory);
    }

    private static URI getDependencyURI(GerDependencyType dependency) throws DeploymentException {
        if (dependency.isSetUri()) {
            try {
                return new URI(dependency.getUri());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid dependency URI " + dependency.getUri(), (Throwable)e);
            }
        }
        String id = dependency.getGroupId() + "/jars/" + dependency.getArtifactId() + '-' + dependency.getVersion() + ".jar";
        try {
            return new URI(id);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Unable to construct URI for groupId=" + dependency.getGroupId() + ", artifactId=" + dependency.getArtifactId() + ", version=" + dependency.getVersion(), (Throwable)e);
        }
    }

    public Reference createResourceRef(String containerId, Class iface) throws DeploymentException {
        Reference ref = new Reference(null, RefAddrContentObjectFactory.class.getName(), null);
        ref.add((RefAddr)new GBeanGetResourceRefAddr(null, containerId, iface));
        return ref;
    }

    public Reference createAdminObjectRef(String containerId, Class iface) throws DeploymentException {
        Reference ref = new Reference(null, RefAddrContentObjectFactory.class.getName(), null);
        ref.add((RefAddr)new GBeanGetResourceRefAddr(null, containerId, iface));
        return ref;
    }

    public ObjectName locateResourceName(ObjectName query) throws DeploymentException {
        Set names = this.kernel.listGBeans(query);
        if (names.size() != 1) {
            throw new DeploymentException("Unknown or ambiguous resource name query: " + query + " match count: " + names.size());
        }
        return (ObjectName)names.iterator().next();
    }

    public Object locateActivationSpecInfo(ObjectName resourceAdapterName, String messageListenerInterface) throws DeploymentException {
        Map activationSpecInfos = null;
        try {
            activationSpecInfos = (Map)this.kernel.getAttribute(resourceAdapterName, "activationSpecInfoMap");
        }
        catch (Exception e) {
            throw new DeploymentException("Could not get activation spec infos for resource adapter named: " + resourceAdapterName, (Throwable)e);
        }
        return activationSpecInfos.get(messageListenerInterface);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !ConnectorModuleBuilder.class.desiredAssertionStatus();
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(ConnectorModuleBuilder.class);
        infoBuilder.addAttribute("defaultParentId", URI.class, true);
        infoBuilder.addAttribute("defaultMaxSize", Integer.TYPE, true);
        infoBuilder.addAttribute("defaultMinSize", Integer.TYPE, true);
        infoBuilder.addAttribute("defaultBlockingTimeoutMilliseconds", Integer.TYPE, true);
        infoBuilder.addAttribute("defaultIdleTimeoutMinutes", Integer.TYPE, true);
        infoBuilder.addAttribute("defaultXATransactionCaching", Boolean.TYPE, true);
        infoBuilder.addAttribute("defaultXAThreadCaching", Boolean.TYPE, true);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.addInterface(ResourceReferenceBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultParentId", "defaultMaxSize", "defaultMinSize", "defaultBlockingTimeoutMilliseconds", "defaultIdleTimeoutMinutes", "defaultXATransactionCaching", "defaultXAThreadCaching", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private static final class ConfigProperty {
        private final String name;
        private final String type;
        private final String explicitValue;
        private final String defaultValue;

        public ConfigProperty(String name, String type, String explicitValue, String defaultValue) {
            this.name = name;
            this.type = type;
            this.explicitValue = explicitValue;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getExplicitValue() {
            return this.explicitValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

