/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common;

import org.apache.geronimo.common.DataConversionException;

public final class Primitives {
    public static boolean equals(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    public static boolean equals(float a, float b) {
        return Float.floatToIntBits(a) == Float.floatToIntBits(b);
    }

    public static boolean equals(byte[] a, int abegin, byte[] b, int bbegin, int length) {
        if (a == null || b == null) {
            return false;
        }
        try {
            int i = length;
            while (--i >= 0) {
                if (a[abegin + i] == b[bbegin + i]) continue;
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int toInt(long value) throws DataConversionException {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new DataConversionException("Can not safely convert to int: " + value);
        }
        return (int)value;
    }
}

