/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering;

import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.clustering.Data;
import org.apache.geronimo.clustering.NamedMBeanImpl;
import org.apache.geronimo.clustering.Node;

public abstract class Tier
extends NamedMBeanImpl {
    protected Log _log = LogFactory.getLog((Class)Tier.class);
    protected Data _data;
    protected Map _tiers;
    protected Object _tier;
    protected Node _node;

    public static ObjectName makeObjectName(String clusterName, String nodeName, String tierName) throws Exception {
        return new ObjectName("geronimo.clustering:role=Tier,name=" + tierName + ",node=" + nodeName + ",cluster=" + clusterName);
    }

    public Node getNode() {
        return this._node;
    }

    public ObjectName getNodeObjectName() {
        return this._node == null ? null : this._node.getObjectName();
    }

    public String getClusterName() {
        return this._objectName.getKeyProperty("cluster");
    }

    public String getNodeName() {
        return this._objectName.getKeyProperty("node");
    }

    protected abstract Object alloc();

    public abstract Object registerData(String var1, Object var2);

    public abstract Object deregisterData(String var1);

    public boolean canStart() {
        if (!super.canStart()) {
            return false;
        }
        if (this._objectName.getKeyProperty("cluster") == null) {
            this._log.warn((Object)"Tier MBean name must contain a 'cluster' property");
            return false;
        }
        if (this._objectName.getKeyProperty("node") == null) {
            this._log.warn((Object)"Tier MBean name must contain a 'node' property");
            return false;
        }
        try {
            this._node = (Node)this._server.getAttribute(Node.makeObjectName(this.getClusterName(), this.getNodeName()), "Reference");
            this._log.debug((Object)("Node: " + this._node));
        }
        catch (Exception e) {
            this._log.error((Object)"could not find Node", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStart() {
        this._log.info((Object)"starting");
        Data data = this._node.getData();
        this._tiers = data.getTiers();
        this._tier = null;
        Map map = this._tiers;
        synchronized (map) {
            this._tier = this._tiers.get(this.getName());
            if (this._tier == null) {
                this._tier = this.alloc();
                this._tiers.put(this.getName(), this._tier);
            }
        }
        this._log.info((Object)("Node Data:" + data));
    }
}

