/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.clustering.Cluster;
import org.apache.geronimo.clustering.Data;
import org.apache.geronimo.clustering.DataDelta;
import org.apache.geronimo.clustering.DataDeltaListener;
import org.apache.geronimo.clustering.DataListener;
import org.apache.geronimo.clustering.MetaDataListener;

public class LocalCluster
extends Cluster {
    protected Log _log = LogFactory.getLog((Class)LocalCluster.class);
    protected List _members = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMembers() {
        List list = this._members;
        synchronized (list) {
            return Collections.unmodifiableList(this._members);
        }
    }

    protected void notifyMembershipChanged(List members) {
        Iterator i = members.iterator();
        while (i.hasNext()) {
            try {
                Object member = i.next();
                if (!(member instanceof MetaDataListener)) continue;
                ((MetaDataListener)member).setMetaData(members);
            }
            catch (Exception e) {
                this._log.warn((Object)"problem notifying membership changed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Object member) {
        List list = this._members;
        synchronized (list) {
            this._members.add(member);
            this.notifyMembershipChanged(this._members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(Object member) {
        List list = this._members;
        synchronized (list) {
            this._members.remove(member);
            this.notifyMembershipChanged(this._members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Data getData() {
        List list = this._members;
        synchronized (list) {
            if (this._members.isEmpty()) {
                return null;
            }
            Iterator i = this._members.iterator();
            while (i.hasNext()) {
                Object member = i.next();
                if (!(member instanceof DataListener)) continue;
                return ((DataListener)member).getData();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataDelta(DataDeltaListener l, DataDelta delta) {
        List list = this._members;
        synchronized (list) {
            Iterator i = this._members.iterator();
            while (i.hasNext()) {
                Object member = i.next();
                if (member == l || !(member instanceof DataDeltaListener)) continue;
                ((DataDeltaListener)member).applyDataDelta(delta);
            }
        }
    }
}

