/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering;

import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.clustering.Cluster;
import org.apache.geronimo.clustering.Data;
import org.apache.geronimo.clustering.DataDelta;
import org.apache.geronimo.clustering.DataDeltaListener;
import org.apache.geronimo.clustering.DataListener;
import org.apache.geronimo.clustering.MetaDataListener;
import org.apache.geronimo.clustering.NamedMBeanImpl;

public class Node
extends NamedMBeanImpl
implements MetaDataListener,
DataListener,
DataDeltaListener {
    protected Log _log = LogFactory.getLog((Class)Node.class);
    protected Cluster _cluster;
    protected Data _data;

    public static ObjectName makeObjectName(String clusterName, String nodeName) throws Exception {
        return new ObjectName("geronimo.clustering:role=Node,name=" + nodeName + ",cluster=" + clusterName);
    }

    public String getClusterName() {
        return this._objectName.getKeyProperty("cluster");
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public ObjectName getClusterObjectName() {
        return this._cluster == null ? null : this._cluster.getObjectName();
    }

    public void setMetaData(List members) {
        this._log.info((Object)("membership changed: " + members));
    }

    public Data getData() {
        return this._data;
    }

    public void setData(Data data) {
        String xtra = "we must be the first node up";
        if (data != null) {
            xtra = "we are joining an extant cluster";
            this._data = data;
        } else {
            this._data = new Data();
        }
        this._log.debug((Object)("initialising data - " + xtra));
    }

    public void applyDataDelta(DataDelta delta) {
        this._log.trace((Object)("applying data delta - " + delta));
    }

    public boolean canStart() {
        if (!super.canStart()) {
            return false;
        }
        if (this._objectName.getKeyProperty("cluster") == null) {
            this._log.warn((Object)"NodeMBean name must contain a 'cluster' property");
            return false;
        }
        try {
            this._cluster = (Cluster)this._server.getAttribute(Cluster.makeObjectName(this._objectName.getKeyProperty("cluster")), "Reference");
        }
        catch (Exception e) {
            this._log.error((Object)"could not find Cluster", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        this._log.info((Object)"starting");
        Cluster cluster = this._cluster;
        synchronized (cluster) {
            Data data = this._cluster.getData();
            this._log.info((Object)("state transfer - sending: " + data));
            this.setData(data);
            this._cluster.join(this);
        }
    }

    public void doStop() {
        this._log.info((Object)"stopping");
        this._cluster.leave(this);
    }

    public void doFail() {
        this._log.info((Object)"failing");
        this._cluster.leave(this);
    }
}

