/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client;

import [Ljava.lang.String;;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.client.AppClientInitializationException;
import org.apache.geronimo.client.AppClientPlugin;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public final class AppClientContainer {
    private static final Class[] MAIN_ARGS = new Class[]{String;.class};
    private final String mainClassName;
    private final AppClientPlugin jndiContext;
    private final ObjectName appClientModuleName;
    private final String realmName;
    private final Class callbackHandlerClass;
    private final Subject defaultSubject;
    private final Method mainMethod;
    private final ClassLoader classLoader;
    private final Kernel kernel;
    private final TransactionContextManager transactionContextManager;
    public static final GBeanInfo GBEAN_INFO;

    public AppClientContainer(String mainClassName, ObjectName appClientModuleName, String realmName, String callbackHandlerClassName, DefaultPrincipal defaultPrincipal, AppClientPlugin jndiContext, TransactionContextManager transactionContextManager, ClassLoader classLoader, Kernel kernel) throws Exception {
        this.mainClassName = mainClassName;
        this.appClientModuleName = appClientModuleName;
        if (realmName == null != (callbackHandlerClassName == null)) {
            throw new IllegalArgumentException("You must supply both realmName and callbackHandlerClass or neither");
        }
        this.realmName = realmName;
        if (callbackHandlerClassName != null) {
            try {
                this.callbackHandlerClass = classLoader.loadClass(callbackHandlerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new AppClientInitializationException("Could not load callbackHandlerClass", e);
            }
        } else {
            this.callbackHandlerClass = null;
        }
        this.defaultSubject = defaultPrincipal != null ? ConfigurationUtil.generateDefaultSubject((DefaultPrincipal)defaultPrincipal) : null;
        this.classLoader = classLoader;
        this.kernel = kernel;
        this.jndiContext = jndiContext;
        this.transactionContextManager = transactionContextManager;
        try {
            Class<?> mainClass = classLoader.loadClass(mainClassName);
            this.mainMethod = mainClass.getMethod("main", MAIN_ARGS);
        }
        catch (ClassNotFoundException e) {
            throw new AppClientInitializationException("Unable to load Main-Class " + mainClassName, e);
        }
        catch (NoSuchMethodException e) {
            throw new AppClientInitializationException("Main-Class " + mainClassName + " does not have a main method", e);
        }
    }

    public ObjectName getAppClientModuleName() {
        return this.appClientModuleName;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(final String[] args) throws Exception {
        Subject oldCurrentCaller;
        TransactionContext currentTransactionContext;
        TransactionContext oldTransactionContext;
        ClassLoader oldClassLoader;
        Thread thread;
        block17: {
            thread = Thread.currentThread();
            oldClassLoader = thread.getContextClassLoader();
            oldTransactionContext = this.transactionContextManager.getContext();
            currentTransactionContext = null;
            oldCurrentCaller = ContextManager.getCurrentCaller();
            Subject clientSubject = this.defaultSubject;
            LoginContext loginContext = null;
            try {
                try {
                    thread.setContextClassLoader(this.classLoader);
                    if (this.callbackHandlerClass != null) {
                        CallbackHandler callbackHandler;
                        try {
                            Constructor cArgs = this.callbackHandlerClass.getConstructor(String;.class);
                            callbackHandler = (CallbackHandler)cArgs.newInstance(new Object[]{args});
                        }
                        catch (NoSuchMethodException e) {
                            callbackHandler = (CallbackHandler)this.callbackHandlerClass.newInstance();
                        }
                        loginContext = new LoginContext(this.realmName, callbackHandler);
                        try {
                            loginContext.login();
                        }
                        catch (LoginException e) {
                            loginContext = null;
                            throw e;
                        }
                        clientSubject = loginContext.getSubject();
                    }
                    ContextManager.setCurrentCaller((Subject)clientSubject);
                    this.jndiContext.startClient(this.appClientModuleName, this.kernel, this.classLoader);
                    currentTransactionContext = this.transactionContextManager.newUnspecifiedTransactionContext();
                    if (clientSubject == null) {
                        this.mainMethod.invoke(null, new Object[]{args});
                    } else {
                        Subject.doAs(clientSubject, new PrivilegedAction(){

                            public Object run() {
                                try {
                                    AppClientContainer.this.mainMethod.invoke(null, new Object[]{args});
                                }
                                catch (IllegalAccessException e) {
                                    throw new RuntimeException(e);
                                }
                                catch (InvocationTargetException e) {
                                    throw new RuntimeException(e);
                                }
                                return null;
                            }
                        });
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    if (!(cause instanceof Error)) throw new Error(e);
                    throw (Error)cause;
                }
                Object var12_15 = null;
                if (loginContext == null) break block17;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (loginContext != null) {
                    loginContext.logout();
                }
                this.jndiContext.stopClient(this.appClientModuleName);
                thread.setContextClassLoader(oldClassLoader);
                this.transactionContextManager.setContext(oldTransactionContext);
                if (currentTransactionContext != null) {
                    currentTransactionContext.commit();
                }
                ContextManager.setCurrentCaller((Subject)oldCurrentCaller);
                throw throwable;
            }
            loginContext.logout();
        }
        this.jndiContext.stopClient(this.appClientModuleName);
        thread.setContextClassLoader(oldClassLoader);
        this.transactionContextManager.setContext(oldTransactionContext);
        if (currentTransactionContext != null) {
            currentTransactionContext.commit();
        }
        ContextManager.setCurrentCaller((Subject)oldCurrentCaller);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(AppClientContainer.class, "AppClient");
        infoFactory.addOperation("main", new Class[]{String;.class});
        infoFactory.addAttribute("mainClassName", String.class, true);
        infoFactory.addAttribute("appClientModuleName", ObjectName.class, true);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("callbackHandlerClassName", String.class, true);
        infoFactory.addAttribute("defaultPrincipal", DefaultPrincipal.class, true);
        infoFactory.addReference("JNDIContext", AppClientPlugin.class, "GBean");
        infoFactory.addReference("TransactionContextManager", TransactionContextManager.class, "TransactionContextManager");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"mainClassName", "appClientModuleName", "realmName", "callbackHandlerClassName", "defaultPrincipal", "JNDIContext", "TransactionContextManager", "classLoader", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

