/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.axis.utils.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis.AxisGeronimoConstants;
import org.apache.geronimo.axis.AxisGeronimoUtils;
import org.apache.geronimo.connector.ActivationSpecWrapper;
import org.apache.geronimo.connector.ResourceAdapterWrapper;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTrackingCoordinator;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.j2ee.management.impl.J2EEServerImpl;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.pool.ThreadPool;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.timer.vm.VMStoreThreadPooledNonTransactionalTimer;
import org.apache.geronimo.timer.vm.VMStoreThreadPooledTransactionalTimer;
import org.apache.geronimo.transaction.GeronimoTransactionManager;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.openejb.ContainerIndex;

public class DependancyEJBManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ObjectName j2eeServerObjectName;
    private static final String j2eeDomainName = "openejb.server";
    private static final String j2eeServerName = "TestOpenEJBServer";
    private static final ObjectName transactionManagerObjectName = JMXUtil.getObjectName((String)"openejb.server:type=TransactionManager");
    private static final ObjectName connectionTrackerObjectName = JMXUtil.getObjectName((String)"openejb.server:type=ConnectionTracker");
    private ObjectName containerIndexObjectName;
    private ObjectName serverInfoObjectName;
    private File configStore;
    private static Vector dependedEJBs;
    private final Kernel kernel;

    public DependancyEJBManager(Kernel kernel) throws MalformedObjectNameException, DeploymentException {
        this.kernel = kernel;
        this.configStore = new File("target/config-store");
        this.log.debug((Object)("configuration Store is " + this.configStore.getAbsolutePath()));
        dependedEJBs = new Vector();
        this.startJ2EEServer();
        this.log.debug((Object)"start the J2ee server");
        this.startContainerIndex();
        this.log.debug((Object)"start the Continer Index");
    }

    public void stopDependancies() throws DeploymentException {
        for (int i = 0; i < dependedEJBs.size(); ++i) {
            ObjectName gbeanName = (ObjectName)dependedEJBs.get(i);
            AxisGeronimoUtils.stopGBean(gbeanName, this.kernel);
            System.out.println("stop the dependent EJB name=" + gbeanName);
            this.log.debug((Object)("stop the dependent EJB name=" + gbeanName));
        }
        this.stopContainerIndex();
        this.log.debug((Object)"stop the Continer Index");
        this.stopJ2EEServer();
        this.log.debug((Object)"stop the J2EE server");
    }

    public static ClassLoader startDependancy(File unpackedDir, ObjectName service, File configStore, Kernel kernel) throws DeploymentException {
        try {
            GBeanMBean config = DependancyEJBManager.loadConfig(unpackedDir);
            System.out.println("Context Loader " + Thread.currentThread().getContextClassLoader());
            ObjectName objectName = service;
            dependedEJBs.add(objectName);
            kernel.loadGBean(objectName, config);
            config.setAttribute("baseURL", (Object)unpackedDir.toURL());
            kernel.startRecursiveGBean(objectName);
            ClassLoader cl = (ClassLoader)kernel.getAttribute(objectName, "classLoader");
            System.out.println("start dependent EJB name=" + objectName + " dir=" + unpackedDir.getAbsolutePath() + "the config CL =" + cl);
            return cl;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void startContainerIndex() throws DeploymentException, MalformedObjectNameException {
        GBeanMBean containerIndexGBean = new GBeanMBean(ContainerIndex.GBEAN_INFO);
        this.containerIndexObjectName = ObjectName.getInstance("openejb.server:type=ContainerIndex");
        HashSet<ObjectName> ejbContainerNames = new HashSet<ObjectName>();
        ejbContainerNames.add(ObjectName.getInstance("openejb.server:j2eeType=StatelessSessionBean,*"));
        ejbContainerNames.add(ObjectName.getInstance("openejb.server:j2eeType=StatefulSessionBean,*"));
        ejbContainerNames.add(ObjectName.getInstance("openejb.server:j2eeType=EntityBean,*"));
        containerIndexGBean.setReferencePatterns("EJBContainers", ejbContainerNames);
        AxisGeronimoUtils.startGBean(this.containerIndexObjectName, containerIndexGBean, this.kernel);
    }

    private void stopContainerIndex() throws DeploymentException {
        AxisGeronimoUtils.stopGBean(this.containerIndexObjectName, this.kernel);
    }

    private void startJ2EEServer() throws DeploymentException {
        try {
            String str = System.getProperty("java.naming.factory.url.pkgs");
            str = str == null ? ":org.apache.geronimo.naming" : str + ":org.apache.geronimo.naming";
            System.setProperty("java.naming.factory.url.pkgs", str);
            this.setUpTransactionManager(this.kernel);
            DependancyEJBManager.setUpTimer(this.kernel);
            GBeanMBean serverInfoGBean = new GBeanMBean(ServerInfo.GBEAN_INFO);
            serverInfoGBean.setAttribute("baseDirectory", (Object)".");
            ObjectName serverInfoObjectName = ObjectName.getInstance("openejb.server:type=ServerInfo");
            this.kernel.loadGBean(serverInfoObjectName, serverInfoGBean);
            this.kernel.startGBean(serverInfoObjectName);
            GBeanMBean j2eeServerGBean = new GBeanMBean(J2EEServerImpl.GBEAN_INFO);
            j2eeServerGBean.setReferencePatterns("ServerInfo", Collections.singleton(serverInfoObjectName));
            ObjectName j2eeServerObjectName = ObjectName.getInstance("openejb.server:j2eeType=J2EEServer,name=TestOpenEJBServer");
            this.kernel.loadGBean(j2eeServerObjectName, j2eeServerGBean);
            this.kernel.startGBean(j2eeServerObjectName);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void setUpTransactionManager(Kernel kernel) throws DeploymentException {
        try {
            GBeanMBean tmGBean = new GBeanMBean(GeronimoTransactionManager.GBEAN_INFO);
            HashSet<ObjectName> rmpatterns = new HashSet<ObjectName>();
            rmpatterns.add(ObjectName.getInstance("geronimo.server:j2eeType=JCAManagedConnectionFactory,*"));
            tmGBean.setReferencePatterns("ResourceManagers", rmpatterns);
            AxisGeronimoUtils.startGBean(AxisGeronimoConstants.TRANSACTIONMANAGER_NAME, tmGBean, kernel);
            GBeanMBean tcmGBean = new GBeanMBean(TransactionContextManager.GBEAN_INFO);
            tcmGBean.setReferencePattern("TransactionManager", AxisGeronimoConstants.TRANSACTIONMANAGER_NAME);
            AxisGeronimoUtils.startGBean(AxisGeronimoConstants.TRANSACTIONCONTEXTMANAGER_NAME, tcmGBean, kernel);
            GBeanMBean trackedConnectionAssociator = new GBeanMBean(ConnectionTrackingCoordinator.GBEAN_INFO);
            AxisGeronimoUtils.startGBean(AxisGeronimoConstants.TRACKEDCONNECTIONASSOCIATOR_NAME, trackedConnectionAssociator, kernel);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public static void setUpTimer(Kernel kernel) throws Exception {
        GBeanMBean threadPoolGBean = new GBeanMBean(ThreadPool.GBEAN_INFO);
        threadPoolGBean.setAttribute("keepAliveTime", (Object)new Integer(5000));
        threadPoolGBean.setAttribute("poolSize", (Object)new Integer(5));
        threadPoolGBean.setAttribute("poolName", (Object)"DefaultThreadPool");
        AxisGeronimoUtils.startGBean(AxisGeronimoConstants.THREADPOOL_NAME, threadPoolGBean, kernel);
        GBeanMBean transactionalTimerGBean = new GBeanMBean(VMStoreThreadPooledTransactionalTimer.GBEAN_INFO);
        transactionalTimerGBean.setAttribute("repeatCount", (Object)new Integer(5));
        transactionalTimerGBean.setReferencePattern("TransactionContextManager", AxisGeronimoConstants.TRANSACTIONCONTEXTMANAGER_NAME);
        transactionalTimerGBean.setReferencePattern("ThreadPool", AxisGeronimoConstants.THREADPOOL_NAME);
        AxisGeronimoUtils.startGBean(AxisGeronimoConstants.TRANSACTIONALTIMER_NAME, transactionalTimerGBean, kernel);
        GBeanMBean nonTransactionalTimerGBean = new GBeanMBean(VMStoreThreadPooledNonTransactionalTimer.GBEAN_INFO);
        nonTransactionalTimerGBean.setReferencePattern("ThreadPool", AxisGeronimoConstants.THREADPOOL_NAME);
        AxisGeronimoUtils.startGBean(AxisGeronimoConstants.NONTRANSACTIONALTIMER_NAME, nonTransactionalTimerGBean, kernel);
    }

    public void setUpResourceAdapter(Kernel kernel) throws Exception {
        GBeanMBean geronimoWorkManagerGBean = new GBeanMBean(GeronimoWorkManager.getGBeanInfo());
        geronimoWorkManagerGBean.setAttribute("syncMaximumPoolSize", (Object)new Integer(5));
        geronimoWorkManagerGBean.setAttribute("startMaximumPoolSize", (Object)new Integer(5));
        geronimoWorkManagerGBean.setAttribute("scheduledMaximumPoolSize", (Object)new Integer(5));
        geronimoWorkManagerGBean.setReferencePattern("XAServices", AxisGeronimoConstants.TRANSACTIONMANAGER_NAME);
        AxisGeronimoUtils.startGBean(AxisGeronimoConstants.WORKMANAGER_NAME, geronimoWorkManagerGBean, kernel);
        GBeanMBean resourceAdapterGBean = new GBeanMBean(ResourceAdapterWrapper.getGBeanInfo());
        HashMap activationSpecInfoMap = new HashMap();
        resourceAdapterGBean.setReferencePattern("WorkManager", AxisGeronimoConstants.WORKMANAGER_NAME);
        AxisGeronimoUtils.startGBean(AxisGeronimoConstants.RESOURCE_ADAPTER_NAME, resourceAdapterGBean, kernel);
        GBeanMBean activationSpecGBean = new GBeanMBean(ActivationSpecWrapper.getGBeanInfo());
        activationSpecGBean.setAttribute("containerId", (Object)AxisGeronimoConstants.CONTAINER_NAME.getCanonicalName());
        activationSpecGBean.setReferencePattern("ResourceAdapterWrapper", AxisGeronimoConstants.RESOURCE_ADAPTER_NAME);
        AxisGeronimoUtils.startGBean(AxisGeronimoConstants.ACTIVATIONSPEC_NAME, activationSpecGBean, kernel);
    }

    private void stopJ2EEServer() throws DeploymentException {
        AxisGeronimoUtils.stopGBean(this.serverInfoObjectName, this.kernel);
        AxisGeronimoUtils.stopGBean(this.j2eeServerObjectName, this.kernel);
        AxisGeronimoUtils.stopGBean(transactionManagerObjectName, this.kernel);
        AxisGeronimoUtils.stopGBean(connectionTrackerObjectName, this.kernel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GBeanMBean loadConfig(File unpackedCar) throws Exception {
        FileInputStream in = new FileInputStream(new File(unpackedCar, "META-INF/config.ser"));
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(in));
            GBeanInfo gbeanInfo = Configuration.GBEAN_INFO;
            GBeanMBean config = new GBeanMBean(gbeanInfo, ClassUtils.getDefaultClassLoader());
            Configuration.loadGMBeanState((GBeanMBean)config, (ObjectInputStream)ois);
            GBeanMBean gBeanMBean = config;
            return gBeanMBean;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static void addDependentEJB(ObjectName serviceName) {
        dependedEJBs.add(serviceName);
    }
}

