/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis;

import javax.management.ObjectName;
import org.apache.geronimo.axis.WebServiceContainer;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class AxisGbean
implements GBeanLifecycle {
    private final String name;
    private final Kernel kernel;
    private static final GBeanInfo GBEAN_INFO;
    private final ObjectName objectName;
    private WebServiceContainer wscontiner;

    public AxisGbean(Kernel kernel, String name, String objectName) {
        this.name = name;
        this.kernel = kernel;
        this.objectName = JMXUtil.getObjectName((String)objectName);
        this.wscontiner = new WebServiceContainer(kernel);
    }

    public void doFail() {
        System.out.println("Axis GBean has failed");
    }

    public void doStart() throws WaitingException, Exception {
        System.out.println("Axis GBean has started");
        System.out.println(this.kernel);
        System.out.println(this.objectName);
        this.wscontiner.doStart();
    }

    public void doStop() throws WaitingException, Exception {
        System.out.println("Axis GBean has stoped");
        this.wscontiner.doStop();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public String getName() {
        return this.name;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory("AxisGbean", AxisGbean.class);
        infoFactory.addAttribute("Name", String.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.setConstructor(new String[]{"kernel", "Name", "objectName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

