/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.plugin.assembly;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URL;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.plugin.assembly.BaseConfigInstaller;
import org.apache.geronimo.system.repository.FileSystemRepository;

public class RepoConfigInstaller
extends BaseConfigInstaller {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        BaseConfigInstaller.InnerRepository sourceRepo = new BaseConfigInstaller.InnerRepository();
        URI rootURI = this.targetRoot.toURI().resolve(this.targetRepository);
        FileSystemRepository targetRepo = new FileSystemRepository(rootURI, null);
        CopyConfigStore installAdapter = new CopyConfigStore(targetRepo);
        targetRepo.doStart();
        try {
            this.execute(installAdapter, sourceRepo, targetRepo);
        }
        finally {
            targetRepo.doStop();
        }
    }

    private static class CopyConfigStore
    implements BaseConfigInstaller.InstallAdapter {
        private final FileSystemRepository targetRepo;

        public CopyConfigStore(FileSystemRepository targetRepo) {
            this.targetRepo = targetRepo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GBeanData install(Repository sourceRepo, URI configId) throws IOException, InvalidConfigException {
            URL sourceURL = sourceRepo.getURL(configId);
            InputStream in = sourceURL.openStream();
            try {
                if (!this.targetRepo.hasURI(configId)) {
                    this.targetRepo.copyToRepository(in, configId, (FileWriteMonitor)new BaseConfigInstaller.StartFileWriteMonitor());
                }
            }
            finally {
                in.close();
            }
            URL targetURL = this.targetRepo.getURL(configId);
            GBeanData config = new GBeanData();
            URL baseURL = new URL("jar:" + targetURL.toString() + "!/");
            InputStream jis = null;
            try {
                URL stateURL = new URL(baseURL, "META-INF/config.ser");
                jis = stateURL.openStream();
                ObjectInputStream ois = new ObjectInputStream(jis);
                config.readExternal((ObjectInput)ois);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigException("Unable to load class from config: " + configId, (Throwable)e);
            }
            finally {
                if (jis != null) {
                    jis.close();
                }
            }
            return config;
        }

        public boolean containsConfiguration(URI configID) {
            return this.targetRepo.hasURI(configID);
        }
    }
}

