/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.daytrader.client.ws;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.geronimo.samples.daytrader.client.ws.AccountDataBean;
import org.apache.geronimo.samples.daytrader.client.ws.AccountProfileDataBean;
import org.apache.geronimo.samples.daytrader.client.ws.ClientScenario;
import org.apache.geronimo.samples.daytrader.client.ws.HoldingDataBean;
import org.apache.geronimo.samples.daytrader.client.ws.MarketSummaryDataBeanWS;
import org.apache.geronimo.samples.daytrader.client.ws.OrderDataBean;
import org.apache.geronimo.samples.daytrader.client.ws.QuoteDataBean;
import org.apache.geronimo.samples.daytrader.client.ws.TradeWSServices;

public class ClientApp
extends JFrame {
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JPanel jPanel = null;
    private JMenuBar jJMenuBar = null;
    private JMenu jMenu = null;
    private JMenuItem jMenuItem = null;
    private JMenuItem jMenuItem1 = null;
    private JMenu jMenu1 = null;
    private JButton jButton = null;
    private JTextField jTextField = null;
    private JLabel jLabel1 = null;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextArea = null;
    private JLabel jLabel2 = null;
    private JPasswordField jPasswordField1 = null;
    private JLabel jLabel3 = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private JPanel jPanel3 = null;
    private JPanel jPanel4 = null;
    private JPanel jPanel5 = null;
    private JPanel jPanel6 = null;
    private JButton jButton1 = null;
    private JPanel jPanel7 = null;
    private JPanel jPanel8 = null;
    private JButton jButton2 = null;
    private JButton jButton3 = null;
    private JButton jButton4 = null;
    private JButton jButton5 = null;
    private JButton jButton6 = null;
    private JButton jButton7 = null;
    private JButton jButton8 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JLabel jLabel6 = null;
    private JTextField jTextField2 = null;
    private JTextField jTextField3 = null;
    private JTextField jTextField4 = null;
    private JLabel jLabel7 = null;
    private JTextField jTextField5 = null;
    private JPanel jPanel9 = null;
    private JPanel jPanel10 = null;
    private JLabel jLabel8 = null;
    private JLabel jLabel9 = null;
    private JComboBox jComboBox = null;
    private JTextField jTextField1 = null;
    private JTextField jTextField6 = null;
    private JTextField jTextField7 = null;
    private JButton jButton9 = null;
    private JLabel jLabel10 = null;
    private JLabel jLabel11 = null;
    private JLabel jLabel12 = null;
    private JLabel jLabel13 = null;
    private JLabel jLabel14 = null;
    private JLabel jLabel15 = null;
    private JLabel jLabel16 = null;
    private JLabel jLabel17 = null;
    private JLabel jLabel18 = null;
    private JLabel jLabel19 = null;
    private JLabel jLabel20 = null;
    private JLabel jLabel21 = null;
    private JLabel jLabel22 = null;
    private JLabel jLabel23 = null;
    private JLabel jLabel24 = null;
    private JLabel jLabel25 = null;
    private JLabel jLabel26 = null;
    private JProgressBar jProgressBar = null;
    private JButton jButton10 = null;
    private JPanel jPanel11 = null;
    String currentUser = null;
    Thread[] threads;
    Timer stats;
    JTextArea output;
    private static TradeWSServices trade = null;
    private static ClientScenario client = null;
    private int ROUND = 4;
    private final BigDecimal ZERO = new BigDecimal(0.0);
    private JMenuItem jMenuItem2 = null;
    private JLabel jLabel27 = null;
    private JTextField jTextField12 = null;

    public ClientApp() {
        this.initialize();
    }

    public static void main(String[] args) {
        new ClientApp();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setSize(673, 577);
        this.setVisible(true);
        this.setTitle("Web Services JAX RPC Client");
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJLabel(), null);
            this.jContentPane.add((Component)this.getJPanel(), null);
            this.jContentPane.add((Component)this.getJScrollPane(), null);
            this.jContentPane.add((Component)this.getJLabel3(), null);
            this.jContentPane.add((Component)this.getJPanel1(), null);
            this.jContentPane.add((Component)this.getJPanel2(), null);
            this.jContentPane.add((Component)this.getJPanel3(), null);
            this.jContentPane.add((Component)this.getJPanel4(), null);
            this.jContentPane.add((Component)this.getJPanel5(), null);
            this.jContentPane.add((Component)this.getJPanel6(), null);
            this.jContentPane.add((Component)this.getJPanel7(), null);
            this.jContentPane.add((Component)this.getJPanel8(), null);
            this.jContentPane.add((Component)this.getJPanel11(), null);
            this.jContentPane.setBackground(new Color(244, 245, 245));
        }
        return this.jContentPane;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(11, 7, 193, 71);
            this.jLabel.setText("");
            try {
                this.jLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/tradeLogo.gif")));
            }
            catch (NullPointerException e) {
                System.out.println("ClientApp:getJLabel cannot find tradeLogo.gif");
            }
        }
        return this.jLabel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.add((Component)this.getJButton(), this.getJButton().getName());
            this.jPanel.add((Component)this.getJTextField(), null);
            this.jPanel.add((Component)this.getJLabel1(), null);
            this.jPanel.add((Component)this.getJLabel2(), null);
            this.jPanel.add((Component)this.getJTextField1(), null);
            this.jPanel.setBounds(11, 83, 287, 53);
            this.jPanel.setBackground(new Color(245, 245, 245));
            this.jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setBounds(9, 8, 68, 25);
            this.jButton.setText("Login");
            this.jButton.setFont(new Font("sansserif", 1, 10));
            this.jButton.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton.setBackground(new Color(220, 220, 220));
            this.jButton.addActionListener(new AppActionListener());
        }
        return this.jButton;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setBounds(182, 6, 93, 19);
            this.jTextField.setToolTipText("UserName");
            this.jTextField.setText("uid:0");
            this.jTextField.setName("UserName");
            this.jTextField.setFont(new Font("Arial", 0, 10));
        }
        return this.jTextField;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(91, 7, 82, 15);
            this.jLabel1.setText("Username");
            this.jLabel1.setFont(new Font("Arial", 1, 10));
            this.jLabel1.setHorizontalAlignment(4);
        }
        return this.jLabel1;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextArea());
            this.jScrollPane.setBounds(310, 8, 351, 255);
            this.jScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Results", 0, 0));
            this.jScrollPane.setToolTipText("Result Output");
            this.jScrollPane.setName("ResultPane");
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setText("");
            this.jTextArea.setFont(new Font("sansserif", 0, 10));
            this.output = this.jTextArea;
        }
        return this.jTextArea;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setSize(82, 15);
            this.jLabel2.setText("Password");
            this.jLabel2.setLocation(90, 27);
            this.jLabel2.setFont(new Font("Arial", 1, 10));
            this.jLabel2.setToolTipText("Trade User's password");
            this.jLabel2.setHorizontalAlignment(4);
        }
        return this.jLabel2;
    }

    private JTextField getJTextField1() {
        if (this.jPasswordField1 == null) {
            this.jPasswordField1 = new JPasswordField();
            this.jPasswordField1.setSize(94, 19);
            this.jPasswordField1.setLocation(181, 29);
            this.jPasswordField1.setFont(new Font("sansserif", 0, 10));
            this.jPasswordField1.setPreferredSize(new Dimension(4, 15));
            this.jPasswordField1.setText("xxx");
        }
        return this.jPasswordField1;
    }

    private JLabel getJLabel3() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(212, 13, 87, 63);
            this.jLabel3.setText("<html> Web Services Benchmark Scenario Application");
            this.jLabel3.setAutoscrolls(true);
            this.jLabel3.setFont(new Font("sansserif", 1, 12));
            this.jLabel3.setHorizontalAlignment(0);
        }
        return this.jLabel3;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(null);
            this.jPanel1.add((Component)this.getJButton1(), this.getJButton1().getName());
            this.jPanel1.setBounds(11, 142, 287, 38);
            this.jPanel1.setBackground(new Color(245, 245, 245));
            this.jPanel1.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(null);
            this.jPanel2.add((Component)this.getJButton2(), this.getJButton2().getName());
            this.jPanel2.add((Component)this.getJLabel4(), null);
            this.jPanel2.add((Component)this.getJTextField2(), null);
            this.jPanel2.setBounds(11, 185, 287, 38);
            this.jPanel2.setBackground(new Color(245, 245, 245));
            this.jPanel2.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel2;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(null);
            this.jPanel3.add((Component)this.getJButton3(), null);
            this.jPanel3.setBounds(11, 228, 287, 38);
            this.jPanel3.setBackground(new Color(245, 245, 245));
            this.jPanel3.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel3;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(null);
            this.jPanel4.add((Component)this.getJButton4(), null);
            this.jPanel4.add((Component)this.getJLabel5(), null);
            this.jPanel4.add((Component)this.getJLabel6(), null);
            this.jPanel4.add((Component)this.getJTextField3(), null);
            this.jPanel4.add((Component)this.getJTextField4(), null);
            this.jPanel4.setBounds(11, 271, 287, 53);
            this.jPanel4.setBackground(new Color(245, 245, 245));
            this.jPanel4.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel4;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(null);
            this.jPanel5.add((Component)this.getJButton5(), null);
            this.jPanel5.add((Component)this.getJLabel7(), null);
            this.jPanel5.add((Component)this.getJTextField5(), null);
            this.jPanel5.setBounds(11, 329, 287, 38);
            this.jPanel5.setBackground(new Color(245, 245, 245));
            this.jPanel5.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel5;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(null);
            this.jPanel6.add((Component)this.getJButton6(), null);
            this.jPanel6.setBounds(11, 373, 287, 38);
            this.jPanel6.setBackground(new Color(245, 245, 245));
            this.jPanel6.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel6;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setSize(141, 25);
            this.jButton1.setLocation(14, 8);
            this.jButton1.setText("Market Summary");
            this.jButton1.setFont(new Font("sansserif", 1, 10));
            this.jButton1.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton1.setBackground(new Color(220, 220, 220));
            this.jButton1.setActionCommand("MarketSummary");
            this.jButton1.addActionListener(new AppActionListener());
        }
        return this.jButton1;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(null);
            this.jPanel7.add((Component)this.getJButton7(), null);
            this.jPanel7.setBounds(11, 417, 287, 38);
            this.jPanel7.setBackground(new Color(245, 245, 245));
            this.jPanel7.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel7;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            this.jPanel8 = new JPanel();
            this.jPanel8.setLayout(null);
            this.jPanel8.add((Component)this.getJButton8(), null);
            this.jPanel8.setBounds(11, 462, 287, 38);
            this.jPanel8.setBackground(new Color(245, 245, 245));
            this.jPanel8.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.jPanel8;
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setBounds(9, 8, 68, 25);
            this.jButton2.setText("Quotes");
            this.jButton2.setFont(new Font("sansserif", 1, 10));
            this.jButton2.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton2.setBackground(new Color(220, 220, 220));
            this.jButton2.addActionListener(new AppActionListener());
        }
        return this.jButton2;
    }

    private JButton getJButton3() {
        if (this.jButton3 == null) {
            this.jButton3 = new JButton();
            this.jButton3.setSize(141, 25);
            this.jButton3.setLocation(14, 8);
            this.jButton3.setText("Account Info");
            this.jButton3.setFont(new Font("sansserif", 1, 10));
            this.jButton3.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton3.setBackground(new Color(220, 220, 220));
            this.jButton3.setActionCommand("Account");
            this.jButton3.addActionListener(new AppActionListener());
        }
        return this.jButton3;
    }

    private JButton getJButton4() {
        if (this.jButton4 == null) {
            this.jButton4 = new JButton();
            this.jButton4.setBounds(9, 8, 68, 25);
            this.jButton4.setText("Buy");
            this.jButton4.setFont(new Font("sansserif", 1, 10));
            this.jButton4.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton4.setBackground(new Color(220, 220, 220));
            this.jButton4.addActionListener(new AppActionListener());
        }
        return this.jButton4;
    }

    private JButton getJButton5() {
        if (this.jButton5 == null) {
            this.jButton5 = new JButton();
            this.jButton5.setBounds(9, 8, 68, 25);
            this.jButton5.setText("Sell");
            this.jButton5.setFont(new Font("sansserif", 1, 10));
            this.jButton5.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton5.setBackground(new Color(220, 220, 220));
            this.jButton5.addActionListener(new AppActionListener());
        }
        return this.jButton5;
    }

    private JButton getJButton6() {
        if (this.jButton6 == null) {
            this.jButton6 = new JButton();
            this.jButton6.setSize(141, 25);
            this.jButton6.setLocation(14, 8);
            this.jButton6.setText("View Orders");
            this.jButton6.setFont(new Font("sansserif", 1, 10));
            this.jButton6.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton6.setBackground(new Color(220, 220, 220));
            this.jButton6.setActionCommand("Orders");
            this.jButton6.addActionListener(new AppActionListener());
        }
        return this.jButton6;
    }

    private JButton getJButton7() {
        if (this.jButton7 == null) {
            this.jButton7 = new JButton();
            this.jButton7.setSize(141, 25);
            this.jButton7.setLocation(14, 8);
            this.jButton7.setText("View Holdings");
            this.jButton7.setFont(new Font("sansserif", 1, 10));
            this.jButton7.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton7.setBackground(new Color(220, 220, 220));
            this.jButton7.setActionCommand("Holdings");
            this.jButton7.addActionListener(new AppActionListener());
        }
        return this.jButton7;
    }

    private JButton getJButton8() {
        if (this.jButton8 == null) {
            this.jButton8 = new JButton();
            this.jButton8.setSize(141, 25);
            this.jButton8.setLocation(14, 8);
            this.jButton8.setText("Logout");
            this.jButton8.setFont(new Font("sansserif", 1, 10));
            this.jButton8.setBorder(BorderFactory.createBevelBorder(0));
            this.jButton8.setBackground(new Color(220, 220, 220));
            this.jButton8.addActionListener(new AppActionListener());
        }
        return this.jButton8;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(91, 7, 82, 15);
            this.jLabel4.setText("Symbols");
            this.jLabel4.setFont(new Font("Arial", 1, 10));
            this.jLabel4.setHorizontalAlignment(4);
        }
        return this.jLabel4;
    }

    private JLabel getJLabel5() {
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setBounds(91, 7, 82, 15);
            this.jLabel5.setText("Symbol");
            this.jLabel5.setFont(new Font("Arial", 1, 10));
            this.jLabel5.setHorizontalAlignment(4);
        }
        return this.jLabel5;
    }

    private JLabel getJLabel6() {
        if (this.jLabel6 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setSize(82, 15);
            this.jLabel6.setText("Quantity");
            this.jLabel6.setLocation(90, 27);
            this.jLabel6.setFont(new Font("Arial", 1, 10));
            this.jLabel6.setHorizontalAlignment(4);
        }
        return this.jLabel6;
    }

    private JTextField getJTextField2() {
        if (this.jTextField2 == null) {
            this.jTextField2 = new JTextField();
            this.jTextField2.setBounds(182, 6, 93, 19);
            this.jTextField2.setToolTipText("Stock symbols");
            this.jTextField2.setText("s:1");
            this.jTextField2.setName("Symbols");
            this.jTextField2.setFont(new Font("Arial", 0, 10));
        }
        return this.jTextField2;
    }

    private JTextField getJTextField3() {
        if (this.jTextField3 == null) {
            this.jTextField3 = new JTextField();
            this.jTextField3.setBounds(182, 6, 93, 19);
            this.jTextField3.setToolTipText("Stock symbols");
            this.jTextField3.setText("s:1");
            this.jTextField3.setName("symbol");
            this.jTextField3.setFont(new Font("Arial", 0, 10));
        }
        return this.jTextField3;
    }

    private JTextField getJTextField4() {
        if (this.jTextField4 == null) {
            this.jTextField4 = new JTextField();
            this.jTextField4.setBounds(182, 27, 93, 19);
            this.jTextField4.setToolTipText("Quantity of shares to purchase");
            this.jTextField4.setText("100");
            this.jTextField4.setName("quantity");
            this.jTextField4.setFont(new Font("Arial", 0, 10));
        }
        return this.jTextField4;
    }

    private JLabel getJLabel7() {
        if (this.jLabel7 == null) {
            this.jLabel7 = new JLabel();
            this.jLabel7.setBounds(91, 7, 82, 15);
            this.jLabel7.setText("Holding ID");
            this.jLabel7.setFont(new Font("Arial", 1, 10));
            this.jLabel7.setHorizontalAlignment(4);
        }
        return this.jLabel7;
    }

    private JTextField getJTextField5() {
        if (this.jTextField5 == null) {
            this.jTextField5 = new JTextField();
            this.jTextField5.setBounds(182, 6, 93, 19);
            this.jTextField5.setToolTipText("Holding ID of stock to sell");
            this.jTextField5.setText("0");
            this.jTextField5.setName("holdingID");
            this.jTextField5.setFont(new Font("Arial", 0, 10));
        }
        return this.jTextField5;
    }

    private JPanel getJPanel9() {
        if (this.jPanel9 == null) {
            this.jPanel9 = new JPanel();
            this.jPanel9.setLayout(null);
            this.jPanel9.add((Component)this.getJLabel8(), null);
            this.jPanel9.add((Component)this.getJLabel9(), null);
            this.jPanel9.add((Component)this.getJComboBox(), null);
            this.jPanel9.add((Component)this.getJTextField7(), null);
            this.jPanel9.add((Component)this.getJTextField6(), null);
            this.jPanel9.add((Component)this.getJButton9(), null);
            this.jPanel9.add((Component)this.getJLabel27(), null);
            this.jPanel9.add((Component)this.getJTextField12(), null);
            this.jPanel9.setBounds(11, 15, 347, 89);
            this.jPanel9.setBackground(new Color(245, 245, 245));
            this.jPanel9.setBorder(BorderFactory.createTitledBorder(null, "Scenario Setup", 0, 0));
            this.jPanel9.setName("jPanel9");
        }
        return this.jPanel9;
    }

    private JPanel getJPanel10() {
        if (this.jPanel10 == null) {
            this.jPanel10 = new JPanel();
            this.jPanel10.setLayout(null);
            this.jPanel10.add((Component)this.getJLabel10(), null);
            this.jPanel10.add((Component)this.getJLabel11(), null);
            this.jPanel10.add((Component)this.getJLabel12(), null);
            this.jPanel10.add((Component)this.getJLabel13(), null);
            this.jPanel10.add((Component)this.getJLabel14(), null);
            this.jPanel10.add((Component)this.getJLabel15(), null);
            this.jPanel10.add((Component)this.getJLabel16(), null);
            this.jPanel10.add((Component)this.getJLabel17(), null);
            this.jPanel10.add((Component)this.getJLabel18(), null);
            this.jPanel10.add((Component)this.getJLabel19(), null);
            this.jPanel10.add((Component)this.getJLabel20(), null);
            this.jPanel10.add((Component)this.getJLabel21(), null);
            this.jPanel10.add((Component)this.getJLabel22(), null);
            this.jPanel10.add((Component)this.getJLabel23(), null);
            this.jPanel10.add((Component)this.getJLabel24(), null);
            this.jPanel10.add((Component)this.getJLabel25(), null);
            this.jPanel10.add((Component)this.getJLabel26(), null);
            this.jPanel10.add((Component)this.getJProgressBar(), null);
            this.jPanel10.add((Component)this.getJButton10(), null);
            this.jPanel10.setBounds(9, 106, 347, 153);
            this.jPanel10.setBackground(new Color(245, 245, 245));
            this.jPanel10.setBorder(BorderFactory.createTitledBorder(null, "Scenario Statistics", 0, 0));
            this.jPanel10.setFont(new Font("sansserif", 0, 10));
        }
        return this.jPanel10;
    }

    private JLabel getJLabel8() {
        if (this.jLabel8 == null) {
            this.jLabel8 = new JLabel();
            this.jLabel8.setBounds(11, 43, 59, 13);
            this.jLabel8.setText("#Threads");
            this.jLabel8.setFont(new Font("Arial", 1, 10));
            this.jLabel8.setHorizontalAlignment(4);
        }
        return this.jLabel8;
    }

    private JLabel getJLabel9() {
        if (this.jLabel9 == null) {
            this.jLabel9 = new JLabel();
            this.jLabel9.setBounds(11, 65, 59, 13);
            this.jLabel9.setText("Iterations");
            this.jLabel9.setFont(new Font("Arial", 1, 10));
            this.jLabel9.setHorizontalAlignment(4);
        }
        return this.jLabel9;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setBounds(166, 41, 161, 16);
            this.jComboBox.setBackground(new Color(220, 220, 220));
            this.jComboBox.setFont(new Font("Arial", 1, 10));
            this.jComboBox.addItem("Get Quote");
            this.jComboBox.addItem("Get Quote - NULL");
        }
        return this.jComboBox;
    }

    private JTextField getJTextField7() {
        if (this.jTextField7 == null) {
            this.jTextField7 = new JTextField();
            this.jTextField7.setBounds(76, 43, 77, 13);
            this.jTextField7.setText("10");
            this.jTextField7.setFont(new Font("Arial", 1, 10));
            this.jTextField7.setHorizontalAlignment(4);
        }
        return this.jTextField7;
    }

    private JTextField getJTextField6() {
        if (this.jTextField6 == null) {
            this.jTextField6 = new JTextField();
            this.jTextField6.setBounds(79, 66, 77, 13);
            this.jTextField6.setText("10000");
            this.jTextField6.setFont(new Font("Arial", 1, 10));
            this.jTextField6.setHorizontalAlignment(4);
        }
        return this.jTextField6;
    }

    private JButton getJButton9() {
        if (this.jButton9 == null) {
            this.jButton9 = new JButton();
            this.jButton9.setBounds(169, 66, 149, 15);
            this.jButton9.setBackground(new Color(220, 220, 220));
            this.jButton9.setFont(new Font("Arial", 1, 10));
            this.jButton9.setText("Start Scenario!");
            this.jButton9.setActionCommand("start");
            this.jButton9.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String command = e.getActionCommand();
                    if (command.equalsIgnoreCase("start")) {
                        int numThreads = Integer.parseInt(ClientApp.this.jTextField7.getText());
                        int reqPerThread = Integer.parseInt(ClientApp.this.jTextField6.getText()) / numThreads;
                        ClientApp.this.startScenario(numThreads, reqPerThread);
                        ClientApp.this.jButton9.setText("Stop");
                        ClientApp.this.jButton9.setActionCommand("stop");
                    } else if (command.equalsIgnoreCase("stop")) {
                        ClientApp.this.stopScenario();
                        ClientApp.this.jButton9.setText("Start Scenario!");
                        ClientApp.this.jButton9.setActionCommand("start");
                    }
                }
            });
        }
        return this.jButton9;
    }

    private JLabel getJLabel10() {
        if (this.jLabel10 == null) {
            this.jLabel10 = new JLabel();
            this.jLabel10.setBounds(11, 25, 106, 13);
            this.jLabel10.setText("Avg. Req/Sec");
            this.jLabel10.setFont(new Font("Arial", 1, 10));
            this.jLabel10.setHorizontalAlignment(4);
            this.jLabel10.setToolTipText("The average requests per second");
        }
        return this.jLabel10;
    }

    private JLabel getJLabel11() {
        if (this.jLabel11 == null) {
            this.jLabel11 = new JLabel();
            this.jLabel11.setBounds(11, 50, 106, 13);
            this.jLabel11.setText("Current Req/Sec");
            this.jLabel11.setFont(new Font("Arial", 1, 10));
            this.jLabel11.setHorizontalAlignment(4);
            this.jLabel11.setToolTipText("The average request per second in the last 5 second interval");
        }
        return this.jLabel11;
    }

    private JLabel getJLabel12() {
        if (this.jLabel12 == null) {
            this.jLabel12 = new JLabel();
            this.jLabel12.setBounds(11, 75, 106, 13);
            this.jLabel12.setText("Total Requests");
            this.jLabel12.setFont(new Font("Arial", 1, 10));
            this.jLabel12.setHorizontalAlignment(4);
            this.jLabel12.setToolTipText("The total number of requests since the beginning of the scenario");
        }
        return this.jLabel12;
    }

    private JLabel getJLabel13() {
        if (this.jLabel13 == null) {
            this.jLabel13 = new JLabel();
            this.jLabel13.setBounds(11, 95, 106, 13);
            this.jLabel13.setText("Total Errors");
            this.jLabel13.setFont(new Font("Arial", 1, 10));
            this.jLabel13.setHorizontalAlignment(4);
            this.jLabel13.setToolTipText("The total number of errors since the beginning of the scenario");
        }
        return this.jLabel13;
    }

    private JLabel getJLabel14() {
        if (this.jLabel14 == null) {
            this.jLabel14 = new JLabel();
            this.jLabel14.setBounds(125, 25, 57, 15);
            this.jLabel14.setText("0.0");
            this.jLabel14.setBackground(Color.white);
            this.jLabel14.setForeground(Color.black);
            this.jLabel14.setFont(new Font("sansserif", 0, 10));
        }
        return this.jLabel14;
    }

    private JLabel getJLabel15() {
        if (this.jLabel15 == null) {
            this.jLabel15 = new JLabel();
            this.jLabel15.setBounds(125, 50, 57, 15);
            this.jLabel15.setText("0.0");
            this.jLabel15.setBackground(Color.white);
            this.jLabel15.setForeground(Color.black);
            this.jLabel15.setFont(new Font("sansserif", 0, 10));
        }
        return this.jLabel15;
    }

    private JLabel getJLabel16() {
        if (this.jLabel16 == null) {
            this.jLabel16 = new JLabel();
            this.jLabel16.setBounds(125, 75, 57, 15);
            this.jLabel16.setText("0");
            this.jLabel16.setBackground(Color.white);
            this.jLabel16.setForeground(Color.black);
            this.jLabel16.setFont(new Font("sansserif", 0, 10));
        }
        return this.jLabel16;
    }

    private JLabel getJLabel17() {
        if (this.jLabel17 == null) {
            this.jLabel17 = new JLabel();
            this.jLabel17.setBounds(125, 95, 57, 15);
            this.jLabel17.setText("0");
            this.jLabel17.setBackground(Color.white);
            this.jLabel17.setForeground(Color.black);
            this.jLabel17.setFont(new Font("sansserif", 0, 10));
        }
        return this.jLabel17;
    }

    private JLabel getJLabel18() {
        if (this.jLabel18 == null) {
            this.jLabel18 = new JLabel();
            this.jLabel18.setBounds(189, 25, 100, 13);
            this.jLabel18.setText("Avg. Resp. Time(ms)");
            this.jLabel18.setFont(new Font("Arial", 1, 10));
            this.jLabel18.setHorizontalAlignment(4);
            this.jLabel18.setToolTipText("The average response time for requests");
        }
        return this.jLabel18;
    }

    private JLabel getJLabel19() {
        if (this.jLabel19 == null) {
            this.jLabel19 = new JLabel();
            this.jLabel19.setBounds(189, 50, 100, 13);
            this.jLabel19.setText("Min. Resp. Time(ms)");
            this.jLabel19.setFont(new Font("Arial", 1, 10));
            this.jLabel19.setHorizontalAlignment(4);
            this.jLabel19.setToolTipText("The minimum response time for all requests");
        }
        return this.jLabel19;
    }

    private JLabel getJLabel20() {
        if (this.jLabel20 == null) {
            this.jLabel20 = new JLabel();
            this.jLabel20.setBounds(189, 75, 100, 13);
            this.jLabel20.setText("Max. Resp. Time(ms)");
            this.jLabel20.setFont(new Font("Arial", 1, 10));
            this.jLabel20.setHorizontalAlignment(4);
            this.jLabel20.setToolTipText("The maximum response time for all requests");
        }
        return this.jLabel20;
    }

    private JLabel getJLabel21() {
        if (this.jLabel21 == null) {
            this.jLabel21 = new JLabel();
            this.jLabel21.setBounds(189, 95, 95, 13);
            this.jLabel21.setText("Total Time (secs)");
            this.jLabel21.setFont(new Font("Arial", 1, 10));
            this.jLabel21.setHorizontalAlignment(4);
            this.jLabel21.setToolTipText("The time in seconds since the beginning of the run");
        }
        return this.jLabel21;
    }

    private JLabel getJLabel22() {
        if (this.jLabel22 == null) {
            this.jLabel22 = new JLabel();
            this.jLabel22.setBounds(293, 25, 50, 15);
            this.jLabel22.setText("0.00");
            this.jLabel22.setBackground(Color.white);
            this.jLabel22.setForeground(Color.black);
            this.jLabel22.setFont(new Font("sansserif", 0, 10));
        }
        return this.jLabel22;
    }

    private JLabel getJLabel23() {
        if (this.jLabel23 == null) {
            this.jLabel23 = new JLabel();
            this.jLabel23.setBounds(293, 50, 50, 15);
            this.jLabel23.setText("0.00");
            this.jLabel23.setBackground(Color.white);
            this.jLabel23.setForeground(Color.black);
            this.jLabel23.setFont(new Font("sansserif", 0, 10));
        }
        return this.jLabel23;
    }

    private JLabel getJLabel24() {
        if (this.jLabel24 == null) {
            this.jLabel24 = new JLabel();
            this.jLabel24.setBounds(293, 75, 50, 15);
            this.jLabel24.setText("0.00");
            this.jLabel24.setBackground(Color.white);
            this.jLabel24.setForeground(Color.black);
            this.jLabel24.setFont(new Font("sansserif", 0, 10));
        }
        return this.jLabel24;
    }

    private JLabel getJLabel25() {
        if (this.jLabel25 == null) {
            this.jLabel25 = new JLabel();
            this.jLabel25.setBounds(293, 95, 50, 15);
            this.jLabel25.setText("0");
            this.jLabel25.setBackground(Color.white);
            this.jLabel25.setForeground(Color.black);
            this.jLabel25.setFont(new Font("sansserif", 0, 10));
        }
        return this.jLabel25;
    }

    private JLabel getJLabel26() {
        if (this.jLabel26 == null) {
            this.jLabel26 = new JLabel();
            this.jLabel26.setBounds(12, 127, 98, 13);
            this.jLabel26.setText("Scenario Progress");
            this.jLabel26.setFont(new Font("Arial", 1, 10));
            this.jLabel26.setHorizontalAlignment(4);
            this.jLabel26.setToolTipText("The total number of errors since the beginning of the scenario");
        }
        return this.jLabel26;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
            this.jProgressBar.setBounds(117, 126, 145, 15);
            this.jProgressBar.setValue(0);
            this.jProgressBar.setBackground(new Color(220, 220, 220));
        }
        return this.jProgressBar;
    }

    private JButton getJButton10() {
        if (this.jButton10 == null) {
            this.jButton10 = new JButton();
            this.jButton10.setBounds(272, 125, 66, 16);
            this.jButton10.setBackground(new Color(220, 220, 220));
            this.jButton10.setFont(new Font("Arial", 1, 10));
            this.jButton10.setText("Clear");
            this.jButton10.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClientApp.this.clearScenarioStats();
                    ClientApp.this.output.append("\n\tScenario: Cleared statistics");
                }
            });
        }
        return this.jButton10;
    }

    private JPanel getJPanel11() {
        if (this.jPanel11 == null) {
            this.jPanel11 = new JPanel();
            this.jPanel11.setLayout(null);
            this.jPanel11.add((Component)this.getJPanel9(), this.getJPanel9().getName());
            this.jPanel11.add((Component)this.getJPanel9(), null);
            this.jPanel11.add((Component)this.getJPanel10(), null);
            this.jPanel11.setBounds(302, 262, 361, 262);
            this.jPanel11.setBackground(new Color(208, 208, 205));
            this.jPanel11.setBorder(BorderFactory.createTitledBorder(null, "Benchmark Scenario", 3, 0));
        }
        return this.jPanel11;
    }

    private void startScenario(int numThreads, int reqPerThread) {
        this.output.setText("Scenario: Starting " + numThreads + " threads running " + reqPerThread + " requests each");
        this.threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.threads[i] = new ClientScenario(reqPerThread);
            this.threads[i].setName("ScenarioThreads " + i);
        }
        ClientScenario.setNumThreads(numThreads);
        ClientScenario.setStartTime(0L);
        ClientScenario.setServicePort(this.getJTextField12().getText());
        String scenario = (String)this.jComboBox.getSelectedItem();
        ClientScenario.symbol = scenario.equalsIgnoreCase("Get Quote - NULL") ? null : null;
        System.out.println("Running Scenario: " + scenario + " symbol = " + ClientScenario.symbol);
        this.stats = new Timer(true);
        this.stats.scheduleAtFixedRate((TimerTask)new StatsTimerTask(), 1000L, 5000L);
        for (int i = 0; i < numThreads; ++i) {
            this.threads[i].start();
        }
    }

    private void stopScenario() {
        this.output.setText("Stopping all scenario threads");
        long numThreads = ClientScenario.getNumThreads();
        int i = 0;
        while ((long)i < numThreads) {
            ClientScenario client = (ClientScenario)this.threads[i];
            client.setStop(true);
            ++i;
        }
        this.stats.cancel();
        this.output.append("\nstopScenario:  All scenario threads and statkeeper stopped");
    }

    private void clearScenarioStats() {
        int currTotReq = 0;
        long numThreads = ClientScenario.getNumThreads();
        int i = 0;
        while ((long)i < numThreads) {
            ClientScenario client = (ClientScenario)this.threads[i];
            currTotReq = (int)((long)currTotReq + client.clearStats());
            ++i;
        }
        ClientScenario.setTotReqsAtLastInterval(currTotReq);
        ClientScenario.setStatStartTime(System.currentTimeMillis());
        this.jLabel14.setText("0");
        this.jLabel15.setText("0");
        this.jLabel22.setText("0.0");
        this.jLabel23.setText("0.0");
        this.jLabel24.setText("0.0");
    }

    TradeWSServices getTrade() throws Exception {
        ClientScenario.setServicePort(this.getJTextField12().getText());
        return ClientScenario.getTradeSingleton();
    }

    ClientScenario getClientScenario() {
        if (client == null) {
            client = new ClientScenario();
        }
        return client;
    }

    private JMenuItem getJMenuItem2() {
        if (this.jMenuItem2 == null) {
            this.jMenuItem2 = new JMenuItem();
            this.jMenuItem2.setText("Service Port URL");
            this.jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String command = e.getActionCommand();
                    if (command.equalsIgnoreCase("start")) {
                        int numThreads = Integer.parseInt(ClientApp.this.jTextField7.getText());
                        int reqPerThread = Integer.parseInt(ClientApp.this.jTextField6.getText()) / numThreads;
                        ClientApp.this.startScenario(numThreads, reqPerThread);
                        ClientApp.this.jButton9.setText("Stop");
                        ClientApp.this.jButton9.setActionCommand("stop");
                    } else if (command.equalsIgnoreCase("stop")) {
                        ClientApp.this.stopScenario();
                        ClientApp.this.jButton9.setText("Start Scenario!");
                        ClientApp.this.jButton9.setActionCommand("start");
                    }
                }
            });
        }
        return this.jMenuItem2;
    }

    private JLabel getJLabel27() {
        if (this.jLabel27 == null) {
            this.jLabel27 = new JLabel();
            this.jLabel27.setBounds(9, 17, 122, 14);
            this.jLabel27.setText("Service Port URL");
            this.jLabel27.setToolTipText("URL pointing to the concrete WSDL for the service");
            this.jLabel27.setFont(new Font("sansserif", 1, 10));
        }
        return this.jLabel27;
    }

    private JTextField getJTextField12() {
        if (this.jTextField12 == null) {
            this.jTextField12 = new JTextField();
            this.jTextField12.setBounds(138, 16, 202, 16);
            this.jTextField12.setFont(new Font("sansserif", 1, 10));
            this.jTextField12.setText(ClientScenario.getServicePort());
        }
        return this.jTextField12;
    }

    class StatsTimerTask
    extends TimerTask {
        StatsTimerTask() {
        }

        public void run() {
            long totReqs = 0L;
            long totErrs = 0L;
            long statReqs = 0L;
            long totResp = 0L;
            long totTime = 0L;
            long currTime = 0L;
            if (ClientScenario.getStartTime() == 0L) {
                ClientApp.this.clearScenarioStats();
                ClientScenario.setStartTime(System.currentTimeMillis());
                return;
            }
            for (int i = 0; i < ClientApp.this.threads.length; ++i) {
                ClientScenario thread = (ClientScenario)ClientApp.this.threads[i];
                totReqs += thread.getNumReqs();
                totErrs += thread.getNumErrs();
                totResp += thread.getTotResp();
                statReqs += thread.getNumStatReqs();
            }
            float avgResp = (float)totResp / (float)statReqs;
            long maxResp = ClientScenario.getMaxResp();
            long minResp = ClientScenario.getMinResp();
            currTime = System.currentTimeMillis();
            long totalTime = currTime - ClientScenario.getStartTime();
            long intervalTime = currTime - ClientScenario.getIntervalStartTime();
            long statTime = currTime - ClientScenario.getStatStartTime();
            ClientScenario.setIntervalStartTime(currTime);
            if (totReqs + totErrs >= ClientScenario.getTotalNumRequests()) {
                ClientApp.this.output.setText("Scenario: Run completed:" + totReqs + " requests in" + totTime / 1000L + " seconds");
                this.cancel();
                ClientApp.this.jLabel16.setText("" + totReqs);
                ClientApp.this.jLabel17.setText("" + totErrs);
                ClientApp.this.jLabel25.setText("" + totTime / 1000L);
                ClientApp.this.jButton9.setText("Start Scenario!");
                ClientApp.this.jButton9.setActionCommand("start");
                ClientApp.this.jProgressBar.setValue(100);
                return;
            }
            BigDecimal reqPerSec = new BigDecimal((double)statReqs / (double)statTime * 1000.0).setScale(2, ClientApp.this.ROUND);
            BigDecimal lastReqPerSec = new BigDecimal((double)(totReqs - ClientScenario.getTotReqsAtLastInterval()) / (double)intervalTime * 1000.0).setScale(2, ClientApp.this.ROUND);
            BigDecimal avgRespTime = new BigDecimal(avgResp).setScale(2, ClientApp.this.ROUND);
            BigDecimal maxRespBD = new BigDecimal((double)maxResp).setScale(2, ClientApp.this.ROUND);
            BigDecimal minRespBD = new BigDecimal((double)minResp).setScale(2, ClientApp.this.ROUND);
            int percentComplete = (int)(100.0 * (double)totReqs / (double)ClientScenario.getTotalNumRequests());
            ClientApp.this.jLabel14.setText(reqPerSec.toString());
            ClientApp.this.jLabel15.setText(lastReqPerSec.toString());
            ClientApp.this.jLabel16.setText("" + totReqs);
            ClientApp.this.jLabel17.setText("" + totErrs);
            ClientApp.this.jLabel22.setText(avgRespTime.toString());
            ClientApp.this.jLabel23.setText(minRespBD.toString());
            ClientApp.this.jLabel24.setText(maxRespBD.toString());
            ClientApp.this.jLabel25.setText("" + totTime / 1000L);
            ClientApp.this.jProgressBar.setValue(percentComplete);
            ClientScenario.setTotReqsAtLastInterval(totReqs);
        }
    }

    class AppActionListener
    implements ActionListener {
        AppActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String action = event.getActionCommand();
            try {
                String result = null;
                if (action.equalsIgnoreCase("Login")) {
                    String parm1 = ClientApp.this.jTextField.getText();
                    String parm2 = new String(ClientApp.this.jPasswordField1.getPassword());
                    AccountDataBean accountData = ClientApp.this.getTrade().login(parm1, parm2);
                    result = accountData.toString();
                    ClientApp.this.currentUser = accountData.getProfileID();
                } else if (action.equalsIgnoreCase("MarketSummary")) {
                    MarketSummaryDataBeanWS marketSummary = ClientApp.this.getTrade().getMarketSummary();
                    result = marketSummary.toString();
                } else if (action.equalsIgnoreCase("Quotes")) {
                    String parm1 = ClientApp.this.jTextField2.getText();
                    QuoteDataBean quoteData = ClientApp.this.getTrade().getQuote(parm1);
                    result = quoteData.toString();
                } else if (ClientApp.this.currentUser == null) {
                    result = "Error: User login is required for this operation";
                } else if (action.equalsIgnoreCase("Account")) {
                    AccountDataBean accountData = ClientApp.this.getTrade().getAccountData(ClientApp.this.currentUser);
                    AccountProfileDataBean accountProfileData = ClientApp.this.getTrade().getAccountProfileData(ClientApp.this.currentUser);
                    result = accountData.toString() + accountProfileData.toString();
                } else if (action.equalsIgnoreCase("Buy")) {
                    String parm1 = ClientApp.this.jTextField3.getText();
                    String parm2 = ClientApp.this.jTextField4.getText();
                    OrderDataBean orderData = ClientApp.this.getTrade().buy(ClientApp.this.currentUser, parm1, Double.parseDouble(parm2), 0);
                    result = orderData.toString();
                } else if (action.equalsIgnoreCase("Sell")) {
                    String parm1 = ClientApp.this.jTextField5.getText();
                    OrderDataBean orderData = ClientApp.this.getTrade().sell(ClientApp.this.currentUser, Integer.valueOf(parm1), 0);
                    result = orderData.toString();
                } else if (action.equalsIgnoreCase("Orders")) {
                    OrderDataBean[] orders = ClientApp.this.getTrade().getOrders(ClientApp.this.currentUser);
                    if (orders.length == 0) {
                        result = "No orders";
                    } else {
                        result = "";
                        for (int i = 0; i < orders.length; ++i) {
                            result = result + "\n" + orders[i].toString();
                        }
                    }
                } else if (action.equalsIgnoreCase("Holdings")) {
                    HoldingDataBean[] holdings = ClientApp.this.getTrade().getHoldings(ClientApp.this.currentUser);
                    if (holdings.length == 0) {
                        result = "No holdings";
                    } else {
                        result = "";
                        for (int i = 0; i < holdings.length; ++i) {
                            result = result + "\n" + holdings[i].toString();
                        }
                    }
                } else if (action.equalsIgnoreCase("Logout")) {
                    ClientApp.this.getTrade().logout(ClientApp.this.currentUser);
                    result = "\n\n\tUser: " + ClientApp.this.currentUser + " logged out";
                    ClientApp.this.currentUser = null;
                }
                ClientApp.this.jTextArea.setText(result);
            }
            catch (Exception e1) {
                System.out.println("ClientApp error;\n" + e1.toString());
                e1.printStackTrace();
            }
        }
    }
}

