/*
 * Decompiled with CFR 0.152.
 */
package flox.io;

import flox.def.DuplicateStateException;
import flox.def.DuplicateTransitionException;
import flox.def.NoSuchStateException;
import flox.def.Process;
import flox.def.ProcessMismatchException;
import flox.def.State;
import flox.def.Transition;
import flox.io.ActionOwner;
import flox.io.WeakState;
import flox.io.WeakTransition;
import flox.spi.ActionHandler;
import flox.spi.ActionHandlerFactory;
import flox.spi.TriggerDefinitionHandler;
import flox.spi.TriggerDefinitionHandlerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessReaderHandler
extends DefaultHandler {
    public static final String FLOX_URI = "http://flox.codehaus.org/v1/";
    private static final int ROOT = 1;
    private static final int PROCESS = 2;
    private static final int STATE = 4;
    private static final int TRANSITION = 8;
    private static final int ACTION = 16;
    private static final int TRIGGER = 32;
    private List<ActionHandlerFactory> actionHandlerFactories;
    private ActionHandler actionHandler;
    private List<TriggerDefinitionHandlerFactory> triggerDefinitionHandlerFactories;
    private TriggerDefinitionHandler triggerDefinitionHandler;
    private int delegationDepth;
    private int parseState;
    private Process process;
    private StringBuffer characters;
    private Locator locator;
    private Map states;
    private WeakState currentState;
    private WeakTransition currentTransition;
    private ActionOwner currentActionOwner;
    private WeakState firstState;

    public ProcessReaderHandler(List<ActionHandlerFactory> actionHandlerFactories, List<TriggerDefinitionHandlerFactory> triggerDefinitionHandlerFactories) {
        this.actionHandlerFactories = actionHandlerFactories;
        this.triggerDefinitionHandlerFactories = triggerDefinitionHandlerFactories;
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parseState = 1;
        this.process = null;
    }

    @Override
    public void endDocument() throws SAXException {
        this.parseState = 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.characters = new StringBuffer();
        if ((this.parseState & 1) != 0) {
            if (!uri.equals(FLOX_URI)) throw new SAXParseException("<flox:process> must be the root element (xmlns:flox=\"http://flox.codehaus.org/v1/\"", this.locator);
            if (!localName.equals("process")) throw new SAXParseException("<flox:process> must be the root element (xmlns:flox=\"http://flox.codehaus.org/v1/\"", this.locator);
            this.startProcess(attrs);
            return;
        }
        if ((this.parseState & 2) != 0) {
            if (!uri.equals(FLOX_URI)) throw new SAXParseException("<flox:process> may have <flox:state> children (xmlns:flox=\"http://flox.codehaus.org/v1/\"", this.locator);
            if (!localName.equals("state")) throw new SAXParseException("<flox:process> may have <flox:state> children (xmlns:flox=\"http://flox.codehaus.org/v1/\"", this.locator);
            this.startState(attrs);
            return;
        }
        if ((this.parseState & 4) != 0) {
            if (uri.equals(FLOX_URI)) {
                if (!localName.equals("transition")) throw new SAXParseException("only <flox:transition> is allowed within <flox:state> (xmlns:flox=\"http://flox.codehaus.org/v1/\"", this.locator);
                this.startTransition(attrs);
                return;
            }
            ActionHandlerFactory factory = this.getActionHandlerFactory(uri, localName);
            if (factory == null) throw new SAXParseException("URI '" + uri + "' not supported by current extensions", this.locator);
            if (this.currentState.getAction() != null) {
                throw new SAXParseException("State '" + this.currentState.getName() + "' already has an action defined", this.locator);
            }
            ActionHandler handler = null;
            try {
                handler = factory.newHandler(uri, localName);
            }
            catch (Exception e) {
                throw new SAXParseException(e.getMessage(), this.locator, e);
            }
            this.startAction(handler, attrs);
            return;
        }
        if ((this.parseState & 0x10) != 0) {
            this.delegateActionStartElement(uri, localName, qName, attrs);
            return;
        }
        if ((this.parseState & 0x20) != 0) {
            this.delegateTriggerDefinitionStartElement(uri, localName, qName, attrs);
            return;
        }
        if ((this.parseState & 8) == 0) return;
        ActionHandlerFactory factory = this.getActionHandlerFactory(uri, localName);
        if (factory != null) {
            if (this.currentTransition.getAction() != null) {
                throw new SAXParseException("Transition '" + this.currentTransition.getName() + "' in state '" + this.currentState.getName() + "' already has an action defined", this.locator);
            }
            ActionHandler handler = null;
            try {
                handler = factory.newHandler(uri, localName);
            }
            catch (Exception e) {
                throw new SAXParseException(e.getMessage(), this.locator, e);
            }
            this.startAction(handler, attrs);
            return;
        }
        TriggerDefinitionHandlerFactory triggerHandlerFactory = this.getTriggerDefinitionHandlerFactory(uri, localName);
        if (triggerHandlerFactory == null) throw new SAXParseException("URI '" + uri + "' not supported by current extensions", this.locator);
        if (this.currentTransition.getTriggerDefinition() != null) {
            throw new SAXParseException("Transition '" + this.currentTransition.getName() + "' in state '" + this.currentState.getName() + "' already has a trigger defined", this.locator);
        }
        TriggerDefinitionHandler triggerHandler = null;
        try {
            triggerHandler = triggerHandlerFactory.newHandler(uri, localName);
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
        this.startTriggerDefinition(triggerHandler, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ((this.parseState & 0x10) != 0) {
            if (this.delegationDepth > 0) {
                this.delegateActionEndElement(uri, localName, qName);
            }
            if (this.delegationDepth == 0) {
                this.endAction();
            }
        }
        if ((this.parseState & 0x20) != 0) {
            if (this.delegationDepth > 0) {
                this.delegateTriggerDefinitionEndElement(uri, localName, qName);
            }
            if (this.delegationDepth == 0) {
                this.endTriggerDefintion();
            }
        }
        if (uri.equals(FLOX_URI)) {
            if (localName.equals("process")) {
                this.endProcess();
            } else if (localName.equals("state")) {
                this.endState();
            } else if (localName.equals("transition")) {
                this.endTransition();
            }
        }
    }

    public void startProcess(Attributes attrs) throws SAXException {
        String name = attrs.getValue("", "name");
        if (name == null) {
            throw new SAXParseException("attribute 'name' required on <process>", this.locator);
        }
        name = name.trim();
        this.process = new Process(name);
        this.states = new HashMap();
        this.parseState = 2;
    }

    public void endProcess() throws SAXException {
        Collection states = this.states.values();
        for (WeakState weakState : states) {
            try {
                State state = this.process.newState(weakState.getName());
                state.setAction(weakState.getAction());
            }
            catch (DuplicateStateException e) {
                throw new SAXParseException(e.getMessage(), weakState.getDocumentLocator(), e);
            }
        }
        try {
            this.process.setStartState(this.firstState.getName());
        }
        catch (NoSuchStateException e) {
            throw new SAXParseException(e.getMessage(), this.firstState.getDocumentLocator(), e);
        }
        for (WeakState weakState : states) {
            List transitions = weakState.getTransitions();
            for (WeakTransition weakTransition : transitions) {
                try {
                    State origin = this.process.getState(weakState.getName());
                    State destination = this.process.getState(weakTransition.getDestination());
                    Transition transition = origin.addTransition(weakTransition.getName(), destination);
                    transition.setAction(weakTransition.getAction());
                    transition.setTriggerDefinition(weakTransition.getTriggerDefinition());
                }
                catch (NoSuchStateException e) {
                    throw new SAXParseException(e.getMessage(), weakState.getDocumentLocator(), e);
                }
                catch (DuplicateTransitionException e) {
                    throw new SAXParseException(e.getMessage(), weakState.getDocumentLocator(), e);
                }
                catch (ProcessMismatchException e) {
                    throw new SAXParseException(e.getMessage(), weakState.getDocumentLocator(), e);
                }
            }
        }
        this.parseState = 1;
    }

    public void startState(Attributes attrs) throws SAXException {
        String name = attrs.getValue("", "name");
        if (name == null) {
            throw new SAXParseException("attribute 'name' required", this.locator);
        }
        if (this.states.containsKey(name = name.trim())) {
            throw new SAXParseException("duplicate state '" + name + "'", this.locator);
        }
        WeakState state = new WeakState(this.locator, name);
        this.states.put(state.getName(), state);
        this.currentState = state;
        this.currentActionOwner = state;
        if (this.firstState == null) {
            this.firstState = state;
        }
        this.parseState = 4;
    }

    public void endState() throws SAXException {
        this.currentState = null;
        this.currentActionOwner = null;
        this.parseState = 2;
    }

    public void startAction(ActionHandler handler, Attributes attrs) throws SAXException {
        this.actionHandler = handler;
        this.actionHandler.setDocumentLocator(this.locator);
        this.actionHandler.startAction(attrs);
        this.delegationDepth = 0;
        this.parseState |= 0x10;
    }

    public void endAction() throws SAXException {
        this.actionHandler.endAction();
        this.delegationDepth = 0;
        try {
            this.currentActionOwner.setAction(this.actionHandler.getAction());
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
        this.parseState ^= 0x10;
    }

    public void startTriggerDefinition(TriggerDefinitionHandler handler, Attributes attrs) throws SAXException {
        this.triggerDefinitionHandler = handler;
        this.triggerDefinitionHandler.setDocumentLocator(this.locator);
        this.triggerDefinitionHandler.startTriggerDefinition(attrs);
        this.delegationDepth = 0;
        this.parseState = 32;
    }

    public void endTriggerDefintion() throws SAXException {
        this.triggerDefinitionHandler.endTriggerDefinition();
        this.delegationDepth = 0;
        try {
            this.currentTransition.setTriggerDefinition(this.triggerDefinitionHandler.getTriggerDefinition());
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
        this.parseState = 8;
    }

    public void delegateActionStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        ++this.delegationDepth;
        this.actionHandler.startElement(uri, localName, qName, attrs);
    }

    public void delegateActionEndElement(String uri, String localName, String qName) throws SAXException {
        this.actionHandler.endElement(uri, localName, qName);
        --this.delegationDepth;
    }

    public void delegateTriggerDefinitionStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        ++this.delegationDepth;
        this.triggerDefinitionHandler.startElement(uri, localName, qName, attrs);
    }

    public void delegateTriggerDefinitionEndElement(String uri, String localName, String qName) throws SAXException {
        this.triggerDefinitionHandler.endElement(uri, localName, qName);
        --this.delegationDepth;
    }

    public ActionHandlerFactory getActionHandlerFactory(String uri, String localName) {
        for (ActionHandlerFactory factory : this.actionHandlerFactories) {
            if (!factory.supports(uri, localName)) continue;
            return factory;
        }
        return null;
    }

    public TriggerDefinitionHandlerFactory getTriggerDefinitionHandlerFactory(String uri, String localName) {
        for (TriggerDefinitionHandlerFactory factory : this.triggerDefinitionHandlerFactories) {
            if (!factory.supports(uri, localName)) continue;
            return factory;
        }
        return null;
    }

    public void startTransition(Attributes attrs) throws SAXException {
        String name = attrs.getValue("", "name");
        String to = attrs.getValue("", "to");
        if (name == null) {
            throw new SAXParseException("attribute 'name' required", this.locator);
        }
        if (to == null) {
            throw new SAXParseException("attribute 'to' required", this.locator);
        }
        for (WeakTransition weakTransition : this.currentState.getTransitions()) {
            if (!weakTransition.getName().equals(name)) continue;
            throw new SAXParseException("duplicate transition '" + name + "' for state '" + this.currentState.getName() + "'", this.locator);
        }
        WeakTransition transition = new WeakTransition(this.locator, name, to);
        this.currentState.addTransition(transition);
        this.currentTransition = transition;
        this.currentActionOwner = transition;
        this.parseState = 8;
    }

    public void endTransition() throws SAXException {
        this.currentTransition = null;
        this.currentActionOwner = null;
        this.parseState = 4;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    public String getLocation() {
        return String.valueOf(this.locator.getLineNumber()) + ":" + this.locator.getColumnNumber();
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        super.warning(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        super.error(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        super.fatalError(e);
    }
}

