/*
 * Decompiled with CFR 0.152.
 */
package flox.def;

import flox.def.DuplicateTransitionException;
import flox.def.Process;
import flox.def.ProcessMismatchException;
import flox.def.Transition;
import flox.spi.Action;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    private Process process;
    private String name;
    private List<Transition> transitions;
    private Action action;

    protected State(Process process, String name) {
        this.process = process;
        this.name = name;
        this.transitions = new ArrayList<Transition>();
    }

    public Process getProcess() {
        return this.process;
    }

    public String getName() {
        return this.name;
    }

    public Transition addTransition(String name, State destination) throws DuplicateTransitionException, ProcessMismatchException {
        for (Transition transition : this.transitions) {
            if (!transition.getName().equals(name)) continue;
            throw new DuplicateTransitionException(this, name, destination);
        }
        if (destination.getProcess() != this.getProcess()) {
            throw new ProcessMismatchException(this, destination);
        }
        Transition transition = new Transition(name, this, destination);
        this.transitions.add(transition);
        return transition;
    }

    public List<Transition> getTransitions() {
        return Collections.unmodifiableList(this.transitions);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }
}

