/*
 * Decompiled with CFR 0.152.
 */
package flox;

import flox.DuplicateProcessException;
import flox.NoSuchProcessException;
import flox.ProcessLoader;
import flox.TransitionNotManualException;
import flox.Workflow;
import flox.WorkflowEngine;
import flox.WorkflowIntegrityException;
import flox.def.AutomaticTriggerDefinition;
import flox.def.ManualTriggerDefinition;
import flox.def.NoSuchStateException;
import flox.def.Process;
import flox.def.State;
import flox.def.Transition;
import flox.def.TriggerDefinition;
import flox.model.NoSuchModelObjectException;
import flox.model.StateModel;
import flox.model.StateModelDao;
import flox.model.WorkflowModel;
import flox.model.WorkflowModelDao;
import flox.spi.Action;
import flox.spi.ManualTriggerEvaluator;
import flox.spi.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkflowEngine
implements InitializingBean,
WorkflowEngine {
    private WorkflowModelDao workflowModelDao;
    private StateModelDao stateModelDao;
    private ProcessLoader processLoader;
    private Map processes = new HashMap();
    private ManualTriggerEvaluator manualTriggerEvaluator;

    public WorkflowModelDao getWorkflowModelDao() {
        return this.workflowModelDao;
    }

    public void setWorkflowModelDao(WorkflowModelDao workflowModelDao) {
        this.workflowModelDao = workflowModelDao;
    }

    public StateModelDao getStateModelDao() {
        return this.stateModelDao;
    }

    public void setStateModelDao(StateModelDao stateModelDao) {
        this.stateModelDao = stateModelDao;
    }

    public ManualTriggerEvaluator getManualTriggerEvaluator() {
        return this.manualTriggerEvaluator;
    }

    public void setManualTriggerEvaluator(ManualTriggerEvaluator manualTriggerEvaluator) {
        this.manualTriggerEvaluator = manualTriggerEvaluator;
    }

    public ProcessLoader getProcessLoader() {
        return this.processLoader;
    }

    public void setProcessLoader(ProcessLoader processLoader) {
        this.processLoader = processLoader;
    }

    @Override
    public void addProcess(Process process) throws DuplicateProcessException {
        if (this.processes.containsKey(process.getName())) {
            throw new DuplicateProcessException(this, process);
        }
        this.processes.put(process.getName(), process);
    }

    Process getProcess(String name) throws NoSuchProcessException {
        Process process = (Process)this.processes.get(name);
        if (process == null) {
            throw new NoSuchProcessException(this, name);
        }
        return process;
    }

    @Override
    public Collection getProcessNames() {
        return this.processes.keySet();
    }

    @Override
    public Workflow newWorkflow(String processName) throws NoSuchProcessException {
        Process process = this.getProcess(processName);
        WorkflowModel workflowModel = new WorkflowModel();
        this.getWorkflowModelDao().save(workflowModel);
        Workflow workflow = new Workflow(this, process, workflowModel);
        this.enterStartState(workflow);
        while (this.attemptTransition(workflow)) {
        }
        return workflow;
    }

    @Override
    public boolean attemptManualTransition(Workflow workflow, Transition transition) throws TransitionNotManualException {
        if (!(transition.getTriggerDefinition() instanceof ManualTriggerDefinition)) {
            throw new TransitionNotManualException(workflow, transition);
        }
        if (this.attemptTransition(workflow, transition)) {
            while (this.attemptTransition(workflow)) {
            }
            return true;
        }
        return false;
    }

    private void enterStartState(Workflow workflow) {
        Process process = workflow.getProcess();
        State startState = process.getStartState();
        Date now = new Date();
        this.enterState(now, workflow, startState);
    }

    private void enterState(Date now, Workflow workflow, State state) {
        StateModel stateModel = new StateModel();
        stateModel.setName(state.getName());
        stateModel.setEnteredDate(now);
        stateModel.setWorkflow(workflow.getModel());
        this.getStateModelDao().save(stateModel);
        Action action = state.getAction();
        if (action != null) {
            try {
                action.execute(workflow, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (state.getTransitions().isEmpty()) {
            this.exitState(now, workflow);
        }
    }

    private void exitState(Date now, Workflow workflow) {
        try {
            StateModel stateModel = this.getStateModelDao().getCurrentState(workflow.getModel());
            stateModel.setExitedDate(now);
            this.getStateModelDao().save(stateModel);
        }
        catch (NoSuchModelObjectException e) {
            throw new WorkflowIntegrityException(workflow, (Throwable)e);
        }
    }

    private boolean attemptTransition(Workflow workflow) {
        State state = workflow.getCurrentState();
        if (state == null) {
            return false;
        }
        List<Transition> transitions = state.getTransitions();
        for (Transition transition : transitions) {
            boolean result;
            TriggerDefinition triggerDef = transition.getTriggerDefinition();
            if (triggerDef != null && !(triggerDef instanceof AutomaticTriggerDefinition) || !(result = this.attemptTransition(workflow, transition))) continue;
            return true;
        }
        return false;
    }

    private boolean attemptTransition(Workflow workflow, Transition transition) {
        State state = workflow.getCurrentState();
        List<Transition> transitions = state.getTransitions();
        if (!transitions.contains(transition)) {
            throw new WorkflowIntegrityException(workflow, null);
        }
        TriggerDefinition triggerDef = transition.getTriggerDefinition();
        Predicate predicate = transition.getPredicate();
        if (predicate == null || predicate.evaluate(workflow, null)) {
            this.followTransition(workflow, transition);
            return true;
        }
        return false;
    }

    private void followTransition(Workflow workflow, Transition transition) {
        Date now = new Date();
        this.exitState(now, workflow);
        Action action = transition.getAction();
        if (action != null) {
            try {
                action.execute(workflow, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.enterState(now, workflow, transition.getDestination());
    }

    @Override
    public Workflow getWorkflow(String processName, Class flowedObjectClass, Criterion flowedObjectCriterion) throws NoSuchProcessException, NoSuchModelObjectException {
        Process process = this.getProcess(processName);
        WorkflowModel workflowModel = this.getWorkflowModelDao().get(processName, flowedObjectClass, flowedObjectCriterion);
        Workflow workflow = new Workflow(this, process, workflowModel);
        return workflow;
    }

    @Override
    public List getWorkflows(String processName) throws NoSuchProcessException {
        Process process = this.getProcess(processName);
        return this.getWorkflowModelDao().getAll(processName);
    }

    State getCurrentState(Workflow workflow) {
        try {
            StateModel model = this.getStateModelDao().getCurrentState(workflow.getModel());
            State state = workflow.getProcess().getState(model.getName());
            return state;
        }
        catch (NoSuchStateException e) {
            throw new WorkflowIntegrityException(workflow, (Throwable)e);
        }
        catch (NoSuchModelObjectException e) {
            return null;
        }
    }

    List<Transition> getCurrentTransitions(Workflow workflow) {
        State state = this.getCurrentState(workflow);
        return state.getTransitions();
    }

    @Override
    public List<Transition> getAvailableCurrentTransitions(Workflow workflow) {
        LinkedList<Transition> available = new LinkedList<Transition>(this.getCurrentTransitions(workflow));
        Iterator transIter = available.iterator();
        while (transIter.hasNext()) {
            Transition transition = (Transition)transIter.next();
            if (transition.getPredicate().evaluate(workflow, null)) continue;
            transIter.remove();
        }
        return Collections.unmodifiableList(available);
    }

    @Override
    public List<StateModel> getStateSequence(Workflow workflow) {
        return this.getStateModelDao().getStateSequence(workflow.getModel());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.processLoader != null) {
            this.processLoader.loadProcesses(this);
        }
    }
}

