/*
 * Decompiled with CFR 0.152.
 */
package flox;

import flox.DuplicateProcessException;
import flox.ProcessLoader;
import flox.WorkflowEngine;
import flox.def.Process;
import flox.io.ProcessReader;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ClassPathProcessLoader
implements ProcessLoader {
    private String prefix;
    private List processNames;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List getProcessNames() {
        return this.processNames;
    }

    public void setProcessNames(List processNames) {
        this.processNames = processNames;
    }

    public void loadProcesses(WorkflowEngine workflowEngine) {
        for (String name : this.processNames) {
            try {
                this.loadProcess(workflowEngine, name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (DuplicateProcessException e) {
                e.printStackTrace();
            }
        }
    }

    protected void loadProcess(WorkflowEngine workflowEngine, String name) throws IOException, ParserConfigurationException, SAXException, DuplicateProcessException {
        URL url;
        if (this.prefix != null) {
            name = String.valueOf(this.prefix) + "/" + name;
        }
        if ((url = this.getClass().getClassLoader().getResource(name)) != null) {
            ProcessReader reader = new ProcessReader();
            Process process = reader.read(url);
            workflowEngine.addProcess(process);
        }
    }
}

