/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.util;

import org.apache.excalibur.util.CPUParser;

public final class SystemUtil {
    private static final int m_processors;
    private static final String m_cpuInfo;
    private static final String m_architecture;
    private static final String m_osName;
    private static final String m_osVersion;

    private static String stripWhitespace(String mosname) {
        StringBuffer sb = new StringBuffer();
        int size = mosname.length();
        for (int i = 0; i < size; ++i) {
            char ch = mosname.charAt(i);
            if (ch == '\t' || ch == '\r' || ch == '\n' || ch == '\b') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private SystemUtil() {
    }

    public static final int numProcessors() {
        return m_processors;
    }

    public static final String cpuInfo() {
        return m_cpuInfo;
    }

    public static final String architecture() {
        return m_architecture;
    }

    public static final String operatingSystem() {
        return m_osName;
    }

    public static final String osVersion() {
        return m_osVersion;
    }

    static {
        m_architecture = System.getProperty("os.arch");
        m_osName = System.getProperty("os.name");
        m_osVersion = System.getProperty("os.version");
        int procs = 0;
        String info = "";
        try {
            String name = "org.apache.excalibur.util.system." + SystemUtil.stripWhitespace(m_osName);
            Class<?> klass = Class.forName(name);
            CPUParser parser = (CPUParser)klass.newInstance();
            procs = parser.numProcessors();
            info = parser.cpuInfo();
        }
        catch (Exception e) {
            String proc = System.getProperty("os.arch.cpus", "1");
            info = System.getProperty("os.arch.info", m_architecture + " Family n, Model n, Stepping n, Undeterminable");
            procs = Integer.parseInt(proc);
        }
        m_processors = procs;
        m_cpuInfo = info;
    }
}

