/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.mpool;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.apache.excalibur.mpool.ManagablePool;
import org.apache.excalibur.mpool.ObjectFactory;
import org.apache.excalibur.mpool.Pool;
import org.apache.excalibur.mpool.PoolUtil;

public final class VariableSizePool
implements Pool,
Disposable,
ManagablePool {
    private boolean m_disposed = false;
    private final Buffer m_buffer;
    private final ObjectFactory m_factory;
    private final long m_key;

    public VariableSizePool(ObjectFactory factory, int size) throws Exception {
        this(factory, size, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableSizePool(ObjectFactory factory, int size, long key) throws Exception {
        this.m_buffer = new UnboundedFifoBuffer(size);
        this.m_factory = factory;
        this.m_key = key;
        ObjectFactory objectFactory = this.m_factory;
        synchronized (objectFactory) {
            for (int i = 0; i < size; ++i) {
                this.m_buffer.add(this.newInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire() throws Exception {
        if (this.m_disposed) {
            throw new IllegalStateException("Cannot get an object from a disposed pool");
        }
        Object object = null;
        Buffer buffer = this.m_buffer;
        synchronized (buffer) {
            if (this.m_buffer.size() > 0) {
                object = this.m_buffer.remove();
            }
        }
        if (null == object) {
            object = this.newInstance();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object pooledObject) {
        if (this.m_disposed) {
            try {
                this.m_factory.dispose(pooledObject);
            }
            catch (Exception exception) {}
        } else {
            Buffer buffer = this.m_buffer;
            synchronized (buffer) {
                this.m_buffer.add(PoolUtil.recycle(pooledObject));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance() throws Exception {
        ObjectFactory objectFactory = this.m_factory;
        synchronized (objectFactory) {
            return this.m_factory.newInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.m_disposed = true;
        Buffer buffer = this.m_buffer;
        synchronized (buffer) {
            while (!this.m_buffer.isEmpty()) {
                try {
                    this.m_factory.dispose(this.m_buffer.remove());
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink(int byNum, long key) throws IllegalAccessException {
        if (this.m_key < 0L || this.m_key != key) {
            throw new IllegalAccessException();
        }
        Buffer buffer = this.m_buffer;
        synchronized (buffer) {
            int num = Math.min(byNum, this.m_buffer.size());
            for (int i = 0; i < num; ++i) {
                try {
                    this.m_factory.dispose(this.m_buffer.remove());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grow(int byNum, long key) throws IllegalAccessException {
        if (this.m_key < 0L || this.m_key != key) {
            throw new IllegalAccessException();
        }
        Buffer buffer = this.m_buffer;
        synchronized (buffer) {
            for (int i = 0; i < byNum; ++i) {
                try {
                    this.m_buffer.add(this.newInstance());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(long key) throws IllegalAccessException {
        if (this.m_key < 0L || this.m_key != key) {
            throw new IllegalAccessException();
        }
        Buffer buffer = this.m_buffer;
        synchronized (buffer) {
            return this.m_buffer.size();
        }
    }
}

