/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource.ids;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.ids.AbstractDataSourceBlockIdGenerator;
import org.apache.avalon.excalibur.datasource.ids.IdException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class TableIdGenerator
extends AbstractDataSourceBlockIdGenerator {
    private String m_table;
    private String m_tableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object allocateIdBlock(int blockSize, boolean useBigDecimals) throws IdException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Allocating a new block of " + blockSize + " ids for key_table " + this.m_tableName + ".");
        }
        try {
            conn = this.getConnection();
            try {
                autoCommit = conn.getAutoCommit();
                stmt = conn.createStatement();
                try {
                    tries = 0;
                    if (true) ** GOTO lbl20
                }
                catch (Throwable var13_24) {
                    var14_20 = null;
                    stmt.close();
                    throw var13_24;
                }
                {
                    while (true) {
                        if (!autoCommit) {
                            conn.rollback();
                        }
                        ++tries;
lbl20:
                        // 2 sources

                        if (tries >= 50) {
                            this.getLogger().error("Unable to allocate a block of Ids.  Too many retries.");
                            var7_9 = null;
                            var14_19 = null;
                            break;
                        }
                        query = "SELECT next_id FROM " + this.m_table + " WHERE table_name = '" + this.m_tableName + "'";
                        rs = stmt.executeQuery(query);
                        if (!rs.next()) {
                            msg = "Unable to allocate a block of Ids, no row with table_name='" + this.m_tableName + "' exists in the " + this.m_table + " table.";
                            this.getLogger().error(msg);
                            if (!autoCommit) {
                                conn.rollback();
                            }
                            throw new IdException(msg);
                        }
                        if (useBigDecimals) {
                            oldNextId = rs.getBigDecimal(1);
                            newNextId /* !! */  = oldNextId.add(new BigDecimal((double)blockSize));
                            nextId /* !! */  = oldNextId;
                        } else {
                            oldNextId = rs.getLong(1);
                            newNextId /* !! */  = new Long(oldNextId + (long)blockSize);
                            nextId /* !! */  = new Long(oldNextId);
                        }
                        try {
                            query = "UPDATE " + this.m_table + " SET next_id = '" + newNextId /* !! */  + "' " + " WHERE table_name = '" + this.m_tableName + "' " + "   AND next_id = '" + nextId /* !! */  + "'";
                            updated = stmt.executeUpdate(query);
                            if (updated >= 1) {
                                if (!autoCommit) {
                                    conn.commit();
                                }
                                var12_17 /* !! */  = nextId /* !! */ ;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (SQLException e) {
                            if (!this.getLogger().isDebugEnabled()) continue;
                            this.getLogger().debug("Encountered an exception attempting to update the " + this.m_table + " table.  May be a transaction confict.  " + "Trying again: " + e.getMessage());
                            continue;
                        }
                        var14_18 = null;
                        stmt.close();
                        var16_21 = null;
                        conn.close();
                        return var12_17 /* !! */ ;
lbl-1000:
                        // 1 sources

                        {
                            if (!this.getLogger().isDebugEnabled()) continue;
                            this.getLogger().debug("Update resulted in no rows being changed.");
                            continue;
                        }
                        break;
                    }
                }
                stmt.close();
                var16_22 = null;
                conn.close();
                return var7_9;
            }
            catch (Throwable var15_25) {
                var16_23 = null;
                conn.close();
                throw var15_25;
            }
        }
        catch (SQLException e) {
            msg = "Unable to allocate a block of Ids.";
            this.getLogger().error(msg, (Throwable)e);
            throw new IdException(msg, e);
        }
    }

    protected BigDecimal allocateBigDecimalIdBlock(int blockSize) throws IdException {
        return (BigDecimal)this.allocateIdBlock(blockSize, true);
    }

    protected long allocateLongIdBlock(int blockSize) throws IdException {
        Long id = (Long)this.allocateIdBlock(blockSize, false);
        return id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.m_table = configuration.getAttribute("table", "ids");
        this.m_tableName = configuration.getAttribute("key-table", "id");
    }
}

