/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource.ids;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.ids.AbstractDataSourceIdGenerator;
import org.apache.avalon.excalibur.datasource.ids.IdException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class SequenceIdGenerator
extends AbstractDataSourceIdGenerator {
    private String m_query;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BigDecimal getNextBigDecimalIdInner() throws IdException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Requesting an Id using query: " + this.m_query);
        }
        try {
            BigDecimal bigDecimal;
            Connection conn = this.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.m_query);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = "Query for Id did not return a value";
                    this.getLogger().error(msg);
                    throw new IdException(msg);
                }
                bigDecimal = rs.getBigDecimal(1);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            return bigDecimal;
        }
        catch (SQLException e) {
            throw new IdException("Unable to allocate an Id", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getNextLongIdInner() throws IdException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Requesting an Id using query: " + this.m_query);
        }
        try {
            long l;
            Connection conn = this.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.m_query);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) {
                    String msg = "Query for Id did not return a value";
                    this.getLogger().error(msg);
                    throw new IdException(msg);
                }
                l = rs.getLong(1);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            return l;
        }
        catch (SQLException e) {
            String msg = "Unable to allocate an Id";
            this.getLogger().error(msg);
            throw new IdException(msg);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.m_query = configuration.getChild("query").getValue();
    }
}

