/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource.cluster;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.datasource.NoValidConnectionException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public abstract class AbstractDataSourceCluster
extends AbstractLogEnabled
implements Serviceable,
Configurable,
Initializable,
Disposable,
ThreadSafe {
    protected int m_size;
    private String[] m_dataSourceNames;
    private ServiceSelector m_dbSelector;
    private DataSourceComponent[] m_dataSources;

    public int getClusterSize() {
        return this.m_size;
    }

    public Connection getConnectionForIndex(int index) throws SQLException {
        if (index < 0 || index >= this.m_size) {
            throw new NoValidConnectionException("index (" + index + ") must be in the range 0 to " + (this.m_size - 1));
        }
        return this.m_dataSources[index].getConnection();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_dbSelector = (ServiceSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_size = configuration.getAttributeAsInteger("size");
        if (this.m_size < 1) {
            throw new ConfigurationException("Invalid value (" + this.m_size + ") for size attribute.");
        }
        this.m_dataSourceNames = new String[this.m_size];
        Configuration[] dataSourceConfigs = configuration.getChildren("dbpool");
        int i = 0;
        while (i < dataSourceConfigs.length) {
            int index = dataSourceConfigs[i].getAttributeAsInteger("index");
            if (index < 0 || index >= this.m_size) {
                throw new ConfigurationException("The dbpool with index=\"" + index + "\" is invalid.  Index must be in the range 0 to " + (this.m_size - 1));
            }
            if (this.m_dataSourceNames[index] != null) {
                throw new ConfigurationException("Only one dbpool with index=\"" + index + "\" can be defined.");
            }
            this.m_dataSourceNames[index] = dataSourceConfigs[i].getValue();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_dataSourceNames.length) {
            if (this.m_dataSourceNames[i2] == null) {
                throw new ConfigurationException("Expected a dbpool with index=\"" + i2 + "\"");
            }
            ++i2;
        }
    }

    public void initialize() throws Exception {
        this.m_dataSources = new DataSourceComponent[this.m_size];
        int i = 0;
        while (i < this.m_dataSourceNames.length) {
            this.m_dataSources[i] = (DataSourceComponent)this.m_dbSelector.select((Object)this.m_dataSourceNames[i]);
            ++i;
        }
    }

    public void dispose() {
        if (this.m_dbSelector != null) {
            if (this.m_dataSources != null) {
                int i = 0;
                while (i < this.m_dataSources.length) {
                    if (this.m_dataSources[i] != null) {
                        this.m_dbSelector.release((Object)this.m_dataSources[i]);
                    }
                    ++i;
                }
                this.m_dataSources = null;
            }
            this.m_dbSelector = null;
        }
    }
}

