/*
 * Decompiled with CFR 0.152.
 */
package eu.wiegandt.nicklas.simpleexcelimexporter;

import eu.wiegandt.nicklas.simpleexcelimexporter.ExcelImExporterField;
import eu.wiegandt.nicklas.simpleexcelimexporter.annotations.ExcelField;
import eu.wiegandt.nicklas.simpleexcelimexporter.annotations.ExcelTable;
import eu.wiegandt.nicklas.simpleexcelimexporter.api.DataClass;
import eu.wiegandt.nicklas.simpleexcelimexporter.api.DataController;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExportErrorTypes;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterError;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterException;
import eu.wiegandt.nicklas.simpleexcelimexporter.utils.LocalFileLoaderUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExcelTableManager {
    private static final String ERROR_TEXT_CANT_FIND_MAPPING_FILE = "Can't find the given mapping File.";
    private static final String ERROR_TEXT_EXCE_TABLE_IS_NULL = "The DataClass can't be null!";
    private static final String ERROR_TEXT_NOT_A_EXCEL_TABLE = "The given class isn't aviable for the excel im- export. It needs the annotation @ExcelTable.";
    private static final String ERROR_TEXT_WRONG_DATACONTROLLER = "The data controller is wrong. It cant use this data class.";
    private static final Logger LOG = LogManager.getLogger(ExcelTableManager.class);
    private static final String NOT_EVERY_NEEDED_GETTER_EXISTS_PATTERN = "Not every needed getter exists. Following getters are needed: [%s]";
    private static final String NOT_EVERY_NEEDED_SETTER_EXISTS_PATTERN = "Not every needed setter exists. Following setters are needed: [%s]";
    private final Class<? extends DataClass> excelTableClass;
    private String tableName;

    public ExcelTableManager(Class<? extends DataClass> aExcelTable) {
        this.checkExcelTableNotNull(aExcelTable);
        this.excelTableClass = aExcelTable;
        this.checkIsAnnotatedWithExcelTable(aExcelTable);
        this.checkIfMappingFileExistsIfGiven(aExcelTable);
        this.checkIfDataControllerCanHandleDataClass(aExcelTable);
        this.checkIfHasSetterMethodsForImportFields(aExcelTable);
        this.checkIfHasGetterMethodsForExportFields(aExcelTable);
    }

    public Class<? extends DataController<? extends DataClass>> getDataController() {
        return this.excelTableClass.getAnnotation(ExcelTable.class).datacontroller();
    }

    public Optional<Field> getExcelField(String aFieldName) {
        return this.findExcelField(aFieldName, this.getExcelFields());
    }

    public Collection<Field> getExcelFields() {
        return Arrays.asList(this.excelTableClass.getDeclaredFields()).parallelStream().filter(field -> field.isAnnotationPresent(ExcelField.class)).collect(Collectors.toList());
    }

    public Class<? extends DataClass> getExcelTableClass() {
        return this.excelTableClass;
    }

    public Collection<Field> getExportableExcelFields() {
        return this.getExcelFields().parallelStream().filter(field -> field.getAnnotation(ExcelField.class).exportable()).collect(Collectors.toList());
    }

    public Collection<Field> getImportableExcelFields() {
        return this.getExcelFields().stream().filter(field -> field.getAnnotation(ExcelField.class).importable()).collect(Collectors.toList());
    }

    public Collection<Field> getImportableRequiredExcelFields() {
        return this.getImportableExcelFields().parallelStream().filter(field -> field.getAnnotation(ExcelField.class).requiredField()).collect(Collectors.toList());
    }

    public Path getMappingFilePath() {
        return LocalFileLoaderUtil.getLocalFile(this.excelTableClass.getAnnotation(ExcelTable.class).mappingFile());
    }

    public String getTableName() {
        if (this.tableName == null) {
            String annotatedTableName = this.excelTableClass.getAnnotation(ExcelTable.class).tableName();
            this.tableName = annotatedTableName.isEmpty() ? this.excelTableClass.getSimpleName() : annotatedTableName;
        }
        return this.tableName;
    }

    public boolean hasImportableField(String aFieldName) {
        return this.getImportableExcelField(aFieldName).isPresent();
    }

    public boolean hasMappingFilePath() {
        return Files.exists(this.getMappingFilePath(), new LinkOption[0]) && !Files.isDirectory(this.getMappingFilePath(), new LinkOption[0]);
    }

    private void checkExcelTableNotNull(Class<? extends DataClass> aExcelTable) {
        if (aExcelTable == null) {
            throw new IllegalArgumentException(ERROR_TEXT_EXCE_TABLE_IS_NULL);
        }
    }

    private void checkIfDataControllerCanHandleDataClass(Class<? extends DataClass> aExcelTable) {
        try {
            if (!aExcelTable.getAnnotation(ExcelTable.class).datacontroller().getMethod("getDataClass", new Class[0]).invoke(aExcelTable.getAnnotation(ExcelTable.class).datacontroller().newInstance(), new Object[0]).equals(aExcelTable)) {
                throw new IllegalArgumentException(ERROR_TEXT_WRONG_DATACONTROLLER);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            LOG.debug(ERROR_TEXT_WRONG_DATACONTROLLER, (Throwable)exception);
            throw new IllegalArgumentException(ERROR_TEXT_WRONG_DATACONTROLLER);
        }
    }

    private void checkIfHasGetterMethodsForExportFields(Class<? extends DataClass> aExcelTable) {
        ArrayList<String> neededNotFoundGetterName = new ArrayList<String>();
        Boolean hasGetterMethods = true;
        List existingMethodNames = Arrays.asList(aExcelTable.getMethods()).parallelStream().map(Method::getName).collect(Collectors.toList());
        for (Field field : this.getExportableExcelFields()) {
            String neededGetterName;
            try {
                neededGetterName = new ExcelImExporterField(null, null, field.getName()).getGetterMethodName(this.excelTableClass);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                LOG.fatal(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), (Throwable)exception);
                ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR);
                throw new IllegalStateException(new ExcelImExporterException(errorMessage));
            }
            boolean isExistNeededGetterName = existingMethodNames.contains(neededGetterName);
            if (!isExistNeededGetterName) {
                neededNotFoundGetterName.add(neededGetterName);
            }
            hasGetterMethods = isExistNeededGetterName && hasGetterMethods != false;
        }
        if (!hasGetterMethods.booleanValue()) {
            throw new IllegalArgumentException(String.format(NOT_EVERY_NEEDED_GETTER_EXISTS_PATTERN, String.join((CharSequence)", ", neededNotFoundGetterName)));
        }
    }

    private void checkIfHasSetterMethodsForImportFields(Class<? extends DataClass> aExcelTable) {
        ArrayList<String> neededNotFoundSetterName = new ArrayList<String>();
        Boolean hasSetterMethods = true;
        List existingMethodNames = Arrays.asList(aExcelTable.getMethods()).parallelStream().map(Method::getName).collect(Collectors.toList());
        for (Field field : this.getImportableExcelFields()) {
            String neededSetterName;
            try {
                neededSetterName = new ExcelImExporterField(null, null, field.getName()).getSetterMethodName(this.excelTableClass);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                LOG.fatal(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), (Throwable)exception);
                ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR);
                throw new IllegalStateException(new ExcelImExporterException(errorMessage));
            }
            boolean isExistNeededSetterName = existingMethodNames.contains(neededSetterName);
            if (!isExistNeededSetterName) {
                neededNotFoundSetterName.add(neededSetterName);
            }
            hasSetterMethods = isExistNeededSetterName && hasSetterMethods != false;
        }
        if (!hasSetterMethods.booleanValue()) {
            throw new IllegalArgumentException(String.format(NOT_EVERY_NEEDED_SETTER_EXISTS_PATTERN, String.join((CharSequence)", ", neededNotFoundSetterName)));
        }
    }

    private void checkIfMappingFileExistsIfGiven(Class<? extends DataClass> aExcelTable) {
        if (!aExcelTable.getAnnotation(ExcelTable.class).mappingFile().isEmpty() && !Files.exists(LocalFileLoaderUtil.getLocalFile(aExcelTable.getAnnotation(ExcelTable.class).mappingFile()), new LinkOption[0])) {
            LOG.debug("Mapping file path: " + LocalFileLoaderUtil.getLocalFile(aExcelTable.getAnnotation(ExcelTable.class).mappingFile()));
            throw new IllegalArgumentException(ERROR_TEXT_CANT_FIND_MAPPING_FILE);
        }
    }

    private void checkIsAnnotatedWithExcelTable(Class<? extends DataClass> aExcelTable) {
        if (!aExcelTable.isAnnotationPresent(ExcelTable.class)) {
            throw new IllegalArgumentException(ERROR_TEXT_NOT_A_EXCEL_TABLE);
        }
    }

    private Optional<Field> findExcelField(String aFieldName, Collection<Field> aFields) {
        return aFields.parallelStream().filter(field -> field.getName().equalsIgnoreCase(aFieldName)).findFirst();
    }

    private Optional<Field> getImportableExcelField(String aFieldName) {
        return this.findExcelField(aFieldName, this.getImportableExcelFields());
    }
}

