/*
 * Decompiled with CFR 0.152.
 */
package eu.wiegandt.nicklas.simpleexcelimexporter;

import eu.wiegandt.nicklas.simpleexcelimexporter.AbstractExcelImExporter;
import eu.wiegandt.nicklas.simpleexcelimexporter.ExcelImExporterField;
import eu.wiegandt.nicklas.simpleexcelimexporter.ExcelTableManager;
import eu.wiegandt.nicklas.simpleexcelimexporter.api.DataClass;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExportErrorTypes;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExportWarningTypes;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterError;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterException;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterWarning;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.BidiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelImporter
extends AbstractExcelImExporter {
    private static final Logger LOG = LogManager.getLogger(ExcelImporter.class);
    private final Path excelFilePath;
    private boolean multiTableMode = false;
    private String tableName = "";

    @Deprecated
    public ExcelImporter(String aExcelFilePath) {
        this(Paths.get(aExcelFilePath, new String[0]));
    }

    public ExcelImporter(Path aExcelFilePath) {
        this.checkPath(aExcelFilePath);
        this.excelFilePath = aExcelFilePath;
    }

    public static boolean addTableManager(ExcelTableManager aTableManager) {
        if (aTableManager.getImportableExcelFields().isEmpty()) {
            throw new IllegalArgumentException("The table has no importable fields.");
        }
        return tableManagers.add(aTableManager);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void importExcel() throws ExcelImExporterException {
        try {
            this.updateProgress();
            if (this.isMultiTableMode()) {
                this.importExcelTables();
            } else {
                this.importExcelTable(this.getTableName());
            }
        }
        catch (EncryptedDocumentException exception) {
            LOG.fatal(ExcelImExportErrorTypes.ENCRYPTED_DOCUMENT.getMessageTemplate(), (Throwable)exception);
            ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.ENCRYPTED_DOCUMENT);
            throw new ExcelImExporterException(errorMessage);
        }
    }

    public boolean isMultiTableMode() {
        return this.multiTableMode;
    }

    public void setMultiTableMode(boolean aMultiTableMode) {
        this.multiTableMode = aMultiTableMode;
    }

    public void setTableName(String aTableName) {
        this.tableName = aTableName;
    }

    private void checkHasRequiredFields(ExcelTableManager aTableManager, Collection<ExcelImExporterField> aFields) throws ExcelImExporterException {
        Collection requiredFieldNames = aTableManager.getImportableRequiredExcelFields().parallelStream().map(Field::getName).collect(Collectors.toList());
        boolean hasRequiredFields = aFields.parallelStream().map(ExcelImExporterField::getFieldName).collect(Collectors.toList()).containsAll(requiredFieldNames);
        if (!hasRequiredFields) {
            ExcelImExporterError notAllRequiredFieldsError = new ExcelImExporterError(ExcelImExportErrorTypes.NOT_ALL_REQUIRED_FIELDS, String.format(ExcelImExportErrorTypes.NOT_ALL_REQUIRED_FIELDS.getMessageTemplate(), String.join((CharSequence)", ", requiredFieldNames)));
            throw new ExcelImExporterException(notAllRequiredFieldsError);
        }
    }

    private void checkPath(Path aExcelFilePath) {
        if (!Files.exists(aExcelFilePath, new LinkOption[0])) {
            throw new InvalidParameterException("The excel file don't exists.");
        }
    }

    private void importExcelTable(Sheet aSheet, String aTableName) throws ExcelImExporterException {
        Optional<ExcelTableManager> tableManagerSearchResult = ExcelImporter.searchTableManager(aTableName);
        if (tableManagerSearchResult.isPresent()) {
            ExcelTableManager tableManager = tableManagerSearchResult.get();
            Collection<Cell> columns = this.readColumns(aSheet);
            Collection<ExcelImExporterField> fields = this.mappColumnsToExcelFields(tableManager, columns);
            Collection<ExcelImExporterField> importableFields = this.removeNotImportableFields(tableManager, fields);
            if (!tableManager.getImportableRequiredExcelFields().isEmpty()) {
                this.checkHasRequiredFields(tableManager, importableFields);
            }
            Collection<? extends DataClass> dataClasses = this.mappToDataclasses(tableManager, aSheet, importableFields);
            for (DataClass dataClass : dataClasses) {
                try {
                    this.finishDataSetProcess();
                    tableManager.getDataController().getMethod("pushData", dataClass.getClass()).invoke(tableManager.getDataController().newInstance(), dataClass);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    LOG.fatal(ExcelImExportErrorTypes.IMPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), (Throwable)exception);
                    ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.IMPORT_FAILED_SYSTEM_ERROR);
                    throw new ExcelImExporterException(errorMessage);
                }
            }
        } else {
            ExcelImExporterWarning warning = new ExcelImExporterWarning(ExcelImExportWarningTypes.TABLE_INVALID_SKIP, String.format(ExcelImExportWarningTypes.TABLE_INVALID_SKIP.getMessageTemplate(), aTableName));
            this.postWarning(warning);
        }
    }

    private void importExcelTable(String aTableName) throws ExcelImExporterException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)Files.newInputStream(this.excelFilePath, new OpenOption[0]));){
            Sheet tableSheet;
            if (this.isMultiTableMode()) {
                tableSheet = workbook.getSheet(aTableName);
                if (tableSheet == null) {
                    ExcelImExporterError error = new ExcelImExporterError(ExcelImExportErrorTypes.TABLE_NAME_INVALID);
                    throw new ExcelImExporterException(error);
                }
            } else {
                tableSheet = workbook.getSheetAt(0);
            }
            this.importExcelTable(tableSheet, aTableName);
        }
        catch (IOException | EncryptedDocumentException exception) {
            LOG.fatal(ExcelImExportErrorTypes.IMPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), exception);
            ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.IMPORT_FAILED_SYSTEM_ERROR);
            throw new ExcelImExporterException(errorMessage);
        }
    }

    private void importExcelTables() throws ExcelImExporterException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)Files.newInputStream(this.excelFilePath, new OpenOption[0]));){
            this.setSubRuns(workbook.getNumberOfSheets());
            ExecutorService executor = Executors.newCachedThreadPool();
            ArrayList<Callable<Void>> importTasks = new ArrayList<Callable<Void>>();
            for (Sheet sheet : workbook) {
                Callable<Void> importTask = () -> {
                    this.importExcelTable(sheet, sheet.getSheetName());
                    this.finishSubRun();
                    return null;
                };
                importTasks.add(importTask);
            }
            List executionResults = executor.invokeAll(importTasks);
            for (Future result : executionResults) {
                result.get();
            }
        }
        catch (IOException | InterruptedException | ExecutionException | EncryptedDocumentException exception) {
            LOG.fatal(ExcelImExportErrorTypes.IMPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), exception);
            ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.IMPORT_FAILED_SYSTEM_ERROR);
            Thread.currentThread().interrupt();
            throw new ExcelImExporterException(errorMessage);
        }
    }

    private Collection<ExcelImExporterField> mappColumnsToExcelFields(ExcelTableManager aTableManager, Collection<Cell> aColumns) throws ExcelImExporterException {
        ArrayList<ExcelImExporterField> fields = new ArrayList<ExcelImExporterField>();
        for (Cell column : aColumns) {
            String columnName = column.getStringCellValue();
            if (aTableManager.hasMappingFilePath()) {
                BidiMap<String, String> mapping = this.loadMapping(aTableManager.getMappingFilePath());
                if (mapping.containsKey(columnName)) {
                    fields.add(new ExcelImExporterField(column.getColumnIndex(), columnName, (String)mapping.get(columnName)));
                    continue;
                }
                ExcelImExporterWarning columnNotInMappingWarning = new ExcelImExporterWarning(ExcelImExportWarningTypes.COLUMN_NOT_IN_MAPPING, String.format(ExcelImExportWarningTypes.COLUMN_NOT_IN_MAPPING.getMessageTemplate(), columnName));
                this.postWarning(columnNotInMappingWarning);
                continue;
            }
            fields.add(new ExcelImExporterField(column.getColumnIndex(), columnName, columnName));
        }
        return fields;
    }

    private DataClass mappToDataclass(Row aRow, ExcelTableManager aTableManager, Collection<ExcelImExporterField> aFields) {
        try {
            DataClass data = aTableManager.getExcelTableClass().cast(aTableManager.getExcelTableClass().newInstance());
            for (ExcelImExporterField excelImExporterField : aFields) {
                aTableManager.getExcelTableClass().getMethod(excelImExporterField.getSetterMethodName(aTableManager.getExcelTableClass()), String.class).invoke((Object)data, new DataFormatter().formatCellValue(aRow.getCell(excelImExporterField.getColumnIndex().intValue())));
            }
            return data;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            LOG.fatal(ExcelImExportErrorTypes.IMPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), (Throwable)exception);
            ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.IMPORT_FAILED_SYSTEM_ERROR);
            throw new IllegalStateException(new ExcelImExporterException(errorMessage));
        }
    }

    private Collection<? extends DataClass> mappToDataclasses(ExcelTableManager aTableManager, Sheet aSheet, Collection<ExcelImExporterField> aFields) {
        List rows = StreamSupport.stream(aSheet.spliterator(), true).collect(Collectors.toList());
        rows = rows.stream().filter(row -> row.getFirstCellNum() != -1).collect(Collectors.toList());
        rows.remove(0);
        this.addDataSetsToProcess(rows.size());
        return rows.parallelStream().map(row -> this.mappToDataclass((Row)row, aTableManager, aFields)).collect(Collectors.toList());
    }

    private Collection<Cell> readColumns(Sheet aSheet) {
        return StreamSupport.stream(aSheet.getRow(0).spliterator(), true).collect(Collectors.toList());
    }

    private Collection<ExcelImExporterField> removeNotImportableFields(ExcelTableManager aTableManager, Collection<ExcelImExporterField> aFields) {
        ArrayList<ExcelImExporterField> importableFields = new ArrayList<ExcelImExporterField>();
        for (ExcelImExporterField field : aFields) {
            if (aTableManager.hasImportableField(field.getFieldName())) {
                importableFields.add(field);
                continue;
            }
            ExcelImExporterWarning fieldNotImportableWarning = new ExcelImExporterWarning(ExcelImExportWarningTypes.FIELD_NOT_IMPORTABLE, String.format(ExcelImExportWarningTypes.FIELD_NOT_IMPORTABLE.getMessageTemplate(), field.getFieldName()));
            this.postWarning(fieldNotImportableWarning);
        }
        return importableFields;
    }
}

