/*
 * Decompiled with CFR 0.152.
 */
package eu.wiegandt.nicklas.simpleexcelimexporter;

import eu.wiegandt.nicklas.simpleexcelimexporter.AbstractExcelImExporter;
import eu.wiegandt.nicklas.simpleexcelimexporter.ExcelImExporterField;
import eu.wiegandt.nicklas.simpleexcelimexporter.ExcelTableManager;
import eu.wiegandt.nicklas.simpleexcelimexporter.api.DataClass;
import eu.wiegandt.nicklas.simpleexcelimexporter.api.DataController;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExportErrorTypes;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterError;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExporter
extends AbstractExcelImExporter {
    private static final Logger LOG = LogManager.getLogger(ExcelExporter.class);
    private XSSFWorkbook workbook;

    @Deprecated
    public void exportToExcel(Collection<String> aTableNames, String aExcelPath) throws ExcelImExporterException {
        this.exportToExcel(aTableNames, Paths.get(aExcelPath, new String[0]));
    }

    public void exportToExcel(Collection<String> aTableNames, Path aExcelPath) throws ExcelImExporterException {
        this.updateProgress();
        this.workbook = new XSSFWorkbook();
        this.setSubRuns(aTableNames.size());
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Callable<Void>> exportTasks = new ArrayList<Callable<Void>>();
        for (String string : aTableNames) {
            Callable<Void> callable = () -> {
                this.exportTable(string);
                this.finishSubRun();
                return null;
            };
            exportTasks.add(callable);
        }
        try {
            List executionResults = executor.invokeAll(exportTasks);
            for (Future future : executionResults) {
                future.get();
            }
            executor.shutdown();
            executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            this.writeToFile(aExcelPath);
        }
        catch (InterruptedException | ExecutionException exception) {
            LOG.fatal(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), (Throwable)exception);
            ExcelImExporterError excelImExporterError = new ExcelImExporterError(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR);
            Thread.currentThread().interrupt();
            throw new ExcelImExporterException(excelImExporterError);
        }
    }

    private void exportTable(String aTableName) throws InstantiationException, IllegalAccessException, ExcelImExporterException {
        Optional<ExcelTableManager> tableManagerOptional = ExcelExporter.searchTableManager(aTableName);
        if (!tableManagerOptional.isPresent()) {
            ExcelImExporterError tableIsNotExportableError = new ExcelImExporterError(ExcelImExportErrorTypes.TABLE_IS_NOT_EXPORTABLE, String.format(ExcelImExportErrorTypes.TABLE_IS_NOT_EXPORTABLE.getMessageTemplate(), aTableName));
            throw new ExcelImExporterException(tableIsNotExportableError);
        }
        BidiMap<String, String> mapping = this.getMapping(tableManagerOptional.get());
        this.linkColumnsWithData(aTableName, mapping, this.pullData(tableManagerOptional.get()));
    }

    private void fillRowWithData(Row aRow, Collection<String> aRowData) {
        Iterator<String> rowIterator = aRowData.iterator();
        for (int cellNum = 0; cellNum < aRowData.size(); ++cellNum) {
            aRow.createCell(cellNum).setCellValue(rowIterator.next());
        }
    }

    private void fillTableWithData(List<Map<String, String>> aMappedDataForExport, Sheet aTableSheet) {
        int rowNum = 0;
        for (Map<String, String> dataMap : aMappedDataForExport) {
            Row newRow = aTableSheet.createRow(rowNum);
            if (rowNum == 0) {
                this.fillRowWithData(newRow, dataMap.keySet());
                this.finishDataSetProcess();
                newRow = aTableSheet.createRow(++rowNum);
            }
            this.fillRowWithData(newRow, dataMap.values());
            ++rowNum;
            this.finishDataSetProcess();
        }
    }

    private String getFieldData(ExcelImExporterField aExcelImExporterField, DataClass aDataClass) {
        try {
            return aDataClass.getClass().getMethod(aExcelImExporterField.getGetterMethodName(aDataClass.getClass()), new Class[0]).invoke((Object)aDataClass, new Object[0]).toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            LOG.fatal(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), (Throwable)exception);
            ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(new ExcelImExporterException(errorMessage));
        }
    }

    private BidiMap<String, String> getMapping(ExcelTableManager aExcelTableManager) throws ExcelImExporterException {
        DualHashBidiMap mapping = new DualHashBidiMap();
        if (aExcelTableManager.hasMappingFilePath()) {
            Collection exportableFieldNames = aExcelTableManager.getExportableExcelFields().parallelStream().map(Field::getName).collect(Collectors.toList());
            BidiMap<String, String> loadedMapping = this.loadMapping(aExcelTableManager.getMappingFilePath());
            mapping.putAll(loadedMapping.entrySet().parallelStream().filter(entry -> exportableFieldNames.contains(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        } else {
            mapping.putAll(aExcelTableManager.getExportableExcelFields().parallelStream().collect(Collectors.toMap(Field::getName, Field::getName)));
        }
        return mapping;
    }

    private void linkColumnsWithData(String aTableName, BidiMap<String, String> aMapping, Collection<? extends DataClass> aDataClasses) {
        List<Map<String, String>> mappedDataForExport = this.mapDataClasses(aDataClasses, aMapping);
        this.addDataSetsToProcess(mappedDataForExport.size() + 1);
        this.writeMappedData(aTableName, mappedDataForExport);
    }

    private Map<String, String> mapDataClass(DataClass aDataClass, BidiMap<String, String> aMapping) {
        return aMapping.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getFieldData(new ExcelImExporterField(null, (String)entry.getKey(), (String)entry.getValue()), aDataClass)));
    }

    private List<Map<String, String>> mapDataClasses(Collection<? extends DataClass> aDataClasses, BidiMap<String, String> aMapping) {
        return aDataClasses.parallelStream().map(dataClass -> this.mapDataClass((DataClass)dataClass, aMapping)).collect(Collectors.toList());
    }

    private Collection<? extends DataClass> pullData(ExcelTableManager aExcelTableManager) throws InstantiationException, IllegalAccessException {
        DataController<? extends DataClass> dataController = aExcelTableManager.getDataController().newInstance();
        return dataController.pullData();
    }

    private synchronized void writeMappedData(String aTableName, List<Map<String, String>> aMappedDataForExport) {
        try {
            XSSFSheet tableSheet = this.workbook.createSheet(aTableName);
            this.fillTableWithData(aMappedDataForExport, (Sheet)tableSheet);
        }
        catch (EncryptedDocumentException encryptedDocumentException) {
            LOG.fatal(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), (Throwable)encryptedDocumentException);
            ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR);
            throw new IllegalStateException(new ExcelImExporterException(errorMessage));
        }
    }

    private synchronized void writeToFile(Path aExcelPath) {
        try {
            this.workbook.write(Files.newOutputStream(aExcelPath, new OpenOption[0]));
            this.workbook.close();
        }
        catch (IOException exception) {
            LOG.fatal(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR.getMessageTemplate(), (Throwable)exception);
            ExcelImExporterError errorMessage = new ExcelImExporterError(ExcelImExportErrorTypes.EXPORT_FAILED_SYSTEM_ERROR);
            throw new IllegalStateException(new ExcelImExporterException(errorMessage));
        }
    }
}

