/*
 * Decompiled with CFR 0.152.
 */
package eu.wiegandt.nicklas.simpleexcelimexporter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import eu.wiegandt.nicklas.simpleexcelimexporter.ExcelImExportObserver;
import eu.wiegandt.nicklas.simpleexcelimexporter.ExcelTableManager;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExportErrorTypes;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterError;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterException;
import eu.wiegandt.nicklas.simpleexcelimexporter.exceptions.ExcelImExporterWarning;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExcelImExporter {
    private static final String ERROR_TEXT_NO_TABLE_MANAGER = "There are no table managers!";
    private static final String ERROR_TEXT_PATTERN_TABLE_NOT_EXISTS = "The table with the name \"%s\" is doesn't exist for im- or export.";
    private static final String ERROR_TEXT_TABLE_MANAGER_IS_NULL = "The given table manager is null. The table manager can't be null!";
    private static final Logger LOG = LogManager.getLogger(AbstractExcelImExporter.class);
    private static final Collection<ExcelImExportObserver> observers = new ArrayList<ExcelImExportObserver>();
    protected static final Collection<ExcelTableManager> tableManagers = new ArrayList<ExcelTableManager>();
    private int dataSetsToProcess;
    private int finishedSubRuns;
    private float percentage;
    private int processedDataSets;
    private int subRuns;

    public AbstractExcelImExporter() {
        if (tableManagers.isEmpty()) {
            throw new IllegalStateException(ERROR_TEXT_NO_TABLE_MANAGER);
        }
        this.dataSetsToProcess = 0;
        this.subRuns = 0;
        this.finishedSubRuns = 0;
        this.processedDataSets = 0;
    }

    public static boolean addTableManager(ExcelTableManager aTableManager) {
        if (aTableManager == null) {
            throw new IllegalArgumentException(ERROR_TEXT_TABLE_MANAGER_IS_NULL);
        }
        return tableManagers.add(aTableManager);
    }

    @Deprecated
    public static void generateCleanMappingFile(String aFilePath, String aTableName) throws IOException {
        AbstractExcelImExporter.generateCleanMappingFile(Paths.get(aFilePath, new String[0]), aTableName);
    }

    public static void generateCleanMappingFile(Path aFilePath, String aTableName) throws IOException {
        block15: {
            Optional<ExcelTableManager> tableManagerOptional = AbstractExcelImExporter.searchTableManager(aTableName);
            if (tableManagerOptional.isPresent()) {
                Map<String, String> mapping = tableManagerOptional.get().getExcelFields().parallelStream().collect(Collectors.toMap(Field::getName, Field::getName));
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                try (BufferedWriter writer = Files.newBufferedWriter(aFilePath, new OpenOption[0]);){
                    gson.toJson(mapping, (Appendable)writer);
                    break block15;
                }
            }
            throw new IllegalArgumentException(String.format(ERROR_TEXT_PATTERN_TABLE_NOT_EXISTS, aTableName));
        }
    }

    public static boolean removeTableManager(ExcelTableManager aTableManager) {
        return tableManagers.remove(aTableManager);
    }

    protected static Optional<ExcelTableManager> searchTableManager(String aTableName) {
        if (tableManagers.isEmpty()) {
            throw new IllegalStateException(ERROR_TEXT_NO_TABLE_MANAGER);
        }
        return tableManagers.parallelStream().filter(excelTableManager -> excelTableManager.getTableName().equalsIgnoreCase(aTableName)).findAny();
    }

    public boolean addObserver(ExcelImExportObserver aExcelImExportObserver) {
        return observers.add(aExcelImExportObserver);
    }

    public boolean removeObserver(ExcelImExportObserver aExcelImExportObserver) {
        return observers.remove(aExcelImExportObserver);
    }

    private synchronized int getUnfinishedSubRuns() {
        int unfinishedSubRuns = this.subRuns - this.finishedSubRuns;
        if (unfinishedSubRuns <= 0) {
            unfinishedSubRuns = 1;
        }
        return unfinishedSubRuns;
    }

    private void updateProgress(float aPercentage) {
        observers.parallelStream().forEach(observer -> observer.updateProgress(aPercentage));
    }

    protected synchronized void addDataSetsToProcess(int aDataSetsToProcess) {
        this.dataSetsToProcess += aDataSetsToProcess;
    }

    protected synchronized void addProcessedDataSets(int aProcessedDataSets) {
        this.processedDataSets += aProcessedDataSets;
        this.calculateProgress();
    }

    protected synchronized void calculateProgress() {
        this.percentage = (float)this.processedDataSets / (float)this.dataSetsToProcess * 100.0f / (float)this.getUnfinishedSubRuns();
        if (Float.isNaN(this.percentage)) {
            this.percentage = 0.0f;
        }
        this.updateProgress(this.percentage);
    }

    protected synchronized void finishDataSetProcess() {
        this.addProcessedDataSets(1);
    }

    protected synchronized void finishSubRun() {
        ++this.finishedSubRuns;
    }

    @Deprecated
    protected BidiMap<String, String> loadMapping(String aMappingFilePath) throws ExcelImExporterException {
        return this.loadMapping(Paths.get(aMappingFilePath, new String[0]));
    }

    protected BidiMap<String, String> loadMapping(Path aMappingFilePath) throws ExcelImExporterException {
        Gson gson = new Gson();
        Type mapType = new TypeToken<DualHashBidiMap<String, String>>(){}.getType();
        try {
            return (BidiMap)gson.fromJson((Reader)Files.newBufferedReader(aMappingFilePath), mapType);
        }
        catch (JsonParseException jsonParseException) {
            LOG.debug(ExcelImExportErrorTypes.MAPPING_NO_FALID_JSON_FILE.getMessageTemplate(), (Throwable)jsonParseException);
            ExcelImExporterError jsonParseError = new ExcelImExporterError(ExcelImExportErrorTypes.MAPPING_NO_FALID_JSON_FILE);
            throw new ExcelImExporterException(jsonParseError);
        }
        catch (IOException ioException) {
            String errorMsg = "This error is a critical bug please report to the Autor.";
            LogManager.getLogger(this.getClass()).fatal("This error is a critical bug please report to the Autor.", (Throwable)ioException);
            throw new IllegalStateException("This error is a critical bug please report to the Autor.", ioException);
        }
    }

    protected void postError(ExcelImExporterError aError) {
        observers.parallelStream().forEach(observer -> observer.newError(aError));
    }

    protected void postWarning(ExcelImExporterWarning aWarning) {
        observers.parallelStream().forEach(observer -> observer.newWarning(aWarning));
    }

    protected synchronized void setSubRuns(int aSubRuns) {
        this.subRuns = aSubRuns;
    }

    protected void updateProgress() {
        this.updateProgress(this.percentage);
    }
}

