/*
 * Decompiled with CFR 0.152.
 */
package eu.wiegandt.nicklas.simpleexcelimexporter;

import eu.wiegandt.nicklas.simpleexcelimexporter.annotations.ExcelField;
import eu.wiegandt.nicklas.simpleexcelimexporter.api.DataClass;

public class ExcelImExporterField {
    private static final String GETTER_METHOD_START = "get";
    private static final String SETTER_METHOD_START = "set";
    private final Integer columnIndex;
    private final String columnName;
    private final String fieldName;

    public ExcelImExporterField(Integer aColumnIndex, String aColumnName, String aFieldName) {
        this.columnIndex = aColumnIndex;
        this.columnName = aColumnName;
        this.fieldName = aFieldName;
    }

    private static String fieldNameToGetterName(ExcelImExporterField aField) {
        return ExcelImExporterField.fieldNameToMethodName(aField, GETTER_METHOD_START);
    }

    private static String fieldNameToMethodName(ExcelImExporterField aField, String aMethodPrefix) {
        String fieldName = aField.getFieldName();
        StringBuilder getterMethodNameBuilder = new StringBuilder();
        getterMethodNameBuilder.append(aMethodPrefix);
        getterMethodNameBuilder.append(fieldName.substring(0, 1).toUpperCase());
        getterMethodNameBuilder.append(fieldName.substring(1));
        return getterMethodNameBuilder.toString();
    }

    private static String fieldNameToSetterName(ExcelImExporterField aField) {
        return ExcelImExporterField.fieldNameToMethodName(aField, SETTER_METHOD_START);
    }

    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getGetterMethodName(Class<? extends DataClass> aDataClass) throws NoSuchFieldException {
        String annotatedGetterMethodName = aDataClass.getDeclaredField(this.fieldName).getAnnotation(ExcelField.class).getterMethod();
        String getterMethodName = annotatedGetterMethodName.isEmpty() ? ExcelImExporterField.fieldNameToGetterName(this) : annotatedGetterMethodName;
        return getterMethodName;
    }

    public String getSetterMethodName(Class<? extends DataClass> aDataClass) throws NoSuchFieldException {
        String annotatedSetterMethodName = aDataClass.getDeclaredField(this.fieldName).getAnnotation(ExcelField.class).setterMethod();
        String setterMethodName = annotatedSetterMethodName.isEmpty() ? ExcelImExporterField.fieldNameToSetterName(this) : annotatedSetterMethodName;
        return setterMethodName;
    }
}

