/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.rdfhdt.hdt.dictionary.impl.DictionaryIDMapping;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.iterator.SequentialSearchIteratorTripleID;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleIDComparator;
import org.rdfhdt.hdt.triples.Triples;
import org.rdfhdt.hdt.util.RDFInfo;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class TriplesListLong
implements TempTriples {
    private ArrayList<TripleID> arrayOfTriples;
    private TripleComponentOrder order;
    private long numValidTriples;
    private boolean sorted = false;

    public TriplesListLong(HDTOptions specification) {
        long numTriples = RDFInfo.getTriples(specification);
        numTriples = numTriples > 0L ? numTriples : 100L;
        this.arrayOfTriples = new ArrayList((int)numTriples);
        String orderStr = specification.get("triplesOrder");
        if (orderStr == null) {
            orderStr = "SPO";
        }
        this.order = TripleComponentOrder.valueOf((String)orderStr);
        this.numValidTriples = 0L;
    }

    public boolean reallocateIfEmpty(int numTriples) {
        if (this.arrayOfTriples.isEmpty()) {
            this.arrayOfTriples = new ArrayList(numTriples);
            return true;
        }
        return false;
    }

    public IteratorTripleID search(TripleID pattern) {
        String patternStr = pattern.getPatternString();
        if (patternStr.equals("???")) {
            return new TriplesListIterator(this);
        }
        return new SequentialSearchIteratorTripleID(pattern, new TriplesListIterator(this));
    }

    public IteratorTripleID searchAll() {
        TripleID all = new TripleID(0L, 0L, 0L);
        return this.search(all);
    }

    public long getNumberOfElements() {
        return this.numValidTriples;
    }

    public long size() {
        return this.getNumberOfElements() * (long)TripleID.size();
    }

    @Override
    public void save(OutputStream output, ControlInfo controlInformation, ProgressListener listener) throws IOException {
        controlInformation.clear();
        controlInformation.setInt("numTriples", this.numValidTriples);
        controlInformation.setFormat("<http://purl.org/HDT/hdt#triplesList>");
        controlInformation.setInt("order", (long)this.order.ordinal());
        controlInformation.save(output);
        DataOutputStream dout = new DataOutputStream(output);
        int count = 0;
        for (TripleID triple : this.arrayOfTriples) {
            if (triple.isValid()) {
                dout.writeInt((int)triple.getSubject());
                dout.writeInt((int)triple.getPredicate());
                dout.writeInt((int)triple.getObject());
                ListenerUtil.notifyCond(listener, "Saving TriplesList", count, this.arrayOfTriples.size());
            }
            ++count;
        }
    }

    @Override
    public void load(InputStream input, ControlInfo controlInformation, ProgressListener listener) throws IOException {
        this.order = TripleComponentOrder.values()[(int)controlInformation.getInt("order")];
        long totalTriples = controlInformation.getInt("numTriples");
        int numRead = 0;
        while ((long)numRead < totalTriples) {
            this.arrayOfTriples.add(new TripleID(IOUtil.readLong(input), IOUtil.readLong(input), IOUtil.readLong(input)));
            ++this.numValidTriples;
            ListenerUtil.notifyCond(listener, "Loading TriplesList", ++numRead, totalTriples);
        }
        this.sorted = false;
    }

    @Override
    public void load(TempTriples input, ProgressListener listener) {
        IteratorTripleID iterator = input.searchAll();
        while (iterator.hasNext()) {
            this.arrayOfTriples.add((TripleID)iterator.next());
            ++this.numValidTriples;
        }
        this.sorted = false;
    }

    @Override
    public void setOrder(TripleComponentOrder order) {
        if (this.order.equals((Object)order)) {
            return;
        }
        this.order = order;
        this.sorted = false;
    }

    @Override
    public TripleComponentOrder getOrder() {
        return this.order;
    }

    @Override
    public boolean insert(TripleID ... triples) {
        for (TripleID triple : triples) {
            this.arrayOfTriples.add(new TripleID(triple));
            ++this.numValidTriples;
        }
        this.sorted = false;
        return true;
    }

    @Override
    public boolean insert(long subject, long predicate, long object) {
        this.arrayOfTriples.add(new TripleID(subject, predicate, object));
        ++this.numValidTriples;
        this.sorted = false;
        return true;
    }

    @Override
    public boolean remove(TripleID ... patterns) {
        boolean removed = false;
        block0: for (TripleID triple : this.arrayOfTriples) {
            for (TripleID pattern : patterns) {
                if (!triple.match(pattern)) continue;
                triple.clear();
                removed = true;
                --this.numValidTriples;
                continue block0;
            }
        }
        return removed;
    }

    @Override
    public void sort(ProgressListener listener) {
        if (!this.sorted) {
            Collections.sort(this.arrayOfTriples, TripleIDComparator.getComparator(this.order));
        }
        this.sorted = true;
    }

    @Override
    public void removeDuplicates(ProgressListener listener) {
        if (this.arrayOfTriples.size() <= 1 || !this.sorted) {
            return;
        }
        if (this.order == TripleComponentOrder.Unknown || !this.sorted) {
            throw new IllegalArgumentException("Cannot remove duplicates unless sorted");
        }
        int j = 0;
        for (int i = 1; i < this.arrayOfTriples.size(); ++i) {
            if (this.arrayOfTriples.get(i).compareTo(this.arrayOfTriples.get(j)) != 0) {
                this.arrayOfTriples.set(++j, this.arrayOfTriples.get(i));
            }
            ListenerUtil.notifyCond(listener, "Removing duplicate triples", i, this.arrayOfTriples.size());
        }
        while (this.arrayOfTriples.size() > j + 1) {
            this.arrayOfTriples.remove(this.arrayOfTriples.size() - 1);
        }
        this.arrayOfTriples.trimToSize();
        this.numValidTriples = j + 1;
    }

    public String toString() {
        return "TriplesList [" + this.arrayOfTriples + "\n order=" + this.order + "]";
    }

    public void populateHeader(Header header, String rootNode) {
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", (CharSequence)"<http://purl.org/HDT/hdt#triplesList>");
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#triplesnumTriples>", this.getNumberOfElements());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#triplesOrder>", (long)this.order.ordinal());
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#triplesList>";
    }

    @Override
    public void generateIndex(ProgressListener listener) {
    }

    @Override
    public void loadIndex(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
    }

    @Override
    public void saveIndex(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
    }

    @Override
    public void clear() {
        this.arrayOfTriples.clear();
        this.numValidTriples = 0L;
        this.order = TripleComponentOrder.Unknown;
        this.sorted = false;
    }

    @Override
    public void load(Triples triples, ProgressListener listener) {
        this.clear();
        IteratorTripleID it = triples.searchAll();
        while (it.hasNext()) {
            TripleID triple = (TripleID)it.next();
            this.insert(triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        this.sorted = false;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mapFromFile(CountInputStream in, File f, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void mapIndex(CountInputStream input, File f, ControlInfo ci, ProgressListener listener) throws IOException {
    }

    @Override
    public void replaceAllIds(DictionaryIDMapping mapSubj, DictionaryIDMapping mapPred, DictionaryIDMapping mapObj) {
        this.sorted = false;
        for (TripleID triple : this.arrayOfTriples) {
            triple.setAll(mapSubj.getNewID(triple.getSubject() - 1L), mapPred.getNewID(triple.getPredicate() - 1L), mapObj.getNewID(triple.getObject() - 1L));
        }
    }

    public class TriplesListIterator
    implements IteratorTripleID {
        private TriplesListLong triplesList;
        private int pos;

        public TriplesListIterator(TriplesListLong triplesList) {
            this.triplesList = triplesList;
            this.pos = 0;
        }

        public boolean hasNext() {
            return (long)this.pos < this.triplesList.getNumberOfElements();
        }

        public TripleID next() {
            return (TripleID)this.triplesList.arrayOfTriples.get(this.pos++);
        }

        public boolean hasPrevious() {
            return this.pos > 0;
        }

        public TripleID previous() {
            return (TripleID)this.triplesList.arrayOfTriples.get(--this.pos);
        }

        public void goToStart() {
            this.pos = 0;
        }

        public long estimatedNumResults() {
            return this.triplesList.getNumberOfElements();
        }

        public ResultEstimationType numResultEstimation() {
            return ResultEstimationType.EXACT;
        }

        public boolean canGoTo() {
            return true;
        }

        public void goTo(long pos) {
            this.pos = (int)pos;
        }

        public TripleComponentOrder getOrder() {
            return this.triplesList.getOrder();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

