/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import org.rdfhdt.hdt.compact.bitmap.AdjacencyList;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;

public class BitmapTriplesIteratorZFOQ
implements IteratorTripleID {
    final BitmapTriples triples;
    final TripleID pattern;
    final TripleID returnTriple;
    AdjacencyList adjY;
    AdjacencyList adjIndex;
    long posIndex;
    long minIndex;
    long maxIndex;
    long x;
    long y;
    long z;
    long patY;
    final long patZ;

    public BitmapTriplesIteratorZFOQ(BitmapTriples triples, TripleID pattern) {
        this.triples = triples;
        this.pattern = new TripleID(pattern);
        this.returnTriple = new TripleID();
        TripleOrderConvert.swapComponentOrder(this.pattern, TripleComponentOrder.SPO, triples.order);
        this.patZ = this.pattern.getObject();
        if (this.patZ == 0L && (this.patY != 0L || this.pattern.getSubject() != 0L)) {
            throw new IllegalArgumentException("This structure is not meant to process this pattern");
        }
        this.patY = this.pattern.getPredicate();
        this.adjY = triples.adjY;
        this.adjIndex = triples.adjIndex;
        this.calculateRange();
        this.goToStart();
    }

    private long getY(long index) {
        return this.adjY.get(this.adjIndex.get(index));
    }

    private void calculateRange() {
        if (this.patZ == 0L) {
            this.minIndex = 0L;
            this.maxIndex = this.adjIndex.getNumberOfElements();
            return;
        }
        this.minIndex = this.adjIndex.find(this.patZ - 1L);
        this.maxIndex = this.adjIndex.last(this.patZ - 1L);
        if (this.patY != 0L) {
            while (this.minIndex <= this.maxIndex) {
                long mid = (this.minIndex + this.maxIndex) / 2L;
                long predicate = this.getY(mid);
                if (this.patY > predicate) {
                    this.minIndex = mid + 1L;
                    continue;
                }
                if (this.patY < predicate) {
                    this.maxIndex = mid - 1L;
                    continue;
                }
                long left = this.minIndex;
                long right = mid;
                long pos = 0L;
                while (left <= right) {
                    pos = (left + right) / 2L;
                    predicate = this.getY(pos);
                    if (predicate != this.patY) {
                        left = pos + 1L;
                        continue;
                    }
                    right = pos - 1L;
                }
                this.minIndex = predicate == this.patY ? pos : pos + 1L;
                left = mid;
                right = this.maxIndex;
                while (left <= right) {
                    pos = (left + right) / 2L;
                    predicate = this.getY(pos);
                    if (predicate != this.patY) {
                        right = pos - 1L;
                        continue;
                    }
                    left = pos + 1L;
                }
                this.maxIndex = predicate == this.patY ? pos : pos - 1L;
                break;
            }
        }
    }

    private void updateOutput() {
        this.returnTriple.setAll(this.x, this.y, this.z);
        TripleOrderConvert.swapComponentOrder(this.returnTriple, this.triples.order, TripleComponentOrder.SPO);
    }

    public boolean hasNext() {
        return this.posIndex <= this.maxIndex;
    }

    public TripleID next() {
        long posY = this.adjIndex.get(this.posIndex);
        this.z = this.patZ != 0L ? this.patZ : this.adjIndex.findListIndex(this.posIndex) + 1L;
        this.y = this.patY != 0L ? this.patY : this.adjY.get(posY);
        this.x = this.adjY.findListIndex(posY) + 1L;
        ++this.posIndex;
        this.updateOutput();
        return this.returnTriple;
    }

    public boolean hasPrevious() {
        return this.posIndex > this.minIndex;
    }

    public TripleID previous() {
        --this.posIndex;
        long posY = this.adjIndex.get(this.posIndex);
        this.z = this.patZ != 0L ? this.patZ : this.adjIndex.findListIndex(this.posIndex) + 1L;
        this.y = this.patY != 0L ? this.patY : this.adjY.get(posY);
        this.x = this.adjY.findListIndex(posY) + 1L;
        this.updateOutput();
        return this.returnTriple;
    }

    public void goToStart() {
        this.posIndex = this.minIndex;
    }

    public long estimatedNumResults() {
        return this.maxIndex - this.minIndex + 1L;
    }

    public ResultEstimationType numResultEstimation() {
        return ResultEstimationType.EXACT;
    }

    public boolean canGoTo() {
        return true;
    }

    public void goTo(long pos) {
        if (pos > this.maxIndex - this.minIndex || pos < 0L) {
            throw new IndexOutOfBoundsException();
        }
        this.posIndex = this.minIndex + pos;
    }

    public TripleComponentOrder getOrder() {
        return this.triples.order;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

