/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.rdfhdt.hdt.compact.bitmap.AdjacencyList;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.Bitmap375;
import org.rdfhdt.hdt.compact.bitmap.BitmapFactory;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.compact.sequence.SequenceFactory;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.iterator.SequentialSearchIteratorTripleID;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIterator;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorY;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorYFOQ;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorZ;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorZFOQ;
import org.rdfhdt.hdt.triples.impl.EmptyTriplesIterator;
import org.rdfhdt.hdt.triples.impl.PredicateIndex;
import org.rdfhdt.hdt.triples.impl.PredicateIndexArray;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.StopWatch;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTriples
implements TriplesPrivate {
    private static final Logger log = LoggerFactory.getLogger(BitmapTriples.class);
    protected TripleComponentOrder order = TripleComponentOrder.SPO;
    protected Sequence seqY;
    protected Sequence seqZ;
    protected Sequence indexZ;
    protected Sequence predicateCount;
    protected Bitmap bitmapY;
    protected Bitmap bitmapZ;
    protected Bitmap bitmapIndexZ;
    protected AdjacencyList adjY;
    protected AdjacencyList adjZ;
    protected AdjacencyList adjIndex;
    public PredicateIndex predicateIndex;
    private boolean isClosed = false;

    public BitmapTriples() {
        this(new HDTSpecification());
    }

    public BitmapTriples(HDTOptions spec) {
        String orderStr = spec.get("triplesOrder");
        if (orderStr != null) {
            this.order = TripleComponentOrder.valueOf((String)orderStr);
        }
        this.bitmapY = BitmapFactory.createBitmap(spec.get("bitmap.y"));
        this.bitmapZ = BitmapFactory.createBitmap(spec.get("bitmap.z"));
        this.seqY = SequenceFactory.createStream(spec.get("seq.y"));
        this.seqZ = SequenceFactory.createStream(spec.get("seq.z"));
        this.adjY = new AdjacencyList(this.seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(this.seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    public BitmapTriples(Sequence seqY, Sequence seqZ, Bitmap bitY, Bitmap bitZ, TripleComponentOrder order) {
        this.seqY = seqY;
        this.seqZ = seqZ;
        this.bitmapY = bitY;
        this.bitmapZ = bitZ;
        this.order = order;
        this.adjY = new AdjacencyList(seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    public Sequence getPredicateCount() {
        return this.predicateCount;
    }

    public void load(IteratorTripleID it, ProgressListener listener) {
        long number = it.estimatedNumResults();
        SequenceLog64 vectorY = new SequenceLog64(BitUtil.log2(number), number);
        SequenceLog64 vectorZ = new SequenceLog64(BitUtil.log2(number), number);
        Bitmap375 bitY = new Bitmap375(number);
        Bitmap375 bitZ = new Bitmap375(number);
        long lastX = 0L;
        long lastY = 0L;
        long lastZ = 0L;
        long numTriples = 0L;
        while (it.hasNext()) {
            TripleID triple = (TripleID)it.next();
            TripleOrderConvert.swapComponentOrder(triple, TripleComponentOrder.SPO, this.order);
            long x = triple.getSubject();
            long y = triple.getPredicate();
            long z = triple.getObject();
            if (x == 0L || y == 0L || z == 0L) {
                throw new IllegalFormatException("None of the components of a triple can be null");
            }
            if (numTriples == 0L) {
                vectorY.append(y);
                vectorZ.append(z);
            } else if (x != lastX) {
                if (x != lastX + 1L) {
                    throw new IllegalFormatException("Upper level must be increasing and correlative.");
                }
                bitY.append(true);
                vectorY.append(y);
                bitZ.append(true);
                vectorZ.append(z);
            } else if (y != lastY) {
                if (y < lastY) {
                    throw new IllegalFormatException("Middle level must be increasing for each parent.");
                }
                bitY.append(false);
                vectorY.append(y);
                bitZ.append(true);
                vectorZ.append(z);
            } else {
                if (z < lastZ) {
                    throw new IllegalFormatException("Lower level must be increasing for each parent.");
                }
                bitZ.append(false);
                vectorZ.append(z);
            }
            lastX = x;
            lastY = y;
            lastZ = z;
            ListenerUtil.notifyCond(listener, "Converting to BitmapTriples", numTriples, numTriples, number);
            ++numTriples;
        }
        if (numTriples > 0L) {
            bitY.append(true);
            bitZ.append(true);
        }
        vectorY.aggressiveTrimToSize();
        vectorZ.trimToSize();
        this.seqY = vectorY;
        this.seqZ = vectorZ;
        this.bitmapY = bitY;
        this.bitmapZ = bitZ;
        this.adjY = new AdjacencyList(this.seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(this.seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    @Override
    public void load(TempTriples triples, ProgressListener listener) {
        triples.setOrder(this.order);
        triples.sort(listener);
        IteratorTripleID it = triples.searchAll();
        this.load(it, listener);
    }

    public IteratorTripleID search(TripleID pattern) {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot search on BitmapTriples if it's already closed");
        }
        if (this.getNumberOfElements() == 0L || pattern.isNoMatch()) {
            return new EmptyTriplesIterator(this.order);
        }
        TripleID reorderedPat = new TripleID(pattern);
        TripleOrderConvert.swapComponentOrder(reorderedPat, TripleComponentOrder.SPO, this.order);
        String patternString = reorderedPat.getPatternString();
        if (patternString.equals("?P?")) {
            if (this.predicateIndex != null) {
                return new BitmapTriplesIteratorYFOQ(this, pattern);
            }
            return new BitmapTriplesIteratorY(this, pattern);
        }
        if (this.indexZ != null && this.bitmapIndexZ != null) {
            if (patternString.equals("?PO") || patternString.equals("??O")) {
                return new BitmapTriplesIteratorZFOQ(this, pattern);
            }
        } else {
            if (patternString.equals("?PO")) {
                return new SequentialSearchIteratorTripleID(pattern, new BitmapTriplesIteratorZ(this, pattern));
            }
            if (patternString.equals("??O")) {
                return new BitmapTriplesIteratorZ(this, pattern);
            }
        }
        BitmapTriplesIterator bitIt = new BitmapTriplesIterator(this, pattern);
        if (patternString.equals("???") || patternString.equals("S??") || patternString.equals("SP?") || patternString.equals("SPO")) {
            return bitIt;
        }
        return new SequentialSearchIteratorTripleID(pattern, bitIt);
    }

    public IteratorTripleID searchAll() {
        return this.search(new TripleID());
    }

    public long getNumberOfElements() {
        if (this.isClosed) {
            return 0L;
        }
        return this.seqZ.getNumberOfElements();
    }

    public long size() {
        if (this.isClosed) {
            return 0L;
        }
        return this.seqY.size() + this.seqZ.size() + this.bitmapY.getSizeBytes() + this.bitmapZ.getSizeBytes();
    }

    @Override
    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ci.clear();
        ci.setFormat(this.getType());
        ci.setInt("order", (long)this.order.ordinal());
        ci.setType(ControlInfo.Type.TRIPLES);
        ci.save(output);
        IntermediateListener iListener = new IntermediateListener(listener);
        this.bitmapY.save(output, iListener);
        this.bitmapZ.save(output, iListener);
        this.seqY.save(output, iListener);
        this.seqZ.save(output, iListener);
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        if (ci.getType() != ControlInfo.Type.TRIPLES) {
            throw new IllegalFormatException("Trying to read a triples section, but was not triples.");
        }
        if (!ci.getFormat().equals(this.getType())) {
            throw new IllegalFormatException("Trying to read BitmapTriples, but the data does not seem to be BitmapTriples");
        }
        this.order = TripleComponentOrder.values()[(int)ci.getInt("order")];
        IntermediateListener iListener = new IntermediateListener(listener);
        this.bitmapY = BitmapFactory.createBitmap(input);
        this.bitmapY.load(input, iListener);
        this.bitmapZ = BitmapFactory.createBitmap(input);
        this.bitmapZ.load(input, iListener);
        this.seqY = SequenceFactory.createStream(input);
        this.seqY.load(input, iListener);
        this.seqZ = SequenceFactory.createStream(input);
        this.seqZ.load(input, iListener);
        this.adjY = new AdjacencyList(this.seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(this.seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    @Override
    public void mapFromFile(CountInputStream input, File f, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        ci.load(input);
        if (ci.getType() != ControlInfo.Type.TRIPLES) {
            throw new IllegalFormatException("Trying to read a triples section, but was not triples.");
        }
        if (!ci.getFormat().equals(this.getType())) {
            throw new IllegalFormatException("Trying to read BitmapTriples, but the data does not seem to be BitmapTriples");
        }
        this.order = TripleComponentOrder.values()[(int)ci.getInt("order")];
        IntermediateListener iListener = new IntermediateListener(listener);
        this.bitmapY = BitmapFactory.createBitmap(input);
        this.bitmapY.load(input, iListener);
        this.bitmapZ = BitmapFactory.createBitmap(input);
        this.bitmapZ.load(input, iListener);
        this.seqY = SequenceFactory.createStream(input, f);
        this.seqZ = SequenceFactory.createStream(input, f);
        this.adjY = new AdjacencyList(this.seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(this.seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    private void createIndexObjectMemoryEfficient() {
        StopWatch global = new StopWatch();
        StopWatch st = new StopWatch();
        long maxCount = 0L;
        long numDifferentObjects = 0L;
        long numReservedObjects = 8192L;
        SequenceLog64 objectCount = new SequenceLog64(BitUtil.log2(this.seqZ.getNumberOfElements()), numReservedObjects, true);
        for (long i = 0L; i < this.seqZ.getNumberOfElements(); ++i) {
            long count;
            long val = this.seqZ.get(i);
            if (val == 0L) {
                throw new RuntimeException("ERROR: There is a zero value in the Z level.");
            }
            if (numReservedObjects < val) {
                while (numReservedObjects < val) {
                    numReservedObjects <<= 1;
                }
                objectCount.resize(numReservedObjects);
            }
            if (numDifferentObjects < val) {
                numDifferentObjects = val;
            }
            maxCount = (count = objectCount.get(val - 1L) + 1L) > maxCount ? count : maxCount;
            objectCount.set(val - 1L, count);
        }
        log.info("Count Objects in {} Max was: {}", (Object)st.stopAndShow(), (Object)maxCount);
        st.reset();
        Bitmap375 bitmapIndex = new Bitmap375(this.seqZ.getNumberOfElements());
        long tmpCount = 0L;
        for (long i = 0L; i < numDifferentObjects; ++i) {
            bitmapIndex.set((tmpCount += objectCount.get(i)) - 1L, true);
        }
        bitmapIndex.set(this.seqZ.getNumberOfElements() - 1L, true);
        log.info("Bitmap in {}", (Object)st.stopAndShow());
        objectCount = null;
        st.reset();
        SequenceLog64 objectInsertedCount = new SequenceLog64(BitUtil.log2(maxCount), numDifferentObjects);
        objectInsertedCount.resize(numDifferentObjects);
        SequenceLog64 objectArray = new SequenceLog64(BitUtil.log2(this.seqY.getNumberOfElements()), this.seqZ.getNumberOfElements());
        objectArray.resize(this.seqZ.getNumberOfElements());
        for (long i = 0L; i < this.seqZ.getNumberOfElements(); ++i) {
            long objectValue = this.seqZ.get(i);
            long posY = i > 0L ? this.bitmapZ.rank1(i - 1L) : 0L;
            long insertBase = objectValue == 1L ? 0L : bitmapIndex.select1(objectValue - 1L) + 1L;
            long insertOffset = objectInsertedCount.get(objectValue - 1L);
            objectInsertedCount.set(objectValue - 1L, insertOffset + 1L);
            objectArray.set(insertBase + insertOffset, posY);
        }
        log.info("Object references in {}", (Object)st.stopAndShow());
        objectInsertedCount = null;
        st.reset();
        long object = 1L;
        long first = 0L;
        long last = bitmapIndex.select1(object) + 1L;
        do {
            long listLen;
            if ((listLen = last - first) == 2L) {
                long bPos;
                long b;
                long aPos = objectArray.get(first);
                long a = this.seqY.get(aPos);
                if (a > (b = this.seqY.get(bPos = objectArray.get(first + 1L)))) {
                    objectArray.set(first, bPos);
                    objectArray.set(first + 1L, aPos);
                }
            } else if (listLen > 2L) {
                long i;
                class Pair {
                    int valueY;
                    int positionY;

                    Pair() {
                    }
                }
                ArrayList<Pair> list = new ArrayList<Pair>((int)listLen);
                for (i = first; i < last; ++i) {
                    Pair p = new Pair();
                    p.positionY = (int)objectArray.get(i);
                    p.valueY = (int)this.seqY.get(p.positionY);
                    list.add(p);
                }
                Collections.sort(list, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        if (o1.valueY == o2.valueY) {
                            return o1.positionY - o2.positionY;
                        }
                        return o1.valueY - o2.valueY;
                    }
                });
                for (i = first; i < last; ++i) {
                    objectArray.set(i, ((Pair)list.get((int)((int)(i - first)))).positionY);
                }
            }
            first = last;
            last = bitmapIndex.select1(object) + 1L;
        } while (++object <= numDifferentObjects);
        log.info("Sort object sublists in {}", (Object)st.stopAndShow());
        st.reset();
        SequenceLog64 predCount = new SequenceLog64(BitUtil.log2(this.seqY.getNumberOfElements()));
        for (long i = 0L; i < this.seqY.getNumberOfElements(); ++i) {
            long val = this.seqY.get(i);
            if (predCount.getNumberOfElements() < val) {
                predCount.resize(val);
            }
            predCount.set(val - 1L, predCount.get(val - 1L) + 1L);
        }
        predCount.trimToSize();
        log.info("Count predicates in {}", (Object)st.stopAndShow());
        this.predicateCount = predCount;
        st.reset();
        this.indexZ = objectArray;
        this.bitmapIndexZ = bitmapIndex;
        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
        log.info("Index generated in {}", (Object)global.stopAndShow());
    }

    private void createIndexObjects() {
        class Pair {
            int valueY;
            int positionY;

            Pair() {
            }
        }
        ArrayList<Pair> inner;
        ArrayList list = new ArrayList();
        System.out.println("Generating HDT Index for ?PO, and ??O queries.");
        long total = this.seqZ.getNumberOfElements();
        for (long i = 0L; i < total; ++i) {
            Pair pair = new Pair();
            pair.positionY = (int)this.adjZ.findListIndex(i);
            pair.valueY = (int)this.seqY.get(pair.positionY);
            long valueZ = this.seqZ.get(i);
            if (list.size() <= (int)valueZ) {
                list.ensureCapacity((int)valueZ);
                while ((long)list.size() < valueZ) {
                    list.add(new ArrayList(1));
                }
            }
            if ((inner = (ArrayList<Pair>)list.get((int)valueZ - 1)) == null) {
                inner = new ArrayList<Pair>(1);
                list.set((int)valueZ - 1, inner);
            }
            inner.add(pair);
            if (i % 100000L != 0L) continue;
            System.out.println("Processed: " + i + " objects out of " + total);
        }
        System.out.println("Serialize object lists");
        SequenceLog64 indexZ = new SequenceLog64(BitUtil.log2(this.seqY.getNumberOfElements()), list.size());
        Bitmap375 bitmapIndexZ = new Bitmap375(this.seqY.getNumberOfElements());
        long pos = 0L;
        total = list.size();
        int i = 0;
        while ((long)i < total) {
            inner = (List)list.get(i);
            Collections.sort(inner, new Comparator<Pair>(){

                @Override
                public int compare(Pair o1, Pair o2) {
                    return o1.valueY - o2.valueY;
                }
            });
            for (int j = 0; j < inner.size(); ++j) {
                indexZ.append(((Pair)inner.get((int)j)).positionY);
                if (j == inner.size() - 1) {
                    bitmapIndexZ.set(pos, true);
                } else {
                    bitmapIndexZ.set(pos, false);
                }
                ++pos;
            }
            if (i % 100000 == 0) {
                System.out.println("Serialized: " + i + " lists out of " + total);
            }
            list.set(i, null);
            ++i;
        }
        SequenceLog64 predCount = new SequenceLog64(BitUtil.log2(this.seqY.getNumberOfElements()));
        for (long i2 = 0L; i2 < this.seqY.getNumberOfElements(); ++i2) {
            long val = this.seqY.get(i2);
            if (predCount.getNumberOfElements() < val) {
                predCount.resize(val);
            }
            predCount.set(val - 1L, predCount.get(val - 1L) + 1L);
        }
        predCount.trimToSize();
        this.predicateCount = predCount;
        this.indexZ = indexZ;
        this.bitmapIndexZ = bitmapIndexZ;
        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
    }

    @Override
    public void generateIndex(ProgressListener listener) {
        this.predicateIndex = new PredicateIndexArray(this);
        this.predicateIndex.generate(listener);
        this.createIndexObjectMemoryEfficient();
    }

    public void populateHeader(Header header, String rootNode) {
        if (rootNode == null || rootNode.length() == 0) {
            throw new IllegalArgumentException("Root node for the header cannot be null");
        }
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", (CharSequence)this.getType());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#triplesnumTriples>", this.getNumberOfElements());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#triplesOrder>", (CharSequence)this.order.toString());
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#triplesBitmap>";
    }

    @Override
    public void saveIndex(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        IntermediateListener iListener = new IntermediateListener(listener);
        ci.clear();
        ci.setType(ControlInfo.Type.INDEX);
        ci.setInt("numTriples", this.getNumberOfElements());
        ci.setInt("order", (long)this.order.ordinal());
        ci.setFormat("<http://purl.org/HDT/hdt#indexFoQ>");
        ci.save(output);
        this.bitmapIndexZ.save(output, iListener);
        this.indexZ.save(output, iListener);
        this.predicateIndex.save(output);
        this.predicateCount.save(output, iListener);
    }

    @Override
    public void loadIndex(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        IntermediateListener iListener = new IntermediateListener(listener);
        if (ci.getType() != ControlInfo.Type.INDEX) {
            throw new IllegalFormatException("Trying to read an Index Section but it was not an Index.");
        }
        if (!"<http://purl.org/HDT/hdt#indexFoQ>".equals(ci.getFormat())) {
            throw new IllegalFormatException("Trying to read wrong format of Index. Remove the .hdt.index file and let the app regenerate it.");
        }
        long numTriples = ci.getInt("numTriples");
        if (this.getNumberOfElements() != numTriples) {
            throw new IllegalFormatException("This index is not associated to the HDT file");
        }
        TripleComponentOrder indexOrder = TripleComponentOrder.values()[(int)ci.getInt("order")];
        if (indexOrder != this.order) {
            throw new IllegalFormatException("The order of the triples is not the same of the index.");
        }
        this.bitmapIndexZ = BitmapFactory.createBitmap(input);
        this.bitmapIndexZ.load(input, iListener);
        this.indexZ = SequenceFactory.createStream(input);
        this.indexZ.load(input, iListener);
        this.predicateIndex = new PredicateIndexArray(this);
        this.predicateIndex.load(input);
        this.predicateCount = SequenceFactory.createStream(input);
        this.predicateCount.load(input, iListener);
        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
    }

    @Override
    public void mapIndex(CountInputStream input, File f, ControlInfo ci, ProgressListener listener) throws IOException {
        IntermediateListener iListener = new IntermediateListener(listener);
        if (ci.getType() != ControlInfo.Type.INDEX) {
            throw new IllegalFormatException("Trying to read an Index Section but it was not an Index.");
        }
        if (!"<http://purl.org/HDT/hdt#indexFoQ>".equals(ci.getFormat())) {
            throw new IllegalFormatException("Trying to read wrong format of Index. Remove the .hdt.index file and let the app regenerate it.");
        }
        long numTriples = ci.getInt("numTriples");
        if (this.getNumberOfElements() != numTriples) {
            throw new IllegalFormatException("This index is not associated to the HDT file");
        }
        TripleComponentOrder indexOrder = TripleComponentOrder.values()[(int)ci.getInt("order")];
        if (indexOrder != this.order) {
            throw new IllegalFormatException("The order of the triples is not the same of the index.");
        }
        this.bitmapIndexZ = BitmapFactory.createBitmap(input);
        this.bitmapIndexZ.load(input, iListener);
        this.indexZ = SequenceFactory.createStream(input, f);
        this.predicateIndex = new PredicateIndexArray(this);
        this.predicateIndex.mapIndex(input, f, iListener);
        this.predicateCount = SequenceFactory.createStream(input, f);
        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (this.seqY != null) {
            this.seqY.close();
            this.seqY = null;
        }
        if (this.seqZ != null) {
            this.seqZ.close();
            this.seqZ = null;
        }
        if (this.indexZ != null) {
            this.indexZ.close();
            this.indexZ = null;
        }
        if (this.predicateCount != null) {
            this.predicateCount.close();
            this.predicateCount = null;
        }
        if (this.predicateIndex != null) {
            this.predicateIndex.close();
            this.predicateIndex = null;
        }
    }

    public TripleComponentOrder getOrder() {
        return this.order;
    }

    public Sequence getIndexZ() {
        return this.indexZ;
    }

    public Sequence getSeqY() {
        return this.seqY;
    }

    public Sequence getSeqZ() {
        return this.seqZ;
    }

    public Bitmap getBitmapY() {
        return this.bitmapY;
    }

    public Bitmap getBitmapZ() {
        return this.bitmapZ;
    }
}

