/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.parsers.JenaNodeFormatter;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserRIOT
implements RDFParserCallback,
StreamRDF {
    private static final Logger log = LoggerFactory.getLogger(RDFParserRIOT.class);
    private RDFParserCallback.RDFCallback callback;
    private TripleString triple = new TripleString();

    public void doParse(String fileName, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        this.callback = callback;
        try {
            InputStream input = IOUtil.getFileInputStream(fileName);
            switch (notation) {
                case NTRIPLES: {
                    RDFDataMgr.parse((StreamRDF)this, (InputStream)input, (Lang)Lang.NTRIPLES);
                    break;
                }
                case NQUAD: {
                    RDFDataMgr.parse((StreamRDF)this, (InputStream)input, (Lang)Lang.NQUADS);
                    break;
                }
                case RDFXML: {
                    RDFDataMgr.parse((StreamRDF)this, (InputStream)input, (String)baseUri, (Lang)Lang.RDFXML);
                    break;
                }
                case N3: 
                case TURTLE: {
                    RDFDataMgr.parse((StreamRDF)this, (InputStream)input, (String)baseUri, (Lang)Lang.TURTLE);
                    break;
                }
                default: {
                    throw new NotImplementedException("Parser not found for format " + notation);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new ParserException((Throwable)e);
        }
        catch (Exception e) {
            log.error("Unexpected exception parsing file: {}", (Object)fileName, (Object)e);
            throw new ParserException((Throwable)e);
        }
    }

    public void doParse(InputStream input, String baseUri, RDFNotation notation, RDFParserCallback.RDFCallback callback) throws ParserException {
        this.callback = callback;
        try {
            switch (notation) {
                case NTRIPLES: {
                    RDFDataMgr.parse((StreamRDF)this, (InputStream)input, (Lang)Lang.NTRIPLES);
                    break;
                }
                case NQUAD: {
                    RDFDataMgr.parse((StreamRDF)this, (InputStream)input, (Lang)Lang.NQUADS);
                    break;
                }
                case RDFXML: {
                    RDFDataMgr.parse((StreamRDF)this, (InputStream)input, (String)baseUri, (Lang)Lang.RDFXML);
                    break;
                }
                case N3: 
                case TURTLE: {
                    RDFDataMgr.parse((StreamRDF)this, (InputStream)input, (String)baseUri, (Lang)Lang.TURTLE);
                    break;
                }
                default: {
                    throw new NotImplementedException("Parser not found for format " + notation);
                }
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception.", (Throwable)e);
            throw new ParserException((Throwable)e);
        }
    }

    public void start() {
    }

    public void triple(Triple parsedTriple) {
        this.triple.setAll((CharSequence)JenaNodeFormatter.format(parsedTriple.getSubject()), (CharSequence)JenaNodeFormatter.format(parsedTriple.getPredicate()), (CharSequence)JenaNodeFormatter.format(parsedTriple.getObject()));
        this.callback.processTriple(this.triple, 0L);
    }

    public void quad(Quad quad) {
        this.triple.setAll((CharSequence)JenaNodeFormatter.format(quad.getSubject()), (CharSequence)JenaNodeFormatter.format(quad.getPredicate()), (CharSequence)JenaNodeFormatter.format(quad.getObject()));
        this.callback.processTriple(this.triple, 0L);
    }

    public void base(String base) {
    }

    public void prefix(String prefix, String iri) {
    }

    public void finish() {
    }
}

