/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.options;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptionsBase;
import org.rdfhdt.hdt.util.crc.CRC16;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;

public class ControlInformation
extends HDTOptionsBase
implements ControlInfo {
    ControlInfo.Type type;
    String format;

    public ControlInfo.Type getType() {
        return this.type;
    }

    public void setType(ControlInfo.Type type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void save(OutputStream output) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC16());
        IOUtil.writeString(out, "$HDT");
        IOUtil.writeByte(out, (byte)this.type.ordinal());
        IOUtil.writeString(out, this.format);
        out.write(0);
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            IOUtil.writeString(out, key + '=' + this.properties.getProperty(key) + ";");
        }
        out.write(0);
        out.writeCRC();
    }

    public void load(InputStream input) throws IOException {
        CRCInputStream in = new CRCInputStream(input, new CRC16());
        String magic = IOUtil.readChars(in, 4);
        if (!magic.equals("$HDT")) {
            throw new IOException("Non-HDT Section");
        }
        try {
            this.type = ControlInfo.Type.values()[IOUtil.readByte(in)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalFormatException("The type of the ControlInformation is unknown for this implementation");
        }
        this.format = IOUtil.readLine(in, '\u0000');
        String propertiesStr = IOUtil.readLine(in, '\u0000');
        for (String item : propertiesStr.split(";")) {
            int pos = item.indexOf(61);
            if (pos == -1) continue;
            String property = item.substring(0, pos);
            String value = item.substring(pos + 1);
            this.properties.put(property, value);
        }
        in.readCRCAndCheck();
    }

    @Override
    public void clear() {
        this.type = ControlInfo.Type.UNKNOWN;
        this.format = null;
        super.clear();
    }
}

