/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratorConcat<T>
implements Iterator<T> {
    private final List<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
    int idx = -1;
    private Iterator<T> current;
    private Iterator<T> removeFrom;
    boolean finished;

    public static <T> Iterator<T> concat(Iterator<T> iter1, Iterator<T> iter2) {
        if (iter2 == null) {
            return iter1;
        }
        if (iter1 == null) {
            return iter2;
        }
        IteratorConcat<T> c = new IteratorConcat<T>();
        c.add(iter1);
        c.add(iter2);
        return c;
    }

    public static <T> Iterable<T> concat(final Iterable<T> iter1, final Iterable<T> iter2) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorConcat.concat(iter1.iterator(), iter2.iterator());
            }
        };
    }

    public void add(Iterator<T> iter) {
        this.iterators.add(iter);
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        while (this.idx < this.iterators.size() - 1) {
            ++this.idx;
            this.current = this.iterators.get(this.idx);
            if (this.current.hasNext()) {
                return true;
            }
            this.current = null;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.removeFrom = this.current;
        return this.current.next();
    }

    @Override
    public void remove() {
        if (null == this.removeFrom) {
            throw new IllegalStateException("no calls to next() since last call to remove()");
        }
        this.removeFrom.remove();
        this.removeFrom = null;
    }
}

