/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator;

import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;

public class SequentialSearchIteratorTripleID
implements IteratorTripleID {
    private final TripleID pattern;
    private final TripleID nextTriple;
    private TripleID previousTriple;
    private final TripleID returnTriple;
    final IteratorTripleID iterator;
    boolean hasMoreTriples;
    boolean hasPreviousTriples;
    boolean goingUp;

    public SequentialSearchIteratorTripleID(TripleID pattern, IteratorTripleID other) {
        this.pattern = pattern;
        this.iterator = other;
        this.hasPreviousTriples = false;
        this.goingUp = true;
        this.nextTriple = new TripleID();
        this.returnTriple = new TripleID();
        this.doFetchNext();
    }

    public boolean hasNext() {
        return this.hasMoreTriples;
    }

    private void doFetchNext() {
        this.hasMoreTriples = false;
        while (this.iterator.hasNext()) {
            TripleID next = (TripleID)this.iterator.next();
            if (!next.match(this.pattern)) continue;
            this.hasMoreTriples = true;
            this.hasPreviousTriples = true;
            this.nextTriple.assign(next);
            break;
        }
    }

    public TripleID next() {
        if (!this.goingUp) {
            this.goingUp = true;
            if (this.hasPreviousTriples) {
                this.doFetchNext();
            }
            this.doFetchNext();
        }
        this.returnTriple.assign(this.nextTriple);
        this.doFetchNext();
        return this.returnTriple;
    }

    public boolean hasPrevious() {
        return this.hasPreviousTriples;
    }

    private void doFetchPrevious() {
        this.hasPreviousTriples = false;
        while (this.iterator.hasPrevious()) {
            TripleID previous = this.iterator.previous();
            if (!previous.match(this.pattern)) continue;
            this.hasPreviousTriples = true;
            this.hasMoreTriples = true;
            this.previousTriple.assign(previous);
            break;
        }
    }

    public TripleID previous() {
        if (this.goingUp) {
            this.goingUp = false;
            if (this.hasMoreTriples) {
                this.doFetchPrevious();
            }
            this.doFetchPrevious();
        }
        this.returnTriple.assign(this.previousTriple);
        this.doFetchPrevious();
        return this.returnTriple;
    }

    public void goToStart() {
        this.iterator.goToStart();
        this.doFetchNext();
    }

    public long estimatedNumResults() {
        return this.iterator.estimatedNumResults();
    }

    public ResultEstimationType numResultEstimation() {
        return ResultEstimationType.UP_TO;
    }

    public boolean canGoTo() {
        return false;
    }

    public void goTo(long pos) {
        throw new IllegalArgumentException("Called goTo() on an unsupported implementation");
    }

    public TripleComponentOrder getOrder() {
        return this.iterator.getOrder();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

