/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTPrivate;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.hdt.TempHDTImporter;
import org.rdfhdt.hdt.hdt.impl.HDTImpl;
import org.rdfhdt.hdt.hdt.impl.TempHDTImporterOnePass;
import org.rdfhdt.hdt.hdt.impl.TempHDTImporterTwoPass;
import org.rdfhdt.hdt.hdt.writer.TripleWriterHDT;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.header.HeaderUtil;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.rdf.TripleWriter;
import org.rdfhdt.hdt.triples.TripleString;

public class HDTManagerImpl
extends HDTManager {
    public HDTOptions doReadOptions(String file) throws IOException {
        return new HDTSpecification(file);
    }

    public HDT doLoadHDT(String hdtFileName, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.loadFromHDT(hdtFileName, listener);
        return hdt;
    }

    protected HDT doMapHDT(String hdtFileName, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.mapFromHDT(new File(hdtFileName), 0L, listener);
        return hdt;
    }

    public HDT doLoadHDT(InputStream hdtFile, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.loadFromHDT(hdtFile, listener);
        return hdt;
    }

    public HDT doLoadIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.loadFromHDT(hdtFileName, listener);
        hdt.loadOrCreateIndex(listener);
        return hdt;
    }

    protected HDT doMapIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.mapFromHDT(new File(hdtFileName), 0L, listener);
        hdt.loadOrCreateIndex(listener);
        return hdt;
    }

    public HDT doLoadIndexedHDT(InputStream hdtFile, ProgressListener listener) throws IOException {
        HDTImpl hdt = new HDTImpl(new HDTSpecification());
        hdt.loadFromHDT(hdtFile, listener);
        hdt.loadOrCreateIndex(listener);
        return hdt;
    }

    public HDT doIndexedHDT(HDT hdt, ProgressListener listener) {
        ((HDTPrivate)hdt).loadOrCreateIndex(listener);
        return hdt;
    }

    public HDT doGenerateHDT(String rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions spec, ProgressListener listener) throws IOException, ParserException {
        String loaderType = spec.get("loader.type");
        TempHDTImporter loader = "two-pass".equals(loaderType) ? new TempHDTImporterTwoPass() : new TempHDTImporterOnePass();
        TempHDT modHdt = loader.loadFromRDF(spec, rdfFileName, baseURI, rdfNotation, listener);
        HDTImpl hdt = new HDTImpl(spec);
        hdt.loadFromModifiableHDT(modHdt, listener);
        hdt.populateHeaderStructure(modHdt.getBaseURI());
        try {
            long originalSize = HeaderUtil.getPropertyLong((Header)modHdt.getHeader(), (String)"_:statistics", (String)"<http://purl.org/HDT/hdt#originalSize>");
            hdt.getHeader().insert((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", originalSize);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        modHdt.close();
        return hdt;
    }

    public HDT doGenerateHDT(Iterator<TripleString> triples, String baseURI, HDTOptions spec, ProgressListener listener) throws IOException {
        TempHDTImporterOnePass loader = new TempHDTImporterOnePass();
        TempHDT modHdt = loader.loadFromTriples(spec, triples, baseURI, listener);
        HDTImpl hdt = new HDTImpl(spec);
        hdt.loadFromModifiableHDT(modHdt, listener);
        hdt.populateHeaderStructure(modHdt.getBaseURI());
        try {
            long originalSize = HeaderUtil.getPropertyLong((Header)modHdt.getHeader(), (String)"_:statistics", (String)"<http://purl.org/HDT/hdt#originalSize>");
            hdt.getHeader().insert((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", originalSize);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        modHdt.close();
        return hdt;
    }

    protected TripleWriter doGetHDTWriter(OutputStream out, String baseURI, HDTOptions hdtFormat) throws IOException {
        return new TripleWriterHDT(baseURI, hdtFormat, out);
    }

    protected TripleWriter doGetHDTWriter(String outFile, String baseURI, HDTOptions hdtFormat) throws IOException {
        return new TripleWriterHDT(baseURI, hdtFormat, outFile, false);
    }
}

