/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySectionMap;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class PFCOptimizedExtractor {
    PFCDictionarySectionMap pfc;
    long numstrings;
    int blocksize;
    ByteBuffer[] buffers;
    ByteBuffer buffer;
    long[] posFirst;
    Sequence blocks;
    long bytebufferIndex = 0L;
    ReplazableString tempString = new ReplazableString();
    long id = 0L;

    public PFCOptimizedExtractor(PFCDictionarySectionMap pfc) {
        this.pfc = pfc;
        this.numstrings = pfc.numstrings;
        this.blocksize = pfc.blocksize;
        this.blocks = pfc.blocks;
        this.posFirst = pfc.posFirst;
        this.buffers = pfc.buffers;
        if (this.numstrings > 0L && this.buffers != null && this.buffers.length > 0) {
            this.buffer = this.buffers[0].duplicate();
        } else {
            if (this.buffers == null) {
                System.err.println("Warning: Mapping a PFC section with null buffers. " + this.numstrings + " / " + this.blocksize + " / " + pfc.dataSize + " / " + pfc.blocks.getNumberOfElements());
            } else if (this.buffers.length == 0) {
                System.err.println("Warning: Mapping a PFC section with buffers but no entries. " + this.numstrings + " / " + this.blocksize + " / " + pfc.dataSize + " / " + pfc.blocks.getNumberOfElements() + " / " + this.buffers);
            }
            this.numstrings = 0L;
        }
    }

    public CharSequence extract(long target) {
        if (target < 1L || target > this.numstrings) {
            throw new IndexOutOfBoundsException("Trying to access position " + target + " but PFC has " + this.numstrings + " elements.");
        }
        if (target > this.id && target < this.id % (long)this.blocksize + (long)this.blocksize) {
            while (this.id < target) {
                if (!this.buffer.hasRemaining()) {
                    this.buffer = this.buffers[(int)(++this.bytebufferIndex)].duplicate();
                    this.buffer.rewind();
                }
                try {
                    if (this.id % (long)this.blocksize == 0L) {
                        this.tempString.replace(this.buffer, 0);
                    } else {
                        long delta = VByte.decode(this.buffer);
                        this.tempString.replace(this.buffer, (int)delta);
                    }
                    ++this.id;
                    if (this.id != target) continue;
                    return new CompactString(this.tempString).getDelayed();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            System.err.println("Not found: " + target + " out of " + this.getNumStrings());
            return null;
        }
        this.id = target;
        long block = (target - 1L) / (long)this.blocksize;
        this.bytebufferIndex = block / 50000L;
        this.buffer = this.buffers[(int)this.bytebufferIndex++].duplicate();
        this.buffer.position((int)(this.blocks.get(block) - this.posFirst[(int)(block / 50000L)]));
        try {
            this.tempString = new ReplazableString();
            this.tempString.replace(this.buffer, 0);
            long stringid = (target - 1L) % (long)this.blocksize;
            for (long i = 0L; i < stringid; ++i) {
                long delta = VByte.decode(this.buffer);
                this.tempString.replace(this.buffer, (int)delta);
            }
            return new CompactString(this.tempString).getDelayed();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getNumStrings() {
        return this.numstrings;
    }
}

