/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySectionBuilder;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.Mutable;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.ReplazableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PFCDictionarySection
implements DictionarySectionPrivate {
    private static final Logger log = LoggerFactory.getLogger(PFCDictionarySection.class);
    public static final int TYPE_INDEX = 2;
    public static final int DEFAULT_BLOCK_SIZE = 16;
    protected byte[] text = new byte[0];
    protected int blocksize;
    protected int numstrings;
    protected SequenceLog64 blocks = new SequenceLog64();

    public PFCDictionarySection(HDTOptions spec) {
        this.blocksize = (int)spec.getInt("pfc.blocksize");
        if (this.blocksize == 0) {
            this.blocksize = 16;
        }
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        this.blocks = new SequenceLog64(BitUtil.log2(other.size()), other.getNumberOfElements() / (long)this.blocksize);
        Iterator it = other.getSortedEntries();
        this.load(it, other.getNumberOfElements(), listener);
    }

    public void load(PFCDictionarySectionBuilder builder) throws IOException {
        builder.finished();
        this.numstrings = builder.getNumstrings();
        this.text = builder.getText();
        this.blocks = builder.getBlocks();
        this.blocksize = builder.getBlocksize();
    }

    public void load(Iterator<CharSequence> it, long numentries, ProgressListener listener) {
        this.blocks = new SequenceLog64(32, numentries / (long)this.blocksize);
        this.numstrings = 0;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(16384);
        CharSequence previousStr = null;
        try {
            while (it.hasNext()) {
                CharSequence str = it.next();
                if (this.numstrings % this.blocksize == 0) {
                    this.blocks.append(byteOut.size());
                    ByteStringUtil.append(byteOut, str, 0);
                } else {
                    int delta = ByteStringUtil.longestCommonPrefix(previousStr, str);
                    VByte.encode(byteOut, delta);
                    ByteStringUtil.append(byteOut, str, delta);
                }
                byteOut.write(0);
                ++this.numstrings;
                previousStr = str;
            }
            this.blocks.append(byteOut.size());
            this.blocks.aggressiveTrimToSize();
            byteOut.flush();
            this.text = byteOut.toByteArray();
        }
        catch (IOException e) {
            log.error("Unexpected exception.", (Throwable)e);
        }
    }

    protected int locateBlock(CharSequence str) {
        int high;
        if (this.blocks.getNumberOfElements() == 0L) {
            return -1;
        }
        int low = 0;
        int max = high = (int)this.blocks.getNumberOfElements() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            if (mid == max) {
                cmp = -1;
            } else {
                int pos = (int)this.blocks.get(mid);
                cmp = ByteStringUtil.strcmp(str, this.text, pos);
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public long locate(CharSequence str) {
        int idblock;
        if (this.text == null || this.blocks == null) {
            return 0L;
        }
        int blocknum = this.locateBlock(str);
        if (blocknum >= 0) {
            return blocknum * this.blocksize + 1;
        }
        if ((blocknum = -blocknum - 2) >= 0 && (idblock = this.locateInBlock(blocknum, str)) != 0) {
            return blocknum * this.blocksize + idblock + 1;
        }
        return 0L;
    }

    public int locateInBlock(int block, CharSequence str) {
        if ((long)block >= this.blocks.getNumberOfElements()) {
            return 0;
        }
        int pos = (int)this.blocks.get(block);
        ReplazableString tempString = new ReplazableString();
        Mutable<Long> delta = new Mutable<Long>(0L);
        int idInBlock = 0;
        int cshared = 0;
        int slen = ByteStringUtil.strlen(this.text, pos);
        tempString.append(this.text, pos, slen);
        pos += slen + 1;
        ++idInBlock;
        while (idInBlock < this.blocksize && pos < this.text.length) {
            pos += VByte.decode(this.text, pos, delta);
            slen = ByteStringUtil.strlen(this.text, pos);
            tempString.replace(delta.getValue().intValue(), this.text, pos, slen);
            if (delta.getValue() >= (long)cshared) {
                if ((cshared += ByteStringUtil.longestCommonPrefix(tempString, str, cshared)) == str.length() && tempString.length() == str.length()) {
                    break;
                }
            } else {
                idInBlock = 0;
                break;
            }
            pos += slen + 1;
            ++idInBlock;
        }
        if (pos >= this.text.length || idInBlock == this.blocksize) {
            idInBlock = 0;
        }
        return idInBlock;
    }

    public CharSequence extract(long id) {
        if (this.text == null || this.blocks == null) {
            return null;
        }
        if (id < 1L || id > (long)this.numstrings) {
            return null;
        }
        int block = (int)((id - 1L) / (long)this.blocksize);
        int stringid = (int)((id - 1L) % (long)this.blocksize);
        int pos = (int)this.blocks.get(block);
        int len = ByteStringUtil.strlen(this.text, pos);
        Mutable<Long> delta = new Mutable<Long>(0L);
        ReplazableString tempString = new ReplazableString();
        tempString.append(this.text, pos, len);
        for (int i = 0; i < stringid; ++i) {
            pos += len + 1;
            pos += VByte.decode(this.text, pos, delta);
            len = ByteStringUtil.strlen(this.text, pos);
            tempString.replace(delta.getValue().intValue(), this.text, pos, len);
        }
        return new CompactString(tempString).getDelayed();
    }

    public long size() {
        return (long)this.text.length + this.blocks.size();
    }

    public long getNumberOfElements() {
        return this.numstrings;
    }

    public Iterator<CharSequence> getSortedEntries() {
        return new Iterator<CharSequence>(){
            int id;
            int pos;
            final Mutable<Long> delta = new Mutable<Long>(0L);
            final ReplazableString tempString = new ReplazableString();

            @Override
            public boolean hasNext() {
                return (long)this.id < PFCDictionarySection.this.getNumberOfElements();
            }

            @Override
            public CharSequence next() {
                int len;
                if (this.id % PFCDictionarySection.this.blocksize == 0) {
                    len = ByteStringUtil.strlen(PFCDictionarySection.this.text, this.pos);
                    this.tempString.replace(0, PFCDictionarySection.this.text, this.pos, len);
                } else {
                    this.pos += VByte.decode(PFCDictionarySection.this.text, this.pos, this.delta);
                    len = ByteStringUtil.strlen(PFCDictionarySection.this.text, this.pos);
                    this.tempString.replace(this.delta.getValue().intValue(), PFCDictionarySection.this.text, this.pos, len);
                }
                this.pos += len + 1;
                ++this.id;
                return new CompactString(this.tempString).getDelayed();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(2);
        VByte.encode(out, this.numstrings);
        VByte.encode(out, this.text.length);
        VByte.encode(out, this.blocksize);
        out.writeCRC();
        this.blocks.save(output, listener);
        out.setCRC(new CRC32());
        IOUtil.writeBuffer(out, this.text, 0, this.text.length, listener);
        out.writeCRC();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        CRCInputStream in = new CRCInputStream(input, new CRC8());
        int type = in.read();
        if (type != 2) {
            throw new IllegalFormatException("Trying to read a DictionarySectionPFC from data that is not of the suitable type");
        }
        this.numstrings = (int)VByte.decode(in);
        long bytes = VByte.decode(in);
        this.blocksize = (int)VByte.decode(in);
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Dictionary Section Plain Front Coding Header.");
        }
        if (bytes > Integer.MAX_VALUE) {
            input.reset();
            throw new IllegalArgumentException("This class cannot process files with a packed buffer bigger than 2GB");
        }
        this.blocks = new SequenceLog64();
        this.blocks.load(input, listener);
        in.setCRC(new CRC32());
        this.text = IOUtil.readBuffer(in, (int)bytes, listener);
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Dictionary Section Plain Front Coding Data.");
        }
    }

    public void close() throws IOException {
        this.text = null;
        this.blocks.close();
        this.blocks = null;
    }
}

